/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vappearances;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.vappearances.NativeSupport;
import org.violetlib.vappearances.VAppearance;
import org.violetlib.vappearances.VAppearanceImpl;

public class VAppearances {
    @NotNull
    private static final Map<String, VAppearance> appearancesByName = new HashMap<String, VAppearance>();
    @NotNull
    private static final Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();
    @NotNull
    public static final String aquaAppearance = "NSAppearanceNameAqua";
    @NotNull
    public static final String darkAquaAppearance = "NSAppearanceNameDarkAqua";
    @NotNull
    public static final String vibrantLightAppearance = "NSAppearanceNameVibrantLight";
    @NotNull
    public static final String vibrantDarkAppearance = "NSAppearanceNameVibrantDark";

    private VAppearances() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VAppearance getAppearance(@NotNull String string) throws IOException {
        Object object = VAppearanceImpl.class;
        synchronized (VAppearanceImpl.class) {
            VAppearance vAppearance = appearancesByName.get(string);
            if (vAppearance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return vAppearance;
            }
            if (!NativeSupport.load()) {
                throw new IOException("Unable to load native library");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = VAppearances.getSystemColorsData(string);
            if (object == null) {
                throw new IOException("Appearance " + string + " is not available");
            }
            vAppearance = VAppearanceImpl.parse((String)object);
            if (vAppearance != null) {
                VAppearances.installAppearance(vAppearance, "requested");
                Class<VAppearanceImpl> clazz = VAppearanceImpl.class;
                synchronized (VAppearanceImpl.class) {
                    VAppearance vAppearance2 = appearancesByName.get(string);
                    assert (vAppearance2 != null);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return vAppearance2;
                }
            }
            throw new IOException("Unable to parse appearance data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VAppearance getApplicationEffectiveAppearance() throws IOException {
        Class<VAppearanceImpl> clazz = VAppearanceImpl.class;
        synchronized (VAppearanceImpl.class) {
            if (!NativeSupport.load()) {
                throw new IOException("Unable to load native library");
            }
            String string = VAppearances.nativeGetApplicationAppearanceName();
            // ** MonitorExit[var1] (shouldn't be in output)
            if (string == null) {
                throw new IOException("Application effective appearance is not available");
            }
            return VAppearances.getAppearance(string);
        }
    }

    private static void appearanceChanged(@NotNull String string) {
        SwingUtilities.invokeLater(() -> VAppearances.installAppearance(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installAppearance(@NotNull String string) {
        VAppearance vAppearance = VAppearanceImpl.parse(string);
        if (vAppearance != null) {
            Class<VAppearances> clazz = VAppearances.class;
            synchronized (VAppearances.class) {
                VAppearanceImpl vAppearanceImpl = (VAppearanceImpl)appearancesByName.get(vAppearance.getName());
                if (vAppearanceImpl == null || !string.equals(vAppearanceImpl.getData())) {
                    VAppearances.installAppearance(vAppearance, "updated");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            System.err.println("VAppearances: invalid data received");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installAppearance(@NotNull VAppearance vAppearance, @NotNull String string) {
        String string2 = vAppearance.getName();
        Class<VAppearances> clazz = VAppearances.class;
        synchronized (VAppearances.class) {
            VAppearanceImpl vAppearanceImpl = (VAppearanceImpl)appearancesByName.get(string2);
            appearancesByName.put(string2, vAppearance);
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(changeListeners);
            if (vAppearanceImpl != null) {
                vAppearanceImpl.setReplacement(vAppearance);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (vAppearanceImpl != null) {
                vAppearanceImpl.setReplacement(vAppearance);
            }
            if (!arrayList.isEmpty()) {
                SwingUtilities.invokeLater(() -> VAppearances.invokeListeners(arrayList, vAppearance));
            }
            return;
        }
    }

    private static void invokeListeners(@NotNull List<ChangeListener> list, @NotNull VAppearance vAppearance) {
        AppearanceChangeEvent appearanceChangeEvent = new AppearanceChangeEvent(vAppearance);
        for (ChangeListener changeListener : list) {
            changeListener.stateChanged(appearanceChangeEvent);
        }
    }

    public static synchronized void addChangeListener(@NotNull ChangeListener changeListener) {
        changeListeners.add(changeListener);
    }

    public static synchronized void removeChangeListener(@NotNull ChangeListener changeListener) {
        changeListeners.remove(changeListener);
    }

    @Nullable
    private static native String getSystemColorsData(@NotNull String var0);

    private static native void registerChangeListener(@Nullable AppearanceChangedListener var0);

    @Nullable
    private static native String nativeGetApplicationAppearanceName();

    static {
        if (NativeSupport.load()) {
            VAppearances.registerChangeListener(VAppearances::appearanceChanged);
        }
    }

    public static class AppearanceChangeEvent
    extends ChangeEvent {
        @NotNull
        private final VAppearance appearance;

        public AppearanceChangeEvent(@NotNull VAppearance vAppearance) {
            super(VAppearances.class);
            this.appearance = vAppearance;
        }

        @NotNull
        public VAppearance getAppearance() {
            return this.appearance;
        }
    }

    private static interface AppearanceChangedListener {
        public void appearanceChanged(@NotNull String var1);
    }
}

