/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.impl.RendererDescriptionsBase;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class ViewRendererDescriptions
extends RendererDescriptionsBase {
    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration buttonConfiguration) {
        int n = JNRPlatformUtils.getPlatformVersion();
        if (n >= 101600) {
            AquaUIPainter.ButtonWidget buttonWidget = buttonConfiguration.getButtonWidget();
            AquaUIPainter.Size size = buttonConfiguration.getSize();
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
                switch (size) {
                    case LARGE: {
                        return new BasicRendererDescription(-1.49f, 0.0f, 0.0f, 0.0f);
                    }
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, -0.49f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, -1.49f, 0.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
                switch (size) {
                    case LARGE: {
                        return new BasicRendererDescription(-1.0f, 0.0f, 1.0f, 0.0f);
                    }
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        return super.getButtonRendererDescription(buttonConfiguration);
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxConfiguration.getSize();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 3.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -1.0f, 3.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 2.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (size) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 2.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 2.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        AquaUIPainter.Orientation orientation = splitPaneDividerConfiguration.getOrientation();
        switch (splitPaneDividerConfiguration.getWidget()) {
            case THIN_DIVIDER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 9.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
            case THICK_DIVIDER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new MultiResolutionRendererDescription(new BasicRendererDescription(-4.0f, 0.0f, 6.0f, 0.0f), new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 0.0f));
            }
            case PANE_SPLITTER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new BasicRendererDescription(-5.0f, 0.0f, 10.0f, 0.0f);
            }
        }
        return null;
    }
}

