/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class SearchFieldMenuIconPainter
implements PainterExtension {
    @NotNull
    protected final TextFieldConfiguration tg;
    @NotNull
    protected final Insetter searchButtonInsets;
    @NotNull
    protected final Colors colors;

    public SearchFieldMenuIconPainter(@NotNull TextFieldConfiguration textFieldConfiguration, @NotNull Insetter insetter, @Nullable VAppearance vAppearance) {
        this.searchButtonInsets = insetter;
        this.tg = textFieldConfiguration;
        this.colors = Colors.getColors(vAppearance);
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        Rectangle2D rectangle2D = this.searchButtonInsets.applyToBounds2D(new Rectangle2D.Float(0.0f, 0.0f, f, f2));
        AquaUIPainter.State state = this.tg.getState();
        boolean bl = state == AquaUIPainter.State.ACTIVE || state == AquaUIPainter.State.PRESSED || state == AquaUIPainter.State.ROLLOVER;
        graphics2D.setColor(bl ? this.colors.get("searchFieldIcon") : this.colors.get("searchFieldIcon_inactive"));
        AquaUIPainter.Size size = this.tg.getSize();
        double d = JNRUtils.size2D(size, 4.0f, 4.0f, 3.0f);
        double d2 = JNRUtils.size2D(size, 2.0f, 2.0f, 1.5f);
        float f3 = JNRUtils.size2D(size, 0.8f, 0.8f, 0.8f);
        double d3 = rectangle2D.getX() + (double)JNRUtils.size2D(size, 11.0f, 10.0f, 10.5f);
        double d4 = d3 + d / 2.0;
        double d5 = d3 + d;
        double d6 = rectangle2D.getY() + (double)JNRUtils.size2D(size, 4.5f, 3.5f, 3.0f);
        double d7 = d6 + d2;
        Path2D.Double double_ = new Path2D.Double();
        ((Path2D)double_).moveTo(d3, d6);
        ((Path2D)double_).lineTo(d4, d7);
        ((Path2D)double_).lineTo(d5, d6);
        graphics2D.setStroke(new BasicStroke(f3));
        graphics2D.draw(double_);
    }
}

