/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class IndeterminateProgressBarPainterExtension
implements PainterExtension {
    @NotNull
    protected final AquaUILayoutInfo uiLayout;
    @NotNull
    protected final IndeterminateProgressIndicatorConfiguration pg;
    @Nullable
    protected final Map<String, Color> colors;
    @NotNull
    protected final Color background;

    public IndeterminateProgressBarPainterExtension(@NotNull AquaUILayoutInfo aquaUILayoutInfo, @NotNull IndeterminateProgressIndicatorConfiguration indeterminateProgressIndicatorConfiguration, @Nullable VAppearance vAppearance) {
        this.uiLayout = aquaUILayoutInfo;
        this.pg = indeterminateProgressIndicatorConfiguration;
        this.colors = vAppearance != null ? vAppearance.getColors() : null;
        this.background = vAppearance != null && vAppearance.isDark() ? new Color(255, 255, 255, 24) : new Color(0, 0, 0, 16);
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        float f3;
        Color color;
        boolean bl = this.pg.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        graphics2D = (Graphics2D)graphics2D.create();
        graphics2D.clip(new Rectangle2D.Float(0.0f, 0.0f, f, f2));
        graphics2D.setColor(this.background);
        graphics2D.fill(new RoundRectangle2D.Float(0.0f, 0.0f, f, f2, 3.0f, 3.0f));
        Color color2 = color = this.colors != null ? this.colors.get("controlAccent") : null;
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        graphics2D.setColor(color);
        int n = 90;
        float f4 = bl ? f2 : f;
        int n2 = (int)(f4 / 4.0f);
        float f5 = (f4 + (float)n2) / (float)n;
        int n3 = this.pg.getAnimationFrame();
        int n4 = (int)Math.floor(f5 * (float)n3 - (float)n2);
        int n5 = (int)Math.ceil(n4 + n2);
        int n6 = Math.round(bl ? f : f2);
        float f6 = f3 = this.pg.getSize() == AquaUIPainter.Size.SMALL ? 3.0f : 6.0f;
        if (bl) {
            int n7 = (int)f4 - n4 - n2;
            graphics2D.fill(new RoundRectangle2D.Float(0.0f, n7, n6, n5 - n4, f3, f3));
        } else {
            graphics2D.fill(new RoundRectangle2D.Float(n4, 0.0f, n5 - n4, n6, f3, f3));
        }
        graphics2D.dispose();
    }
}

