/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;
import org.violetlib.jnr.impl.SliderTickMarkRendererFactory;

public class LinearSliderTickMarkRenderer
extends Renderer {
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer tintedRenderer;
    @NotNull
    protected final Renderer untintedRenderer;

    public LinearSliderTickMarkRenderer(@NotNull SliderConfiguration sliderConfiguration, @NotNull SliderTickMarkRendererFactory sliderTickMarkRendererFactory) {
        this.g = sliderConfiguration;
        this.tintedRenderer = sliderTickMarkRendererFactory.getSliderTickMarkRenderer(sliderConfiguration, true);
        this.untintedRenderer = sliderTickMarkRendererFactory.getSliderTickMarkRenderer(sliderConfiguration, false);
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        int n = this.g.getNumberOfTickMarks();
        if (n < 2) {
            return;
        }
        float f = reusableCompositor.getWidth();
        float f2 = reusableCompositor.getHeight();
        AquaUIPainter.Size size = this.g.getSize();
        boolean bl = this.g.isHorizontal();
        boolean bl2 = this.g.getWidget() == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT;
        double d = this.g.getValue();
        double d2 = JNRUtils.size(size, 2, 2, 1);
        double d3 = JNRUtils.size(size, 8, 8, 7);
        if (bl) {
            f = (float)((double)f - d2);
            double d4 = 0.0;
            double d5 = f / (float)(n - 1);
            for (int i = 0; i < n; ++i) {
                double d6 = bl2 ? 1.0 - d4 / (double)f : d4 / (double)f;
                boolean bl3 = d6 <= d;
                this.drawTick(reusableCompositor, bl3, d4, 0.0, d2, d3);
                d4 += d5;
            }
        } else {
            f2 = (float)((double)f2 - d2);
            double d7 = 0.0;
            double d8 = f2 / (float)(n - 1);
            for (int i = 0; i < n; ++i) {
                double d9 = 1.0 - d7 / (double)f2;
                boolean bl4 = d9 <= d;
                this.drawTick(reusableCompositor, bl4, 0.0, d7, d3, d2);
                d7 += d8;
            }
        }
    }

    private void drawTick(@NotNull ReusableCompositor reusableCompositor, boolean bl, double d, double d2, double d3, double d4) {
        Renderer renderer = bl ? this.tintedRenderer : this.untintedRenderer;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        Renderer renderer2 = Renderer.createOffsetRenderer(renderer, double_);
        renderer2.composeTo(reusableCompositor);
    }
}

