/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.impl.JNRUtils;

public class SliderConfiguration
extends SliderLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isFocused;
    private final double value;

    public SliderConfiguration(@NotNull AquaUIPainter.SliderWidget sliderWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, boolean bl, double d, int n, @NotNull AquaUIPainter.TickMarkPosition tickMarkPosition) {
        super(sliderWidget, size, n, tickMarkPosition);
        this.state = state;
        this.isFocused = bl;
        this.value = d;
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SliderConfiguration sliderConfiguration = (SliderConfiguration)object;
        return this.state == sliderConfiguration.state && this.isFocused == sliderConfiguration.isFocused && this.value == sliderConfiguration.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.isFocused, this.value});
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.isFocused ? " focused" : "";
        return super.toString() + " " + (Object)((Object)this.state) + string + " " + JNRUtils.format2(this.value);
    }
}

