/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SubtreeTreeModel
implements TreeModel,
TreeModelListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private TreeModel target;
    private Object subtreeRoot;
    private Object[] rootPath;

    public SubtreeTreeModel(TreeModel treeModel) {
        this.target = treeModel;
        this.subtreeRoot = treeModel.getRoot();
        this.rootPath = new Object[]{this.subtreeRoot};
        treeModel.addTreeModelListener(this);
    }

    public TreeModel getTargetModel() {
        return this.target;
    }

    public void setPathToRoot(TreePath treePath) {
        this.setPathToRoot(treePath.getPath());
    }

    public void setPathToRoot(Object[] objectArray) {
        Object[] objectArray2 = this.rootPath;
        if (!Arrays.equals(objectArray2, objectArray)) {
            this.rootPath = objectArray;
            this.subtreeRoot = objectArray[objectArray.length - 1];
            this.changeSupport.firePropertyChange("rootPath", objectArray2, objectArray);
            this.fireTreeStructureChanged(this.subtreeRoot, new Object[]{this.rootPath[this.rootPath.length - 1]});
        }
    }

    public TreePath getPathToRoot() {
        return new TreePath(this.rootPath);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.target.getChild(object, n);
    }

    @Override
    public int getChildCount(Object object) {
        return this.target.getChildCount(object);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.target.getIndexOfChild(object, object2);
    }

    @Override
    public Object getRoot() {
        return this.subtreeRoot;
    }

    @Override
    public boolean isLeaf(Object object) {
        return object != this.getRoot() && this.target.isLeaf(object);
    }

    public TreePath toFullPath(TreePath treePath) {
        return treePath == null ? new TreePath(this.rootPath) : new TreePath(this.toFullPath(treePath.getPath()));
    }

    public Object[] toFullPath(Object[] objectArray) {
        LinkedList<Object> linkedList = new LinkedList<Object>(Arrays.asList(objectArray));
        if (objectArray.length > 0) {
            TreeNode treeNode = (TreeNode)objectArray[0];
            while ((treeNode = treeNode.getParent()) != null) {
                linkedList.addFirst(treeNode);
            }
        }
        return linkedList.toArray();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this.target.valueForPathChanged(this.toFullPath(treePath), object);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray) {
        Object[] objectArray2 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    private void fireTreeStructureChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public boolean isDescendant(Object[] objectArray) {
        if (objectArray.length >= this.rootPath.length) {
            for (int i = 0; i < this.rootPath.length; ++i) {
                if (this.rootPath[i] == objectArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object[] toSubPath(Object[] objectArray) {
        if (this.isDescendant(objectArray)) {
            Object[] objectArray2 = new Object[objectArray.length - this.rootPath.length + 1];
            System.arraycopy(objectArray, this.rootPath.length - 1, objectArray2, 0, objectArray2.length);
            return objectArray2;
        }
        return null;
    }

    public boolean isDescendant(TreePath treePath) {
        if (treePath.getPathCount() >= this.rootPath.length) {
            for (int i = 0; i < this.rootPath.length; ++i) {
                if (this.rootPath[i] == treePath.getPathComponent(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TreePath toSubPath(TreePath treePath) {
        Object[] objectArray = this.toSubPath(treePath.getPath());
        return objectArray == null ? null : new TreePath(objectArray);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.toSubPath(treeModelEvent.getPath());
        if (objectArray != null) {
            this.fireTreeNodesChanged(treeModelEvent.getSource(), objectArray, treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.toSubPath(treeModelEvent.getPath());
        if (objectArray != null) {
            this.fireTreeNodesInserted(treeModelEvent.getSource(), objectArray, treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.toSubPath(treeModelEvent.getPath());
        if (objectArray != null) {
            this.fireTreeNodesRemoved(treeModelEvent.getSource(), objectArray, treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.toSubPath(treeModelEvent.getPath());
        if (objectArray != null) {
            this.fireTreeStructureChanged(treeModelEvent.getSource(), objectArray);
        }
    }
}

