/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.AquaFileIcons;
import org.violetlib.aqua.fc.ConcurrentDispatcher;
import org.violetlib.aqua.fc.FileIconService;
import org.violetlib.aqua.fc.FileIconServiceImplBase;
import org.violetlib.aqua.fc.OSXFile;

public class HybridFileIconServiceImpl
extends FileIconServiceImplBase
implements FileIconService {
    @NotNull
    private static final ConcurrentDispatcher dispatcher = new ConcurrentDispatcher();

    @Override
    @NotNull
    public synchronized FileIconService.Request requestIcon(@NotNull File file, int n, float f, @NotNull FileIconService.Handler handler) {
        FileIconServiceImplBase.RequestImpl requestImpl = new FileIconServiceImplBase.RequestImpl(file, handler);
        this.installGenericFileIcon(file, requestImpl);
        if (OSXFile.isAvailable()) {
            dispatcher.dispatch(new Task(file, n, requestImpl, false));
            dispatcher.dispatch(new Task(file, n, requestImpl, true));
        }
        return requestImpl;
    }

    private class Task
    implements Runnable {
        @NotNull
        private final File file;
        private final int size;
        @NotNull
        private final FileIconServiceImplBase.RequestImpl request;
        private final boolean useQuickLook;

        public Task(File file, @NotNull int n, FileIconServiceImplBase.RequestImpl requestImpl, boolean bl) {
            this.file = file;
            this.size = n;
            this.request = requestImpl;
            this.useQuickLook = bl;
        }

        @Override
        public void run() {
            int[][] nArrayArray;
            String string = this.file.getAbsolutePath();
            if (!AquaFileIcons.nativeRenderFileImage(string, this.useQuickLook, true, nArrayArray = new int[2][], this.size, this.size)) {
                if (AquaImageFactory.debugNativeRendering) {
                    String string2 = this.useQuickLook ? "Quick Look" : "Launch Services";
                    AquaUtils.logDebug("Failed to render " + string2 + " image for " + string);
                }
            } else {
                Object object;
                if (AquaImageFactory.debugNativeRendering) {
                    object = this.useQuickLook ? "Quick Look" : "Launch Services";
                    AquaUtils.logDebug("Rendered " + (String)object + " image for " + string);
                }
                object = AquaMultiResolutionImage.createImage(this.size, this.size, nArrayArray[0], nArrayArray[1]);
                int n = this.useQuickLook ? 0 : 30;
                this.request.installImage((Image)object, n);
            }
        }
    }
}

