/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.security.AccessControlException;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;

public class WindowStylePatch {
    private static Boolean isInstalled;
    private static Boolean isNeeded;

    public static void installIfNeeded() {
        if (isInstalled == null && WindowStylePatch.isNeeded()) {
            WindowStylePatch.loadNativeSupport();
        }
    }

    public static boolean isNeeded() {
        if (isNeeded == null) {
            isNeeded = WindowStylePatch.computeIfNeeded();
        }
        return Boolean.TRUE.equals(isNeeded);
    }

    private static Boolean computeIfNeeded() {
        int n = AquaUtils.getJavaVersion();
        return n < 1200000;
    }

    private static void loadNativeSupport() {
        isInstalled = false;
        try {
            String string = AquaNativeSupport.findNativeLibrary(AquaNativeSupport.class, "windowstylepatch");
            if (string == null) {
                WindowStylePatch.reportError("Library not found");
                return;
            }
            System.load(string);
            isInstalled = true;
            AquaUtils.logDebug("VAqua: installed patch for preserving window style bits");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            WindowStylePatch.reportError(unsatisfiedLinkError.getMessage());
        }
        catch (AccessControlException accessControlException) {
            WindowStylePatch.reportError("permission denied: " + accessControlException.getMessage());
        }
        catch (Throwable throwable) {
            WindowStylePatch.reportError(throwable.toString());
            throwable.printStackTrace();
        }
    }

    private static void reportError(String string) {
        String string2 = "WindowStylePatch: Unable to load library: " + string;
        AquaUtils.logError(string2);
    }
}

