/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.BasicColors;
import org.violetlib.aqua.BasicColorsBuilder;
import org.violetlib.aqua.ColorsInstrumentation;
import org.violetlib.aqua.Logger;
import org.violetlib.aqua.TintedEraser;

public class SystemColors {
    @NotNull
    public final BasicColors defaultColors;
    @NotNull
    public final BasicColors lightColors;
    @NotNull
    public final BasicColors darkColors;
    @NotNull
    public final BasicColors highContrastLightColors;
    @NotNull
    public final BasicColors highContrastDarkColors;
    @Nullable
    private final ColorsInstrumentation instrumentation;
    @NotNull
    private final Logger log;

    public SystemColors(int n, @Nullable ColorsInstrumentation colorsInstrumentation, @NotNull Logger logger) {
        this.instrumentation = colorsInstrumentation;
        this.log = logger;
        this.defaultColors = this.createDefaultColors(n);
        this.lightColors = this.createLightColors(n);
        this.darkColors = this.createDarkColors(n);
        this.highContrastLightColors = this.createHighContrastLightColors(n);
        this.highContrastDarkColors = this.createHighContrastDarkColors(n);
    }

    @NotNull
    private BasicColors createDefaultColors(int n) {
        BasicColorsBuilder basicColorsBuilder = new BasicColorsBuilder("Basic", this.instrumentation, this.log);
        basicColorsBuilder.add("clear", 0, 0);
        if (n < 1014) {
            basicColorsBuilder.add("selectedTextBackground_inactive", "unemphasizedSelectedTextBackground");
            basicColorsBuilder.add("selectedCellBackground_inactive", "unemphasizedSelectedTextBackground");
        } else {
            basicColorsBuilder.add("selectedTextBackground_inactive", "clear");
            basicColorsBuilder.add("selectedCellBackground_inactive", "clear");
        }
        basicColorsBuilder.add("texturedWindowBackground", "windowBackground");
        basicColorsBuilder.add("texturedWindowBackground_disabled", "windowBackground_disabled");
        basicColorsBuilder.add("topWindowMarginBackground", "windowBackground");
        basicColorsBuilder.add("topWindowMarginBackground_disabled", "windowBackground_disabled");
        basicColorsBuilder.add("bottomWindowMarginBackground", "windowBackground");
        basicColorsBuilder.add("bottomWindowMarginBackground_disabled", "windowBackground_disabled");
        basicColorsBuilder.add("topTexturedWindowMarginBackground", "texturedWindowBackground");
        basicColorsBuilder.add("topTexturedWindowMarginBackground_disabled", "texturedWindowBackground_disabled");
        basicColorsBuilder.add("bottomTexturedWindowMarginBackground", "texturedWindowBackground");
        basicColorsBuilder.add("bottomTexturedWindowMarginBackground_disabled", "texturedWindowBackground_disabled");
        basicColorsBuilder.add("topWindowDivider", "separator");
        basicColorsBuilder.add("topWindowDivider_disabled", "separator_disabled");
        basicColorsBuilder.add("bottomWindowDivider", "separator");
        basicColorsBuilder.add("bottomWindowDivider_disabled", "separator_disabled");
        basicColorsBuilder.add("topTexturedWindowDivider", "separator");
        basicColorsBuilder.add("topTexturedWindowDivider_disabled", "separator_disabled");
        basicColorsBuilder.add("bottomTexturedWindowDivider", "separator");
        basicColorsBuilder.add("bottomTexturedWindowDivider_disabled", "separator_disabled");
        basicColorsBuilder.add("text_inactive", "text");
        basicColorsBuilder.add("selectedText_inactive", "unemphasizedSelectedText");
        basicColorsBuilder.add("textBackground_inactive", "textBackground");
        basicColorsBuilder.add("searchFieldPrompt", "text_disabled");
        basicColorsBuilder.add("cellBackground", "textBackground");
        basicColorsBuilder.add("selectedCellBackground", "selectedTextBackground");
        basicColorsBuilder.addAll("cell", "text");
        basicColorsBuilder.add("selectedCell_focused", "alternateSelectedControlText");
        basicColorsBuilder.add("selectedCell", "unemphasizedSelectedText");
        basicColorsBuilder.add("selectedCell_inactive", "unemphasizedSelectedText");
        basicColorsBuilder.addAll("texturedToolbarText", "texturedText");
        basicColorsBuilder.addAll("tabText", "segmentedText");
        basicColorsBuilder.addAll("nonexclusiveTexturedText", "texturedText");
        basicColorsBuilder.addAll("nonexclusiveText", "segmentedText");
        basicColorsBuilder.addAll("segmentedSeparatedText", "segmentedText");
        basicColorsBuilder.addAll("nonexclusiveSeparatedText", "segmentedSeparatedText");
        basicColorsBuilder.addAll("nonexclusiveTexturedToolbarText", "nonexclusiveTexturedText");
        basicColorsBuilder.addAll("texturedSegmentedText", "segmentedText");
        basicColorsBuilder.addAll("texturedSegmentedToolbarText", "texturedSegmentedText");
        basicColorsBuilder.addAll("gradientSegmentedText", "gradientText");
        basicColorsBuilder.addAll("pushPopText", "pushButtonText");
        basicColorsBuilder.addAll("roundedRectText", "gradientText", 1);
        basicColorsBuilder.addAll("bevelText", "gradientText", 1);
        basicColorsBuilder.defineNoInactive("pushButtonText");
        basicColorsBuilder.addAll("segmentedText", "pushButtonText", 1);
        basicColorsBuilder.add("segmentedText_pressed", "segmentedText");
        basicColorsBuilder.add("selectedSegmentedText_pressed", "selectedSegmentedText");
        basicColorsBuilder.add("texturedSegmentedText_pressed", "texturedSegmentedText");
        basicColorsBuilder.add("selectedTexturedSegmentedText_pressed", "selectedTexturedSegmentedText");
        basicColorsBuilder.add("nonexclusiveTexturedText_pressed", "nonexclusiveTexturedText");
        basicColorsBuilder.add("selectedNonexclusiveTexturedText_pressed", "selectedNonexclusiveTexturedText");
        basicColorsBuilder.add("texturedSegmentedToolbarText_pressed", "texturedSegmentedToolbarText");
        basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_pressed", "selectedTexturedSegmentedToolbarText");
        basicColorsBuilder.add("nonexclusiveTexturedToolbarText_pressed", "nonexclusiveTexturedToolbarText");
        basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_pressed", "selectedNonexclusiveTexturedToolbarText");
        basicColorsBuilder.defineNoInactive("gradientText");
        basicColorsBuilder.add("selectedGradientText_disabled", "gradientText_disabled");
        return basicColorsBuilder.get();
    }

    @NotNull
    private BasicColors createLightColors(int n) {
        BasicColorsBuilder basicColorsBuilder = new BasicColorsBuilder("Light", this.instrumentation, this.log);
        basicColorsBuilder.add("texturedWindowBackground", 212);
        basicColorsBuilder.add("texturedWindowBackground_disabled", 246);
        basicColorsBuilder.add("capsLockIcon", 0, 100);
        basicColorsBuilder.add("searchFieldPrompt", 0, 63);
        if (n < 1014) {
            basicColorsBuilder.add("text_disabled", 0, 89);
            basicColorsBuilder.add("textBackground_disabled", 255, 89);
            basicColorsBuilder.add("windowBackground", 236);
            basicColorsBuilder.add("separator_disabled", 0, 8);
            basicColorsBuilder.add("alternateSelectedControlText_disabled", 255, 89);
            basicColorsBuilder.add("selectedMenuItemText", 255);
        }
        basicColorsBuilder.add("windowBackground_disabled", "windowBackground");
        if (n < 1014) {
            basicColorsBuilder.add("systemBlue_disabled", 0, 122, 255, 89);
            basicColorsBuilder.add("systemGray_disabled", 143, 143, 148, 89);
            basicColorsBuilder.add("systemGreen_disabled", 41, 204, 64, 89);
            basicColorsBuilder.add("systemOrange_disabled", 255, 148, 0, 89);
            basicColorsBuilder.add("systemPurple_disabled", 89, 87, 214, 89);
            basicColorsBuilder.add("systemRed_disabled", 255, 59, 48, 89);
            basicColorsBuilder.add("systemYellow_disabled", 255, 204, 0, 89);
        }
        basicColorsBuilder.add("tagBlue", 52, 148, 255);
        basicColorsBuilder.add("tagGray", 164, 164, 168);
        basicColorsBuilder.add("tagGreen", 91, 215, 105);
        basicColorsBuilder.add("tagOrange", 255, 170, 71);
        basicColorsBuilder.add("tagPurple", 190, 118, 229);
        basicColorsBuilder.add("tagRed", 255, 99, 92);
        basicColorsBuilder.add("tagYellow", 254, 214, 75);
        basicColorsBuilder.add("tagBlue_disabled", 155, 203, 255);
        basicColorsBuilder.add("tagGray_disabled", 210, 210, 212);
        basicColorsBuilder.add("tagGreen_disabled", 175, 236, 181);
        basicColorsBuilder.add("tagOrange_disabled", 255, 213, 165);
        basicColorsBuilder.add("tagPurple_disabled", 223, 187, 243);
        basicColorsBuilder.add("tagRed_disabled", 255, 177, 175);
        basicColorsBuilder.add("tagYellow_disabled", 254, 235, 168);
        if (n == 1013) {
            basicColorsBuilder.add("openOptionsArea", 205);
            basicColorsBuilder.add("saveOptionsArea", 229);
        } else if (n >= 1014) {
            basicColorsBuilder.add("openOptionsArea", 212);
            basicColorsBuilder.add("saveOptionsArea", 236);
        }
        basicColorsBuilder.add("selectedBrowserExpandArrow", 110);
        basicColorsBuilder.add("selectedBrowserExpandArrow_focused", 255);
        basicColorsBuilder.add("browserExpandArrow", 127);
        basicColorsBuilder.add("scrollPaneGrabber", 163);
        basicColorsBuilder.add("scrollPaneBorder", 197);
        basicColorsBuilder.add("texturedText", 0, 170);
        basicColorsBuilder.add("texturedText_focused", 0);
        basicColorsBuilder.add("texturedText_disabled", 0, 64);
        basicColorsBuilder.add("texturedText_inactive", 178);
        basicColorsBuilder.add("texturedText_pressed", 34);
        basicColorsBuilder.add("texturedText_inactive_disabled", 211);
        if (n < 1016) {
            basicColorsBuilder.add("selectedTexturedText", 255);
            basicColorsBuilder.add("selectedTexturedText_disabled", 255, 155);
            basicColorsBuilder.add("selectedTexturedText_pressed", "selectedTexturedText");
            basicColorsBuilder.add("selectedTexturedText_inactive", 164);
            basicColorsBuilder.add("selectedTexturedText_inactive_disabled", 185);
        }
        basicColorsBuilder.add("recessedText", 0, 160);
        basicColorsBuilder.add("recessedText_disabled", 0, 64);
        basicColorsBuilder.add("recessedText_inactive", 0, 64);
        basicColorsBuilder.add("recessedText_pressed", 255);
        basicColorsBuilder.add("recessedText_rollover", 255);
        basicColorsBuilder.add("recessedText_inactive_disabled", 0, 32);
        if (n >= 1016) {
            basicColorsBuilder.add("recessedText", 0, 140);
            basicColorsBuilder.add("selectedRecessedText", 0, 206);
            basicColorsBuilder.add("selectedRecessedText_disabled", 0, 64);
            basicColorsBuilder.add("selectedRecessedText_pressed", 0, 140);
            basicColorsBuilder.add("selectedRecessedText_rollover", 0, 140);
            basicColorsBuilder.add("selectedRecessedText_inactive", 0, 64);
            basicColorsBuilder.add("selectedRecessedText_inactive_disabled", 0, 32);
        }
        basicColorsBuilder.add("pushButtonText", 34);
        basicColorsBuilder.add("pushButtonText_disabled", 0, 64);
        basicColorsBuilder.add("pushButtonText_pressed", 255, 224);
        basicColorsBuilder.add("pushButtonText_focused", 250);
        basicColorsBuilder.add("selectedPushButtonText", "alternateSelectedControlText");
        basicColorsBuilder.add("pushPopText_pressed", 0, 224);
        if (n >= 1016) {
            basicColorsBuilder.addAll("segmentedText", "controlText");
            basicColorsBuilder.add("segmentedText_inactive", 0, 240);
            basicColorsBuilder.add("segmentedText_disabled_inactive", 0, 78);
            basicColorsBuilder.add("selectedSegmentedText_disabled", 0, 78);
            basicColorsBuilder.add("selectedSegmentedText_disabled_inactive", 0, 78);
            basicColorsBuilder.add("selectedSegmentedText_inactive", 34);
            basicColorsBuilder.add("selectedSegmentedSeparatedText", 255);
            basicColorsBuilder.add("selectedSegmentedSeparatedText_disabled", 255, 140);
            basicColorsBuilder.add("selectedSegmentedSeparatedText_inactive", 34);
            basicColorsBuilder.add("selectedGradientSegmentedText", 255);
            basicColorsBuilder.add("selectedGradientSegmentedText_disabled", 255, 128);
            basicColorsBuilder.add("selectedNonexclusiveText", 255);
            basicColorsBuilder.add("selectedNonexclusiveText_disabled", 255, 140);
        } else {
            basicColorsBuilder.add("selectedSegmentedText", 255);
            basicColorsBuilder.add("selectedSegmentedText_disabled", 172);
            basicColorsBuilder.add("selectedSegmentedText_inactive", 34);
            if (n == 1014 || n == 1015) {
                basicColorsBuilder.add("selectedGradientSegmentedText", 255);
                basicColorsBuilder.add("selectedGradientSegmentedText_disabled", 255, 144);
            }
        }
        if (n < 1011) {
            basicColorsBuilder.add("selectedNonexclusiveTexturedText", 0, 122, 255);
            basicColorsBuilder.add("selectedNonexclusiveTexturedText_disabled", 0, 122, 255, 120);
        } else if (n < 1014) {
            basicColorsBuilder.add("selectedNonexclusiveTexturedText", 37, 125, 252);
            basicColorsBuilder.add("selectedNonexclusiveTexturedText_disabled", 37, 125, 252, 120);
        } else {
            basicColorsBuilder.add("selectedNonexclusiveTexturedText", "controlAccent");
            basicColorsBuilder.add("selectedNonexclusiveTexturedText_rollover", "controlAccent");
            basicColorsBuilder.add("selectedNonexclusiveTexturedText_disabled", "controlAccent_disabled");
            basicColorsBuilder.add("selectedNonexclusiveTexturedText_inactive", "segmentedText_disabled");
        }
        if (n >= 1016) {
            basicColorsBuilder.add("texturedSegmentedText", "controlText");
            basicColorsBuilder.add("selectedTexturedSegmentedText_disabled", 64);
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText", 0, 178);
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText", 0, 192);
            basicColorsBuilder.add("texturedSegmentedToolbarText", 0, 178);
            basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_inactive", 0, 152);
            basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_rollover", "controlAccent");
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText_inactive", 0, 86);
            basicColorsBuilder.add("texturedSegmentedToolbarText_inactive", 0, 86);
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText_disabled", 0, 86);
            basicColorsBuilder.add("texturedSegmentedToolbarText_disabled", 0, 86);
            basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_inactive_disabled", 0, 36);
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText_inactive_disabled", 0, 36);
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_inactive_disabled", 0, 20);
            basicColorsBuilder.add("texturedSegmentedToolbarText_inactive_disabled", 0, 36);
        } else {
            basicColorsBuilder.add("texturedSegmentedText", 0, 150);
            basicColorsBuilder.add("texturedSegmentedText_disabled", 0, 64);
            basicColorsBuilder.add("texturedSegmentedText_inactive", 0, 64);
            basicColorsBuilder.add("texturedSegmentedText_inactive_disabled", 0, 32);
            basicColorsBuilder.add("selectedTexturedSegmentedText_disabled", 255, 144);
            basicColorsBuilder.add("selectedTexturedSegmentedText_inactive_disabled", 0, 32);
        }
        basicColorsBuilder.add("selectedTexturedSegmentedText_inactive", 0, 64);
        if (n < 1014) {
            basicColorsBuilder.add("gradientText", 0, 216);
        } else {
            basicColorsBuilder.add("gradientText", "controlText");
        }
        basicColorsBuilder.add("gradientText_disabled", 0, 64);
        basicColorsBuilder.add("selectedGradientText", 0, 216);
        basicColorsBuilder.add("roundText", 0, 220);
        basicColorsBuilder.add("selectedRoundText", 255);
        basicColorsBuilder.add("roundText_disabled", 0, 64);
        basicColorsBuilder.add("selectedRoundText_disabled", 0, 64);
        basicColorsBuilder.add("toolbarItemText", 89);
        basicColorsBuilder.add("toolbarItemText_disabled", 150);
        basicColorsBuilder.add("toolbarItemText_inactive", 172);
        basicColorsBuilder.add("toolbarItemText_inactive_disabled", 172);
        basicColorsBuilder.add("toolbarItemText_focused", 250);
        basicColorsBuilder.add("selectedToolbarItemText", 81);
        basicColorsBuilder.add("selectedToolbarItemText_disabled", 172);
        basicColorsBuilder.add("selectedToolbarItemText_inactive", 153);
        basicColorsBuilder.add("selectedToolbarItemText_inactive_disabled", 198);
        if (n < 1014) {
            basicColorsBuilder.add("inlineButtonText", 255);
            basicColorsBuilder.add("inlineButtonText_inactive", "inlineButtonText");
            basicColorsBuilder.add("inlineButtonText_disabled", 0, 64);
            basicColorsBuilder.add("inlineButtonText_pressed", 255, 224);
        } else if (n < 1016) {
            basicColorsBuilder.add("inlineButtonText", 255, 224);
            basicColorsBuilder.add("inlineButtonText_inactive", "inlineButtonText");
            basicColorsBuilder.add("inlineButtonText_disabled", 0, 64);
            basicColorsBuilder.add("inlineButtonText_pressed", 255, 224);
        } else {
            basicColorsBuilder.add("inlineButtonText", 0, 140);
            basicColorsBuilder.add("inlineButtonText_disabled", 0, 80);
        }
        basicColorsBuilder.add("categoryText", 30, 220);
        basicColorsBuilder.add("expandControl", 30, 220);
        basicColorsBuilder.add("sidebarBorder", 220);
        basicColorsBuilder.add("sidebarIcon", 30, 220);
        basicColorsBuilder.add("treeIcon", 140);
        basicColorsBuilder.add("tableHeader", 37);
        basicColorsBuilder.add("tableHeader_disabled", 37);
        basicColorsBuilder.add("selectedTableHeader", 37);
        basicColorsBuilder.add("tableHeaderBackground", 240);
        basicColorsBuilder.add("tableHeaderBackground_disabled", 246);
        basicColorsBuilder.add("tableHeaderSeparator", 192);
        basicColorsBuilder.add("tableHeaderSeparator_disabled", 197);
        basicColorsBuilder.add("browserColumnSeparator", 128);
        if (n < 1014) {
            basicColorsBuilder.addColorGradient("topTexturedWindowMarginBackground", 255, 194, 120);
            basicColorsBuilder.addAlphaGradient("bottomTexturedWindowMarginBackground", 255, 104, 28);
            basicColorsBuilder.addAlphaGradient("topWindowMarginBackground", 0, 4, 28);
            basicColorsBuilder.addAlphaGradient("bottomWindowMarginBackground", 0, 8, 22);
        } else {
            basicColorsBuilder.addColorGradient("topTexturedWindowMarginBackground", 255, 180, 80);
            basicColorsBuilder.addAlphaGradient("bottomTexturedWindowMarginBackground", 255, 144, 8);
            basicColorsBuilder.addAlphaGradient("topWindowMarginBackground", 0, 8, 36);
            basicColorsBuilder.addAlphaGradient("bottomWindowMarginBackground", 0, 0, 24);
        }
        basicColorsBuilder.add("topWindowMarginBackground_disabled", 246);
        basicColorsBuilder.add("bottomWindowMarginBackground_disabled", 246);
        basicColorsBuilder.add("topTexturedWindowBackground_disabled", 246);
        basicColorsBuilder.add("bottomTexturedWindowBackground_disabled", 246);
        if (n < 1014) {
            basicColorsBuilder.add("topWindowDivider", 0, 36);
            basicColorsBuilder.add("topWindowDivider_disabled", 0, 28);
            basicColorsBuilder.add("bottomWindowDivider", 0, 36);
            basicColorsBuilder.add("bottomWindowDivider_disabled", 0, 38);
        } else {
            basicColorsBuilder.add("topWindowDivider", 0, 32);
            basicColorsBuilder.add("topWindowDivider_disabled", 0, 28);
            basicColorsBuilder.add("bottomWindowDivider", 0, 28);
            basicColorsBuilder.add("bottomWindowDivider_disabled", 0, 28);
        }
        basicColorsBuilder.add("topTexturedWindowDivider", 0, 32);
        basicColorsBuilder.add("topTexturedWindowDivider_disabled", 0, 28);
        basicColorsBuilder.add("bottomTexturedWindowDivider", 0, 56);
        basicColorsBuilder.add("bottomTexturedWindowDivider_disabled", 0, 28);
        return basicColorsBuilder.get();
    }

    @NotNull
    private BasicColors createHighContrastLightColors(int n) {
        BasicColorsBuilder basicColorsBuilder = new BasicColorsBuilder("High Contrast Light", this.instrumentation, this.log);
        if (n < 1014) {
            basicColorsBuilder.add("windowBackground", 246);
            basicColorsBuilder.add("windowBackground_disabled", 246);
            basicColorsBuilder.add("texturedWindowBackground", 207);
        } else {
            basicColorsBuilder.add("windowBackground", 236);
            basicColorsBuilder.add("windowBackground_disabled", 236);
            basicColorsBuilder.add("texturedWindowBackground", 212);
        }
        if (n < 1014) {
            basicColorsBuilder.addAlphaGradient("topWindowMarginBackground", 0, 16, 40);
            basicColorsBuilder.addAlphaGradient("bottomWindowMarginBackground", 0, 22, 36);
        } else {
            basicColorsBuilder.addAlphaGradient("topWindowMarginBackground", 0, 8, 34);
            basicColorsBuilder.addAlphaGradient("bottomWindowMarginBackground", 0, 0, 26);
            basicColorsBuilder.addColorGradient("topTexturedWindowMarginBackground", 255, 200, 104);
            basicColorsBuilder.addAlphaGradient("bottomTexturedWindowMarginBackground", 255, 144, 8);
        }
        int n2 = 0;
        int n3 = n < 1014 ? 64 : 74;
        basicColorsBuilder.add("topWindowDivider", n2, n3);
        basicColorsBuilder.add("bottomWindowDivider", n2, n3);
        basicColorsBuilder.add("topTexturedWindowDivider", n2, n3);
        basicColorsBuilder.add("bottomTexturedWindowDivider", n2, n3);
        basicColorsBuilder.add("topWindowDivider_disabled", n2, n3);
        basicColorsBuilder.add("bottomWindowDivider_disabled", n2, n3);
        basicColorsBuilder.add("topTexturedWindowDivider_disabled", n2, n3);
        basicColorsBuilder.add("bottomTexturedWindowDivider_disabled", n2, n3);
        basicColorsBuilder.add("tagBlue", 68, 171, 229);
        basicColorsBuilder.add("tagGray", 164, 164, 167);
        basicColorsBuilder.add("tagGreen", 72, 188, 79);
        basicColorsBuilder.add("tagOrange", 234, 147, 66);
        basicColorsBuilder.add("tagPurple", 160, 106, 188);
        basicColorsBuilder.add("tagRed", 255, 99, 92);
        basicColorsBuilder.add("tagYellow", 248, 192, 73);
        basicColorsBuilder.add("tagBlue_disabled", 163, 214, 242);
        basicColorsBuilder.add("tagGray_disabled", 210, 210, 211);
        basicColorsBuilder.add("tagGreen_disabled", 166, 223, 168);
        basicColorsBuilder.add("tagOrange_disabled", 245, 202, 162);
        basicColorsBuilder.add("tagPurple_disabled", 208, 182, 222);
        basicColorsBuilder.add("tagRed_disabled", 255, 177, 175);
        basicColorsBuilder.add("tagYellow_disabled", 252, 224, 167);
        basicColorsBuilder.add("scrollPaneGrabber", 87);
        basicColorsBuilder.add("scrollPaneBorder", 0, 128);
        return basicColorsBuilder.get();
    }

    @NotNull
    private BasicColors createDarkColors(int n) {
        BasicColorsBuilder basicColorsBuilder = new BasicColorsBuilder("Dark", this.instrumentation, this.log);
        basicColorsBuilder.add("capsLockIcon", 255, 96);
        basicColorsBuilder.add("searchFieldPrompt", 255, 63);
        basicColorsBuilder.add("windowBackground_disabled", 45);
        basicColorsBuilder.add("texturedWindowBackground", 42);
        basicColorsBuilder.add("texturedWindowBackground_disabled", 45);
        basicColorsBuilder.add("tagBlue", 63, 157, 255);
        basicColorsBuilder.add("tagGray", 172, 172, 176);
        basicColorsBuilder.add("tagGreen", 97, 223, 113);
        basicColorsBuilder.add("tagOrange", 255, 178, 75);
        basicColorsBuilder.add("tagPurple", 204, 124, 245);
        basicColorsBuilder.add("tagRed", 255, 107, 99);
        basicColorsBuilder.add("tagYellow", 255, 222, 78);
        basicColorsBuilder.add("tagBlue_disabled", 47, 94, 142);
        basicColorsBuilder.add("tagGray_disabled", 100, 101, 103);
        basicColorsBuilder.add("tagGreen_disabled", 64, 126, 72);
        basicColorsBuilder.add("tagOrange_disabled", 142, 104, 53);
        basicColorsBuilder.add("tagPurple_disabled", 117, 77, 137);
        basicColorsBuilder.add("tagRed_disabled", 142, 68, 64);
        basicColorsBuilder.add("tagYellow_disabled", 142, 126, 55);
        basicColorsBuilder.add("cellBackground", "clear");
        basicColorsBuilder.add("selectedCellBackground_inactive", "selectedTextBackground_inactive");
        basicColorsBuilder.add("cell", "controlText");
        basicColorsBuilder.add("selectedCell", "controlText");
        basicColorsBuilder.add("selectedCell_focused", "alternateSelectedControlText");
        basicColorsBuilder.add("selectedCell_inactive", "controlText");
        basicColorsBuilder.add("openOptionsArea", 42);
        basicColorsBuilder.add("openOptionsArea_disabled", 45);
        basicColorsBuilder.remove("saveOptionsArea");
        basicColorsBuilder.add("selectedBrowserExpandArrow", 172);
        basicColorsBuilder.add("selectedBrowserExpandArrow_focused", 255);
        basicColorsBuilder.add("browserExpandArrow", 154);
        basicColorsBuilder.add("scrollPaneGrabber", 255, 72);
        basicColorsBuilder.add("scrollPaneBorder", 155, 128);
        if (n < 1016) {
            basicColorsBuilder.add("texturedText", "controlText");
        } else {
            basicColorsBuilder.add("texturedText", 255, 115);
        }
        basicColorsBuilder.add("texturedText_focused", 0, 192);
        basicColorsBuilder.add("texturedText_disabled", "disabledControlText");
        basicColorsBuilder.add("texturedText_inactive", "disabledControlText");
        basicColorsBuilder.add("texturedText_inactive_disabled", 0, 96);
        if (n < 1016) {
            basicColorsBuilder.add("selectedTexturedText", 0, 192);
            basicColorsBuilder.add("selectedTexturedText_disabled", 0, 64);
            if (n == 1015) {
                basicColorsBuilder.add("selectedTexturedText_inactive", 0, 192);
            } else {
                basicColorsBuilder.add("selectedTexturedText_inactive", 0, 128);
            }
            basicColorsBuilder.add("selectedTexturedText_inactive_disabled", 0, 64);
        } else {
            basicColorsBuilder.addAll("selectedTexturedText", "controlText");
        }
        basicColorsBuilder.add("texturedToolbarText", "controlText");
        basicColorsBuilder.add("texturedToolbarText_inactive", 255, 64);
        basicColorsBuilder.add("texturedToolbarText_disabled", "disabledControlText");
        basicColorsBuilder.add("texturedToolbarText_inactive_disabled", 255, 32);
        if (n < 1016) {
            basicColorsBuilder.add("selectedTexturedToolbarText", 0, 128);
            basicColorsBuilder.add("selectedTexturedToolbarText_inactive", "selectedTexturedText_inactive");
            basicColorsBuilder.add("selectedTexturedToolbarText_disabled", 0, 32);
            basicColorsBuilder.add("selectedTexturedToolbarText_inactive_disabled", "selectedTexturedText_inactive_disabled");
        } else {
            basicColorsBuilder.addAll("selectedTexturedToolbarText", "controlText");
        }
        basicColorsBuilder.add("texturedSegmentedText_inactive", 255, 64);
        basicColorsBuilder.add("texturedSegmentedText_inactive_disabled", 255, 32);
        basicColorsBuilder.add("nonexclusiveTexturedText", 0, 224);
        basicColorsBuilder.add("selectedNonexclusiveTexturedText", "controlAccent_rollover");
        basicColorsBuilder.add("selectedNonexclusiveTexturedText_rollover", "controlAccent_rollover");
        basicColorsBuilder.add("selectedNonexclusiveTexturedText_disabled", "controlAccent_disabled");
        basicColorsBuilder.add("selectedNonexclusiveTexturedText_inactive", 0, 96);
        basicColorsBuilder.add("selectedNonexclusiveTexturedText_inactive_disabled", 0, 48);
        basicColorsBuilder.add("nonexclusiveTexturedToolbarText_inactive", 255, 80);
        basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_inactive", 255, 80);
        if (n < 1016) {
            basicColorsBuilder.add("selectedTexturedSegmentedText", 0, 200);
            basicColorsBuilder.add("selectedTexturedSegmentedText_disabled", 0, 72);
            basicColorsBuilder.add("selectedTexturedSegmentedText_inactive", 0, 117);
            basicColorsBuilder.add("selectedTexturedSegmentedText_inactive_disabled", 0, 64);
            basicColorsBuilder.add("selectedNonexclusiveTexturedText_inactive", 0, 108);
            basicColorsBuilder.add("selectedNonexclusiveTexturedText_inactive_disabled", 0, 64);
            basicColorsBuilder.addAll("selectedTexturedSegmentedToolbarText", "selectedTexturedSegmentedText");
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_inactive_disabled", 255, 48);
            basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_inactive_disabled", 255, 64);
        } else {
            basicColorsBuilder.add("selectedTexturedSegmentedText", "controlText");
            basicColorsBuilder.add("selectedTexturedSegmentedText_disabled", "texturedText_disabled");
            basicColorsBuilder.add("selectedTexturedSegmentedText_inactive", "texturedText_inactive");
            basicColorsBuilder.add("selectedTexturedSegmentedText_inactive_disabled", "texturedText_inactive_disabled");
            basicColorsBuilder.add("texturedSegmentedText", "controlText");
            basicColorsBuilder.add("texturedSegmentedToolbarText", "texturedText");
            basicColorsBuilder.add("texturedSegmentedToolbarText_disabled", "texturedText_disabled");
            basicColorsBuilder.add("texturedSegmentedToolbarText_inactive", "texturedText_inactive");
            basicColorsBuilder.add("texturedSegmentedToolbarText_inactive_disabled", "texturedText_inactive_disabled");
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText", "controlText");
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_disabled", "selectedTexturedText_disabled");
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_inactive", "selectedTexturedText_inactive");
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_inactive_disabled", "selectedTexturedText_inactive_disabled");
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText", 255, 148);
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText", 255, 226);
            basicColorsBuilder.add("texturedSegmentedToolbarText", 255, 148);
            basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_inactive", 255, 136);
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText_inactive", 255, 60);
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_inactive", 255, 48);
            basicColorsBuilder.add("texturedSegmentedToolbarText_inactive", 255, 60);
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText_disabled", 255, 36);
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_disabled", 255, 60);
            basicColorsBuilder.add("texturedSegmentedToolbarText_disabled", 255, 36);
            basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_inactive_disabled", 255, 32);
            basicColorsBuilder.add("nonexclusiveTexturedToolbarText_inactive_disabled", 255, 32);
            basicColorsBuilder.add("selectedTexturedSegmentedToolbarText_inactive_disabled", 255, 16);
            basicColorsBuilder.add("texturedSegmentedToolbarText_inactive_disabled", 255, 32);
            basicColorsBuilder.add("selectedNonexclusiveTexturedToolbarText_rollover", "controlAccent_rollover");
        }
        basicColorsBuilder.addAll("recessedText", "controlText");
        if (n >= 1015) {
            basicColorsBuilder.add("recessedText", 255, 115);
        }
        basicColorsBuilder.add("selectedRecessedText_pressed", "controlText_pressed");
        basicColorsBuilder.add("selectedRecessedText_rollover", "controlText_rollover");
        if (n >= 1016) {
            basicColorsBuilder.add("selectedRecessedText", 255, 192);
            basicColorsBuilder.add("selectedRecessedText_disabled", 255, 64);
        } else {
            basicColorsBuilder.add("selectedRecessedText", 0, 192);
            basicColorsBuilder.add("selectedRecessedText_disabled", 0, 64);
            basicColorsBuilder.add("selectedRecessedText_inactive", 0, 192);
        }
        basicColorsBuilder.add("pushButtonText", "controlText");
        basicColorsBuilder.add("pushButtonText_disabled", "disabledControlText");
        basicColorsBuilder.add("pushButtonText_pressed", "controlText_pressed");
        basicColorsBuilder.add("pushButtonText_focused", "controlText");
        if (n < 1016) {
            basicColorsBuilder.add("selectedPushButtonText", "controlText");
        }
        basicColorsBuilder.add("pushPopText_pressed", "controlText_pressed");
        if (n < 1016) {
            basicColorsBuilder.add("segmentedText", "controlText");
            basicColorsBuilder.add("segmentedText_focused", "controlText");
        } else {
            basicColorsBuilder.add("tabText", "controlText");
            basicColorsBuilder.add("tabText_focused", "controlText");
            basicColorsBuilder.add("tabText_inactive", "controlText");
            basicColorsBuilder.add("segmentedText", 255, 192);
            basicColorsBuilder.add("segmentedText_disabled", 255, 48);
            basicColorsBuilder.add("segmentedText_inactive", "segmentedText");
            basicColorsBuilder.add("segmentedText_inactive_disabled", "segmentedText_disabled");
        }
        basicColorsBuilder.addAll("selectedSegmentedText", "controlText");
        if (n == 1014 || n == 1015) {
            basicColorsBuilder.add("selectedTabText_disabled", 0, 96);
            basicColorsBuilder.add("selectedTabText_inactive_disabled", 0, 96);
            basicColorsBuilder.add("selectedSegmentedText_inactive", 0, 192);
        } else if (n >= 1016) {
            // empty if block
        }
        basicColorsBuilder.add("nonexclusiveText_disabled", "disabledControlText");
        basicColorsBuilder.add("nonexclusiveText_inactive", "controlText");
        basicColorsBuilder.addAll("gradientText", "controlText");
        if (n == 1014) {
            basicColorsBuilder.add("selectedGradientText", 0, 180);
            basicColorsBuilder.add("selectedGradientText_disabled", 0, 64);
            basicColorsBuilder.add("selectedGradientText_inactive", 0, 180);
            basicColorsBuilder.add("selectedGradientText_inactive_disabled", 0, 64);
        }
        basicColorsBuilder.addAll("gradientSegmentedText", "controlText");
        basicColorsBuilder.add("selectedGradientSegmentedText_inactive", 0, 192);
        if (n >= 1016) {
            basicColorsBuilder.add("selectedGradientSegmentedText_inactive_disabled", 0, 72);
        }
        basicColorsBuilder.addAll("selectedRoundedRectText", "roundedRectText");
        basicColorsBuilder.addAll("bevelText", "roundedRectText", 1);
        basicColorsBuilder.add("roundText", "controlText");
        basicColorsBuilder.add("selectedRoundText", 0, 224);
        basicColorsBuilder.add("roundText_disabled", "disabledControlText");
        basicColorsBuilder.add("selectedRoundText_disabled", 0, 64);
        basicColorsBuilder.add("toolbarItemText", "controlText");
        basicColorsBuilder.add("toolbarItemText_inactive", "disabledControlText");
        basicColorsBuilder.add("toolbarItemText_focused", "alternateSelectedControlText");
        basicColorsBuilder.add("selectedToolbarItemText", "alternateSelectedControlText");
        basicColorsBuilder.add("selectedToolbarItemText_disabled", "alternateSelectedControlText_disabled");
        basicColorsBuilder.add("selectedToolbarItemText_inactive", "alternateSelectedControlText_disabled");
        basicColorsBuilder.add("selectedToolbarItemText_inactive_disabled", "alternateSelectedControlText_disabled");
        if (n < 1016) {
            basicColorsBuilder.add("inlineButtonText", 50);
        } else {
            basicColorsBuilder.add("inlineButtonText", 255, 140);
            basicColorsBuilder.add("inlineButtonText_inactive", 255, 115);
            basicColorsBuilder.add("inlineButtonText_disabled", 255, 115);
            basicColorsBuilder.add("inlineButtonText_inactive_disabled", 255, 115);
            basicColorsBuilder.add("selectedInlineButtonText", 255, 180);
        }
        if (n == 1014 || n == 1015) {
            basicColorsBuilder.add("selectedTabText_inactive", 0, 192);
        }
        basicColorsBuilder.add("categoryText", 255, 160);
        basicColorsBuilder.add("expandControl", 255, 160);
        basicColorsBuilder.add("sidebarBorder", 0);
        basicColorsBuilder.add("sidebarIcon", 255, 160);
        basicColorsBuilder.add("treeIcon", 160);
        basicColorsBuilder.add("tableHeader", 230);
        basicColorsBuilder.add("tableHeader_disabled", 223);
        basicColorsBuilder.add("selectedTableHeader", 230);
        basicColorsBuilder.add("tableHeaderBackground", 46);
        basicColorsBuilder.add("tableHeaderBackground_disabled", 48);
        basicColorsBuilder.add("tableHeaderSeparator", 70);
        basicColorsBuilder.add("tableHeaderSeparator_disabled", 83);
        basicColorsBuilder.add("browserColumnSeparator", 60);
        basicColorsBuilder.addMagicAlphaGradient("topTexturedWindowMarginBackground", 255, 24, 8);
        basicColorsBuilder.add("topTexturedWindowMarginBackground_disabled", new TintedEraser(0, 32));
        basicColorsBuilder.addColorGradient("bottomTexturedWindowMarginBackground", 60, 38, 128);
        basicColorsBuilder.addAlphaGradient("topWindowMarginBackground", 255, 24, 8);
        basicColorsBuilder.add("topWindowMarginBackground_disabled", new TintedEraser(32, 64));
        basicColorsBuilder.addColorGradient("bottomWindowMarginBackground", 50, 40, 255);
        basicColorsBuilder.add("topWindowDivider_disabled", 55);
        return basicColorsBuilder.get();
    }

    @NotNull
    private BasicColors createHighContrastDarkColors(int n) {
        BasicColorsBuilder basicColorsBuilder = new BasicColorsBuilder("High Contrast Dark", this.instrumentation, this.log);
        basicColorsBuilder.add("windowBackground", 50);
        basicColorsBuilder.add("texturedWindowBackground", 53);
        basicColorsBuilder.add("tagBlue", 103, 176, 255);
        basicColorsBuilder.add("tagGray", 172, 172, 176);
        basicColorsBuilder.add("tagGreen", 91, 215, 105);
        basicColorsBuilder.add("tagOrange", 255, 170, 71);
        basicColorsBuilder.add("tagPurple", 226, 165, 254);
        basicColorsBuilder.add("tagRed", 255, 135, 129);
        basicColorsBuilder.add("tagYellow", 254, 214, 75);
        basicColorsBuilder.add("tagBlue_disabled", 67, 104, 144);
        basicColorsBuilder.add("tagGray_disabled", 102, 102, 104);
        basicColorsBuilder.add("tagGreen_disabled", 62, 123, 69);
        basicColorsBuilder.add("tagOrange_disabled", 143, 101, 52);
        basicColorsBuilder.add("tagPurple_disabled", 128, 98, 143);
        basicColorsBuilder.add("tagRed_disabled", 143, 83, 80);
        basicColorsBuilder.add("tagYellow_disabled", 143, 123, 55);
        basicColorsBuilder.add("scrollPaneGrabber", 255, 196);
        basicColorsBuilder.add("scrollPaneBorder", 153, 128);
        basicColorsBuilder.addColorGradient("bottomTexturedWindowMarginBackground", 80, 48, 128);
        basicColorsBuilder.addColorGradient("bottomWindowMarginBackground", 66, 53, 255);
        int n2 = 255;
        int n3 = 104;
        basicColorsBuilder.add("topWindowDivider", n2, n3);
        basicColorsBuilder.add("bottomWindowDivider", n2, n3);
        basicColorsBuilder.add("topTexturedWindowDivider", n2, n3);
        basicColorsBuilder.add("bottomTexturedWindowDivider", n2, n3);
        basicColorsBuilder.add("topWindowDivider_disabled", n2, n3);
        basicColorsBuilder.add("bottomWindowDivider_disabled", n2, n3);
        basicColorsBuilder.add("topTexturedWindowDivider_disabled", n2, n3);
        basicColorsBuilder.add("bottomTexturedWindowDivider_disabled", n2, n3);
        return basicColorsBuilder.get();
    }
}

