/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.ContextualColor;

public class DelegatedContainerContextualColors
implements ContainerContextualColors {
    @NotNull
    protected BasicContextualColors source;
    @Nullable
    protected ContextualColor grid;
    protected boolean isRowSelected;

    public DelegatedContainerContextualColors(@NotNull BasicContextualColors basicContextualColors) {
        this.source = basicContextualColors;
        this.grid = null;
    }

    public DelegatedContainerContextualColors(@NotNull BasicContextualColors basicContextualColors, @NotNull ContextualColor contextualColor) {
        this.source = basicContextualColors;
        this.grid = contextualColor;
    }

    @Override
    public void configureForContainer() {
        this.isRowSelected = false;
    }

    @Override
    public void configureForRow(int n, boolean bl) {
        this.isRowSelected = bl;
    }

    @Override
    public void configureForRow(boolean bl) {
        this.isRowSelected = bl;
    }

    @Override
    public boolean isStriped() {
        return false;
    }

    @Override
    @NotNull
    public Color getBackground(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.source.getBackground(appearanceContext);
    }

    @Override
    @NotNull
    public Color getForeground(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.source.getForeground(appearanceContext);
    }

    @Override
    @NotNull
    public Color getGrid(@NotNull AppearanceContext appearanceContext) {
        if (this.grid != null) {
            appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
            return this.grid.get(appearanceContext);
        }
        throw new UnsupportedOperationException("No grid color has been defined");
    }
}

