/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaTreeTableUI;
import org.violetlib.aqua.TreeTableModel;
import org.violetlib.aqua.fc.AquaFileChooserListMouseBehavior;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.SubtreeTreeModel;
import org.violetlib.treetable.TreeTable;
import org.violetlib.treetable.ui.BasicTreeTableUI;

public abstract class AquaFileChooserTreeTableUI
extends AquaTreeTableUI {
    protected AquaFileChooserListMouseBehavior mouseBehavior;

    public AquaFileChooserTreeTableUI(JFileChooser jFileChooser, final TreeTable treeTable) {
        this.mouseBehavior = new AquaFileChooserListMouseBehavior(jFileChooser, new TreeTableModel(treeTable));
        this.mouseBehavior.setFileSelectionHandler(new AquaFileChooserListMouseBehavior.FileSelectionHandler(){

            @Override
            public void fileSelected(File file) {
                SubtreeTreeModel subtreeTreeModel = (SubtreeTreeModel)treeTable.getTreeModel();
                FileSystemTreeModel fileSystemTreeModel = (FileSystemTreeModel)subtreeTreeModel.getTargetModel();
                TreePath treePath = fileSystemTreeModel.toPath(file, null);
                AquaFileChooserTreeTableUI.this.select(treePath);
            }
        });
    }

    @Override
    protected JTree createAndConfigureTree() {
        JTree jTree = super.createAndConfigureTree();
        jTree.putClientProperty("JTree.isCellFilled", true);
        return jTree;
    }

    @Override
    protected JTable createAndConfigureTable() {
        JTable jTable = super.createAndConfigureTable();
        jTable.putClientProperty("JTable.style", "striped");
        return jTable;
    }

    @Override
    protected BasicTreeTableUI.Handler createHandler() {
        return new MyHandler();
    }

    @Override
    protected void installListeners() {
        InputMap inputMap;
        super.installListeners();
        JComponent jComponent = this.getTable();
        InputMap inputMap2 = jComponent.getInputMap(1).getParent();
        KeyStroke keyStroke = KeyStroke.getKeyStroke("shift meta A");
        Object object = inputMap2.get(keyStroke);
        if (object != null && object.equals("clearSelection")) {
            inputMap = new InputMap();
            inputMap.setParent(inputMap2);
            inputMap.put(keyStroke, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
        }
        if ((object = (inputMap2 = (jComponent = this.getTree()).getInputMap(0).getParent()).get(keyStroke = KeyStroke.getKeyStroke("shift meta A"))) != null && object.equals("clearSelection")) {
            inputMap = new InputMap();
            inputMap.setParent(inputMap2);
            inputMap.put(keyStroke, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
        }
    }

    @Override
    protected void handleDoubleClick(TreePath treePath) {
        FileInfo fileInfo;
        Object object = treePath.getLastPathComponent();
        if (object instanceof FileInfo && ((fileInfo = (FileInfo)object).isAcceptable() || fileInfo.isTraversable())) {
            this.select(treePath);
        }
    }

    protected abstract void select(TreePath var1);

    protected class MyHandler
    extends AquaTreeTableUI.MyHandler {
        protected MyHandler() {
            super(AquaFileChooserTreeTableUI.this);
        }

        @Override
        protected void dispatchMouseEvent(MouseEvent mouseEvent, JComponent jComponent) {
            Serializable serializable;
            int n = mouseEvent.getID();
            if (n == 500 && mouseEvent.getClickCount() == 2 && (serializable = AquaFileChooserTreeTableUI.this.treeTable.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                AquaFileChooserTreeTableUI.this.handleDoubleClick((TreePath)serializable);
                mouseEvent.consume();
                return;
            }
            serializable = AquaFileChooserTreeTableUI.this.getTable();
            if (jComponent == serializable) {
                AquaFileChooserTreeTableUI.this.mouseBehavior.processMouseEvent(mouseEvent);
                return;
            }
            super.dispatchMouseEvent(mouseEvent, jComponent);
        }
    }
}

