/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaCustomStyledWindow;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OverlayScrollPaneHack;
import org.violetlib.aqua.ToolbarSensitiveUI;
import org.violetlib.aqua.VisibleBounds;
import org.violetlib.aqua.WindowStylePatch;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.vappearances.VAppearance;

public final class AquaUtils {
    public static final String TOOLBAR_PANEL_PROPERTY = "Aqua.isToolBarPanel";
    private static final String ANIMATIONS_PROPERTY = "swing.enableAnimations";
    private static final int javaVersion = AquaUtils.obtainJavaVersion();
    private static final HierarchyListener toolbarStatusListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            AquaUtils.toolbarStatusChanged(hierarchyEvent);
        }
    };
    private static final RecyclableSingleton<Boolean> enableAnimations;
    private static final int MENU_BLINK_DELAY = 50;
    public static final int ERASE_IF_TEXTURED = 1;
    public static final int ERASE_IF_VIBRANT = 2;
    public static final int ERASE_ALWLAYS = 4;
    static final Map<Object, Object> appContextMap;
    public static final int TITLE_BAR_NONE = 0;
    public static final int TITLE_BAR_ORDINARY = 1;
    public static final int TITLE_BAR_TRANSPARENT = 2;
    public static final int TITLE_BAR_HIDDEN = 3;
    public static final int TITLE_BAR_OVERLAY = 4;

    private AquaUtils() {
    }

    public static void logError(@NotNull String string) {
        System.err.println(string);
    }

    public static void logError(@NotNull String string, @NotNull Throwable throwable) {
        System.err.println(string + ": " + throwable);
    }

    public static void logDebug(@NotNull String string) {
        System.err.println(string);
    }

    public static int getJavaVersion() {
        return javaVersion;
    }

    private static int obtainJavaVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            string = string.substring(2);
        }
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "._");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                int n3;
                String string2 = stringTokenizer.nextToken();
                int n4 = string2.indexOf("-");
                if (n4 > 0) {
                    string2 = string2.substring(0, n4);
                }
                int n5 = Integer.parseInt(string2);
                int n6 = n3 = ++n2 < 3 ? 100 : 1000;
                if (n5 < 0 || n5 >= n3) {
                    return 0;
                }
                n = n * n3 + n5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        while (n2 < 3) {
            int n7 = ++n2 < 3 ? 100 : 1000;
            n *= n7;
        }
        if (n2 != 3) {
            return 0;
        }
        return n;
    }

    @Nullable
    public static <T> T getUI(@NotNull JComponent jComponent, Class<T> clazz) {
        try {
            Class<?> clazz2 = jComponent.getClass();
            Method method = clazz2.getMethod("getUI", new Class[0]);
            Object object = method.invoke((Object)jComponent, new Object[0]);
            return clazz.cast(object);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @NotNull
    public static String getWindowNameForDebugging(@NotNull Window window) {
        Frame frame;
        String string;
        String string2 = window.getName();
        if (string2 == null) {
            string2 = window.getClass().getName() + "@" + Integer.toHexString(window.hashCode());
        }
        if (window instanceof Frame && (string = (frame = (Frame)window).getTitle()) != null) {
            if (string.length() > 20) {
                string = string.substring(0, 20) + "...";
            }
            string2 = string2 + " \"" + string + "\"";
        }
        return string2;
    }

    public static Insets combineAsInsets(Insetter insetter, Insets insets) {
        if (insetter != null) {
            Insets insets2 = insetter.asInsets();
            return AquaUtils.combineInsets(insets2, insets);
        }
        return insets != null ? insets : new Insets(0, 0, 0, 0);
    }

    public static Insets2D combineAsInsets2D(Insetter insetter, Insets insets) {
        if (insetter != null) {
            Insets2D insets2D = insetter.asInsets2D();
            return AquaUtils.combineInsets(insets2D, insets);
        }
        return insets != null ? AquaUtils.asInsets2D(insets) : new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Insets combineInsets(Insets insets, Insets insets2) {
        if (insets != null) {
            if (insets2 != null) {
                return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
            }
            return insets;
        }
        if (insets2 != null) {
            return insets2;
        }
        return new Insets(0, 0, 0, 0);
    }

    public static Insets2D combineInsets(Insets2D insets2D, Insets insets) {
        if (insets2D != null) {
            if (insets != null) {
                return new Insets2D(insets2D.getTop() + (float)insets.top, insets2D.getLeft() + (float)insets.left, insets2D.getBottom() + (float)insets.bottom, insets2D.getRight() + (float)insets.right);
            }
            return insets2D;
        }
        if (insets != null) {
            return AquaUtils.asInsets2D(insets);
        }
        return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Insets2D asInsets2D(Insets insets) {
        return new Insets2D((float)insets.top, (float)insets.left, (float)insets.bottom, (float)insets.right);
    }

    public static Rectangle toRectangle(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return (Rectangle)rectangle2D;
        }
        int n = (int)Math.floor(rectangle2D.getX());
        int n2 = (int)Math.floor(rectangle2D.getY());
        int n3 = (int)Math.ceil(rectangle2D.getWidth());
        int n4 = (int)Math.ceil(rectangle2D.getHeight());
        return new Rectangle(n, n2, n3, n4);
    }

    public static Rectangle toMinimumRectangle(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return (Rectangle)rectangle2D;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getWidth();
        int n = (int)Math.ceil(d);
        int n2 = (int)Math.floor(d2 -= (double)n - d);
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getHeight();
        int n3 = (int)Math.ceil(d3);
        int n4 = (int)Math.floor(d4 -= (double)n3 - d3);
        return new Rectangle(n, n3, n2, n4);
    }

    public static Point getScreenLocation(Component component) {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, component);
        return point;
    }

    public static Rectangle getScreenBounds(@NotNull Point point, @Nullable Component component) {
        GraphicsConfiguration graphicsConfiguration = AquaUtils.getCurrentGraphicsConfiguration(point, component);
        return AquaUtils.getScreenBounds(graphicsConfiguration);
    }

    @NotNull
    public static Rectangle getScreenBounds(@Nullable GraphicsConfiguration graphicsConfiguration) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle rectangle = graphicsConfiguration != null ? graphicsConfiguration.getBounds() : new Rectangle(toolkit.getScreenSize());
        Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        return new Rectangle(rectangle.x + n3, rectangle.y + n, rectangle.width - n3 - n4, rectangle.height - n - n2);
    }

    @Nullable
    private static GraphicsConfiguration getCurrentGraphicsConfiguration(@NotNull Point point, @Nullable Component component) {
        GraphicsDevice[] graphicsDeviceArray;
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDevice.getType() != 0 || !(graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration == null && component != null) {
            graphicsConfiguration = component.getGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    @Nullable
    public static JRootPane getRootPane(@NotNull Window window) {
        RootPaneContainer rootPaneContainer = AquaUtils.getRootPaneContainer(window);
        return rootPaneContainer != null ? rootPaneContainer.getRootPane() : null;
    }

    @Nullable
    public static JLayeredPane getLayeredPane(@NotNull Window window) {
        RootPaneContainer rootPaneContainer = AquaUtils.getRootPaneContainer(window);
        return rootPaneContainer != null ? rootPaneContainer.getLayeredPane() : null;
    }

    @Nullable
    public static RootPaneContainer getRootPaneContainer(@NotNull Window window) {
        Component component;
        if (window instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)window);
        }
        if (window.getComponentCount() == 1 && (component = window.getComponent(0)) instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)component);
        }
        return null;
    }

    public static boolean isLeftToRight(Component component) {
        return component == null || component.getComponentOrientation().isLeftToRight();
    }

    public static AquaUIPainter.UILayoutDirection getLayoutDirection(Component component) {
        return component == null || component.getComponentOrientation().isLeftToRight() ? AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT : AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT;
    }

    public static void installToolbarSensitivity(@NotNull JComponent jComponent) {
        ToolbarSensitiveUI toolbarSensitiveUI = AquaUtils.getUI(jComponent, ToolbarSensitiveUI.class);
        if (toolbarSensitiveUI != null) {
            jComponent.addHierarchyListener(toolbarStatusListener);
        }
    }

    public static void uninstallToolbarSensitivity(@NotNull JComponent jComponent) {
        jComponent.removeHierarchyListener(toolbarStatusListener);
    }

    private static void toolbarStatusChanged(@NotNull HierarchyEvent hierarchyEvent) {
        JComponent jComponent;
        ToolbarSensitiveUI toolbarSensitiveUI;
        Component component = hierarchyEvent.getComponent();
        if (component instanceof JComponent && (toolbarSensitiveUI = AquaUtils.getUI(jComponent = (JComponent)component, ToolbarSensitiveUI.class)) != null) {
            toolbarSensitiveUI.toolbarStatusChanged(jComponent);
        }
    }

    public static void generateToolbarStatusEvents(@NotNull JComponent jComponent) {
        AquaUtils.generateToolbarStatusEvents(jComponent, jComponent);
    }

    private static void generateToolbarStatusEvents(@NotNull JComponent jComponent, @NotNull Component component) {
        HierarchyEvent hierarchyEvent = new HierarchyEvent(component, 1400, jComponent, jComponent.getParent());
        HierarchyListener[] hierarchyListenerArray = component.getHierarchyListeners();
        for (HierarchyListener object : hierarchyListenerArray) {
            object.hierarchyChanged(hierarchyEvent);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                AquaUtils.generateToolbarStatusEvents(jComponent, component2);
            }
        }
    }

    public static boolean isOnToolbar(JComponent jComponent) {
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if (!AquaUtils.isToolBar(container)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolBar(@NotNull Component component) {
        if (component instanceof JToolBar) {
            JToolBar jToolBar = (JToolBar)component;
            return !jToolBar.isFloatable();
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Object object = jComponent.getClientProperty(TOOLBAR_PANEL_PROPERTY);
            return Boolean.TRUE.equals(object);
        }
        return false;
    }

    public static boolean isDecorated(@NotNull Window window) {
        if (window instanceof Frame) {
            return !((Frame)window).isUndecorated();
        }
        if (window instanceof Dialog) {
            return !((Dialog)window).isUndecorated();
        }
        return false;
    }

    public static boolean isFullScreenWindow(Window window) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Window window2 = graphicsDevice.getFullScreenWindow();
        if (window2 != null) {
            return window2 == window;
        }
        long l2 = AquaUtils.execute(window, l -> AquaUtils.nativeIsFullScreenWindow(l) ? 1L : 0L);
        return l2 != 0L;
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl = true;
        int n6 = n2;
        int n7 = n4;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 10: {
                n6 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n6 = bl ? 4 : 2;
            }
        }
        switch (n4) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        return AquaUtils.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n, n6, n3, n7, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        int n12 = 0;
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                n12 = AquaUtils.getLeftSideBearing(jComponent, fontMetrics, string);
                if (n12 < 0) {
                    rectangle3.width -= n12;
                }
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        int n13 = n11 = bl || icon == null ? 0 : n5;
        if (!bl && rectangle3.width > (n10 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n11))) {
            if (view != null) {
                rectangle3.width = n10;
            } else {
                String string2 = "...";
                n9 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                n8 = string.length();
                for (n7 = 0; n7 < n8; ++n7) {
                    int n14 = n6 = n7 % 2 == 0 ? n7 / 2 : n8 - 1 - n7 / 2;
                    if ((n9 += fontMetrics.charWidth(string.charAt(n6))) > n10) break;
                }
                string = string.substring(0, n7 / 2) + string2 + string.substring(n8 - n7 / 2);
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n11)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n11));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n11) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n11);
        n10 = Math.min(rectangle2.x, rectangle3.x);
        int n15 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n10;
        n9 = Math.min(rectangle2.y, rectangle3.y);
        n7 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n9;
        n6 = n == 1 ? rectangle.y - n9 : (n == 0 ? rectangle.y + rectangle.height / 2 - (n9 + n7 / 2) : rectangle.y + rectangle.height - (n9 + n7));
        n8 = n2 == 2 ? rectangle.x - n10 : (n2 == 4 ? rectangle.x + rectangle.width - (n10 + n15) : rectangle.x + rectangle.width / 2 - (n10 + n15 / 2));
        rectangle3.x += n8;
        rectangle3.y += n6;
        rectangle2.x += n8;
        rectangle2.y += n6;
        if (n12 < 0) {
            rectangle3.width += n12;
            rectangle3.x -= n12;
        }
        return string;
    }

    private static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return AquaUtils.nativeGetLeftSideBearing(jComponent, fontMetrics, string.charAt(0));
    }

    public static void paintImmediately(Window window, JComponent jComponent) {
        boolean bl = window.isVisible();
        if (!bl) {
            AquaUtils.nativeSetWindowVisibleField(window, true);
        }
        try {
            jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        finally {
            if (!bl) {
                AquaUtils.nativeSetWindowVisibleField(window, false);
            }
        }
    }

    private static boolean animationsEnabled() {
        return enableAnimations.get();
    }

    static void blinkMenu(Selectable selectable) {
        if (!AquaUtils.animationsEnabled()) {
            return;
        }
        try {
            selectable.paintSelected(false);
            Thread.sleep(50L);
            selectable.paintSelected(true);
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void fillRect(Graphics graphics, Component component, int n) {
        AquaUtils.fillRect(graphics, component, n, 0, 0, component.getWidth(), component.getHeight());
    }

    public static void fillRect(Graphics graphics, Component component, int n, int n2, int n3, int n4, int n5) {
        Color color = AquaUtils.getFillColor(component, n);
        AquaUtils.fillRect(graphics, color, n2, n3, n4, n5);
    }

    private static Color getFillColor(Component component, int n) {
        if ((n & 4) != 0) {
            return null;
        }
        Color color = component.getBackground();
        if (AquaColors.isPriority(color)) {
            return color;
        }
        return !AquaUtils.isMagicEraser(component, n) ? color : null;
    }

    public static void fillRect(Graphics graphics, Component component, @NotNull Color color, int n) {
        AquaUtils.fillRect(graphics, component, color, n, 0, 0, component.getWidth(), component.getHeight());
    }

    public static void fillRect(Graphics graphics, Component component, @NotNull Color color, int n, int n2, int n3, int n4, int n5) {
        color = AquaUtils.getFillColor(component, color, n);
        AquaUtils.fillRect(graphics, color, n2, n3, n4, n5);
    }

    private static Color getFillColor(Component component, @NotNull Color color, int n) {
        if ((n & 4) != 0) {
            return null;
        }
        Color color2 = component.getBackground();
        if (AquaColors.isPriority(color2)) {
            return color2;
        }
        return !AquaUtils.isMagicEraser(component, n) ? color : null;
    }

    private static boolean isMagicEraser(Component component, int n) {
        JComponent jComponent;
        if ((n & 1) != 0 && (jComponent = SwingUtilities.getRootPane(component)) != null && AquaUtils.isNativeTextured(jComponent)) {
            return true;
        }
        return (n & 2) != 0 && component instanceof JComponent && AquaVibrantSupport.isVibrant(jComponent = (JComponent)component);
    }

    @Nullable
    public static VisibleBounds getVisibleBoundsInContentView(@NotNull Component component) {
        VisibleBounds visibleBounds;
        Window window;
        if (component.getWidth() > 0 && component.getHeight() > 0 && (window = SwingUtilities.getWindowAncestor(component)) != null && (visibleBounds = AquaUtils.getVisibleBoundsInWindow(component, window)) != null) {
            Insets insets = window.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = window.getWidth() - (insets.left + insets.right);
            int n4 = window.getHeight() - (insets.top + insets.bottom);
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Rectangle rectangle2 = visibleBounds.visibleBounds.intersection(rectangle);
            Rectangle rectangle3 = visibleBounds.frame;
            Rectangle rectangle4 = new Rectangle(rectangle3.x - n, rectangle3.y - n2, rectangle3.width, rectangle3.height);
            return new VisibleBounds(rectangle2, rectangle4);
        }
        return null;
    }

    @Nullable
    public static VisibleBounds getVisibleBoundsInWindow(@NotNull Component component) {
        Window window;
        if (component.getWidth() > 0 && component.getHeight() > 0 && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            return AquaUtils.getVisibleBoundsInWindow(component, window);
        }
        return null;
    }

    @Nullable
    private static VisibleBounds getVisibleBoundsInWindow(@NotNull Component component, @NotNull Window window) {
        Rectangle rectangle;
        if (window.isVisible() && AquaUtils.computeVisibleRegion(component, rectangle = new Rectangle()) && !rectangle.isEmpty()) {
            Rectangle rectangle2 = SwingUtilities.convertRectangle(component, rectangle, window);
            Rectangle rectangle3 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), window);
            return new VisibleBounds(rectangle2, rectangle3);
        }
        return null;
    }

    private static boolean computeVisibleRegion(@NotNull Component component, @NotNull Rectangle rectangle) {
        if (!component.isVisible()) {
            return false;
        }
        Container container = component.getParent();
        if (container == null || !container.isVisible()) {
            return false;
        }
        Rectangle rectangle2 = component.getBounds();
        if (container instanceof Window) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
            return true;
        }
        if (!AquaUtils.computeVisibleRegion(container, rectangle)) {
            return false;
        }
        rectangle.x -= rectangle2.x;
        rectangle.y -= rectangle2.y;
        SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        return true;
    }

    @NotNull
    public static Color getWindowBackground(@NotNull JComponent jComponent) {
        EffectName effectName = AquaFocusHandler.isActive(jComponent) ? EffectName.EFFECT_NONE : EffectName.EFFECT_DISABLED;
        String string = "windowBackground";
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane != null && AquaUtils.isTextured(jRootPane)) {
            string = "texturedWindowBackground";
        }
        return AquaColors.getBackground(jComponent, string, effectName);
    }

    @NotNull
    public static Color getWindowMarginBackground(@NotNull JRootPane jRootPane, boolean bl) {
        String string = AquaUtils.isTextured(jRootPane) ? "TexturedWindowMarginBackground" : "WindowMarginBackground";
        String string2 = bl ? "top" : "bottom";
        String string3 = AquaFocusHandler.isActive(jRootPane) ? "" : "_disabled";
        String string4 = string2 + string + string3;
        AquaAppearance aquaAppearance = AppearanceManager.getAppearance(jRootPane);
        Color color = aquaAppearance.getColor(string4);
        if (color == null) {
            AquaUtils.logError("Undefined window margin background color: " + string4);
            return AquaColors.CLEAR;
        }
        return color;
    }

    @NotNull
    public static Color getWindowMarginDividerColor(@NotNull JRootPane jRootPane, boolean bl) {
        String string = AquaUtils.isTextured(jRootPane) ? "TexturedWindowDivider" : "WindowDivider";
        String string2 = bl ? "top" : "bottom";
        String string3 = AquaFocusHandler.isActive(jRootPane) ? "" : "_disabled";
        String string4 = string2 + string + string3;
        AquaAppearance aquaAppearance = AppearanceManager.getAppearance(jRootPane);
        Color color = aquaAppearance.getColor(string4);
        if (color == null) {
            AquaUtils.logError("Undefined window divider color: " + string4);
            return AquaColors.CLEAR;
        }
        return color;
    }

    public static boolean isTextured(@NotNull JRootPane jRootPane) {
        AquaCustomStyledWindow aquaCustomStyledWindow;
        if (AquaUtils.isNativeTextured(jRootPane)) {
            return true;
        }
        AquaRootPaneUI aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class);
        if (aquaRootPaneUI != null && (aquaCustomStyledWindow = aquaRootPaneUI.getCustomStyledWindow()) != null) {
            return aquaCustomStyledWindow.isTextured();
        }
        return false;
    }

    public static boolean isNativeTextured(@NotNull Window window) {
        if (window instanceof RootPaneContainer) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            JRootPane jRootPane = rootPaneContainer.getRootPane();
            return AquaUtils.isNativeTextured(jRootPane);
        }
        return false;
    }

    public static boolean isNativeTextured(@NotNull JRootPane jRootPane) {
        Object object = jRootPane.getClientProperty("apple.awt.brushMetalLook");
        if (object != null && Boolean.parseBoolean(object.toString())) {
            return true;
        }
        object = jRootPane.getClientProperty("Window.style");
        return object != null && object.equals("textured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRect(Graphics graphics, @Nullable Color color, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create();
        try {
            if (color instanceof AquaColors.GradientColor && graphics2 instanceof Graphics2D) {
                AquaColors.GradientColor gradientColor = (AquaColors.GradientColor)color;
                Graphics2D graphics2D = (Graphics2D)graphics2;
                if (gradientColor.useMagicEraser()) {
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.setColor(AquaColors.CLEAR);
                    graphics2D.fillRect(n, n2, n3, n4);
                }
                Color color2 = gradientColor.getStart();
                Color color3 = gradientColor.getFinish();
                GradientPaint gradientPaint = new GradientPaint(0.0f, n2, color2, 0.0f, n2 + n4, color3);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(n, n2, n3, n4);
            } else if (color instanceof AquaColors.TintedEraser && graphics2 instanceof Graphics2D) {
                AquaColors.TintedEraser tintedEraser = (AquaColors.TintedEraser)color;
                Graphics2D graphics2D = (Graphics2D)graphics2;
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setColor(AquaColors.CLEAR);
                graphics2D.fillRect(n, n2, n3, n4);
                graphics2.setColor(color);
                graphics2.fillRect(n, n2, n3, n4);
            } else if (color != null && color != AquaColors.MAGIC_ERASER) {
                graphics2.setColor(color);
                graphics2.fillRect(n, n2, n3, n4);
            } else if (graphics2 instanceof Graphics2D) {
                ((Graphics2D)graphics2).setComposite(AlphaComposite.Src);
                graphics2.setColor(AquaColors.CLEAR);
                graphics2.fillRect(n, n2, n3, n4);
            }
        }
        finally {
            graphics2.dispose();
        }
    }

    public static Graphics2D toGraphics2D(Graphics graphics) {
        try {
            return (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static boolean isProperty(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getProperty(JComponent jComponent, String ... stringArray) {
        for (String string : stringArray) {
            Object object = jComponent.getClientProperty(string);
            if (object == null) continue;
            return AquaUtils.toString(object);
        }
        return null;
    }

    public static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static Boolean getBooleanProperty(JComponent jComponent, String ... stringArray) {
        for (String string : stringArray) {
            Object object = jComponent.getClientProperty(string);
            if (object == null) continue;
            return AquaUtils.toBoolean(object);
        }
        return null;
    }

    public static Boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    public static Integer getIntegerProperty(JComponent jComponent, String ... stringArray) {
        for (String string : stringArray) {
            Object object = jComponent.getClientProperty(string);
            if (object instanceof String) {
                String string2 = (String)object;
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            if (!(object instanceof Integer)) continue;
            return (Integer)object;
        }
        return null;
    }

    public static String getProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object object) {
        Map<Object, Object> map = appContextMap;
        synchronized (map) {
            return appContextMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object put(Object object, Object object2) {
        Map<Object, Object> map = appContextMap;
        synchronized (map) {
            return appContextMap.put(object, object2);
        }
    }

    public static <T> T getSoftReferenceValue(Object object, Supplier<T> supplier) {
        Object t;
        SoftReference softReference = (SoftReference)AquaUtils.get(object);
        if (softReference != null && (t = softReference.get()) != null) {
            return t;
        }
        t = supplier.get();
        softReference = new SoftReference(t);
        AquaUtils.put(object, softReference);
        return t;
    }

    @Nullable
    public static <T> T instantiate(@NotNull Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object beginGraphics(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return object;
    }

    public static void endGraphics(Graphics2D graphics2D, Object object) {
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static void drawHLine(Graphics graphics, int n, int n2, int n3) {
        if (n2 < n) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        graphics.fillRect(n, n3, n2 - n + 1, 1);
    }

    public static void installFont(@NotNull JComponent jComponent, @NotNull String string) {
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jComponent.setFont(UIManager.getFont(string));
        }
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics, Font font) {
        if (jComponent != null) {
            return jComponent.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int getComponentLayer(@NotNull Component component) {
        Container container = component.getParent();
        if (container instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)container;
            return jLayeredPane.getLayer(component);
        }
        if (container != null) {
            return AquaUtils.getComponentLayer(container);
        }
        return 0;
    }

    public static JScrollPane getScrollPaneAncestor(Component component) {
        Container container = component.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            if ((container = jViewport.getParent()) instanceof JScrollPane) {
                return AquaUtils.verifyScrollPaneAncestor(component, (JScrollPane)container);
            }
            if (container instanceof JComponent && !((JComponent)container).isOptimizedDrawingEnabled() && (container = container.getParent()) instanceof JScrollPane) {
                return AquaUtils.verifyScrollPaneAncestor(component, (JScrollPane)container);
            }
        }
        return null;
    }

    private static JScrollPane verifyScrollPaneAncestor(Component component, JScrollPane jScrollPane) {
        JViewport jViewport = jScrollPane.getViewport();
        return jViewport != null && jViewport.getView() == component ? jScrollPane : null;
    }

    @Nullable
    public static JScrollPane getScrollPaneContainer(JComponent jComponent) {
        Container container = jComponent.getParent();
        if (container instanceof JViewport && container.getComponentCount() == 1) {
            Container container2 = container.getParent();
            if (container2 instanceof OverlayScrollPaneHack.AquaOverlayViewportHolder) {
                container2 = container2.getParent();
            }
            if (container2 instanceof JScrollPane) {
                return (JScrollPane)container2;
            }
        }
        return null;
    }

    public static void configure(@NotNull AquaUIPainter aquaUIPainter, @NotNull Component component, int n, int n2) {
        AquaAppearance aquaAppearance = AppearanceManager.getRegisteredAppearance(component);
        if (aquaAppearance != null) {
            aquaUIPainter.configureAppearance((VAppearance)aquaAppearance);
        }
        aquaUIPainter.configure(n, n2);
    }

    public static void setTitleBarStyle(@NotNull Window window, int n) {
        AquaUtils.ensureWindowPeer(window);
        AquaUtils.execute(window, l -> AquaUtils.setTitleBarStyle(window, l, n));
    }

    private static long setTitleBarStyle(@NotNull Window window, long l, int n) {
        int n2;
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        assert (jRootPane != null);
        if (!WindowStylePatch.isNeeded()) {
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = AquaUtils.isNativeTextured(window);
            boolean bl5 = true;
            boolean bl6 = false;
            boolean bl7 = false;
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 2: {
                    bl2 = true;
                    bl3 = true;
                    bl4 = false;
                    bl6 = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                    bl3 = true;
                    bl5 = OSXSystemProperties.OSVersion < 1011;
                    bl4 = false;
                    bl6 = true;
                    bl7 = true;
                    break;
                }
                case 4: {
                    bl2 = true;
                    bl6 = true;
                    break;
                }
            }
            jRootPane.putClientProperty("apple.awt.fullWindowContent", bl2);
            jRootPane.putClientProperty("apple.awt.transparentTitleBar", bl3);
            jRootPane.putClientProperty("apple.awt.draggableWindowBackground", bl4);
            n2 = AquaUtils.nativeSetTitleBarProperties(l, bl, bl5, bl7, bl6);
        } else {
            n2 = AquaUtils.nativeSetTitleBarStyle(l, n);
        }
        if (n2 != 0) {
            throw new UnsupportedOperationException("Unable to set window title bar style");
        }
        if (n == 3) {
            AquaUtils.setWindowTitle(window, "");
        }
        return 0L;
    }

    public static void setWindowTitle(Window window, String string) {
        if (window instanceof Frame) {
            ((Frame)window).setTitle(string);
        } else if (window instanceof Dialog) {
            ((Dialog)window).setTitle(string);
        }
    }

    public static void addNativeToolbarToWindow(Window window) throws UnsupportedOperationException {
        AquaUtils.ensureWindowPeer(window);
        AquaUtils.execute(window, AquaUtils::addNativeToolbarToWindow);
    }

    private static long addNativeToolbarToWindow(long l) throws UnsupportedOperationException {
        int n = AquaUtils.nativeAddToolbarToWindow(l);
        if (n != 0) {
            throw new UnsupportedOperationException("Unable to add native toolbar to window");
        }
        return 0L;
    }

    public static void ensureWindowPeer(Window window) {
        if (!window.isDisplayable()) {
            window.setSize(window.getPreferredSize());
            window.addNotify();
        }
    }

    public static int unsetTitledWindowStyle(Window window) throws UnsupportedOperationException {
        Rectangle rectangle = window.getBounds();
        Insets insets = window.getInsets();
        int n = insets.top;
        if (n == 0) {
            n = 22;
        }
        try {
            int n2 = rectangle.height - n;
            int n3 = rectangle.width;
            AquaUtils.nativeSetTitledWindowStyle(window, false, new Insets(0, 0, 0, 0));
            window.setSize(n3, n2);
            window.invalidate();
            window.validate();
            return n;
        }
        catch (Exception exception) {
            String string = exception.toString();
            throw new UnsupportedOperationException(string);
        }
    }

    public static void restoreTitledWindowStyle(Window window, int n, @NotNull Dimension dimension) {
        try {
            AquaUtils.nativeSetTitledWindowStyle(window, true, new Insets(n, 0, 0, 0));
            window.setSize(dimension);
            window.invalidate();
            window.validate();
        }
        catch (Exception exception) {
            AquaUtils.logError("Unable to restore titled window style", exception);
        }
    }

    public static AquaCustomStyledWindow getCustomStyledWindow(@NotNull Window window) {
        AquaRootPaneUI aquaRootPaneUI;
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        if (jRootPane != null && (aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class)) != null) {
            return aquaRootPaneUI.getCustomStyledWindow();
        }
        return null;
    }

    public static void setBackgroundCarefully(@NotNull Component component, @NotNull Color color) {
        JComponent jComponent = null;
        boolean bl = false;
        JComponent jComponent2 = null;
        boolean bl2 = false;
        if (component instanceof Window) {
            RootPaneContainer rootPaneContainer;
            Container container;
            Window window = (Window)component;
            boolean bl3 = AquaUtils.isDecorated(window);
            if (bl3 && color.getAlpha() < 255) {
                AquaUtils.setWindowBackground(window, color);
                return;
            }
            if (!bl3 && color.getAlpha() == 255 && component instanceof RootPaneContainer && (container = (rootPaneContainer = (RootPaneContainer)((Object)component)).getContentPane()) instanceof JComponent) {
                jComponent = (JComponent)container;
                bl = jComponent.isOpaque();
                jComponent2 = rootPaneContainer.getLayeredPane();
                bl2 = jComponent2.isOpaque();
            }
        }
        component.setBackground(color);
        if (jComponent != null && !bl) {
            jComponent.setOpaque(false);
        }
        if (jComponent2 != null && !bl2) {
            jComponent2.setOpaque(false);
        }
    }

    public static void setWindowTextured(Window window, boolean bl) {
        try {
            AquaUtils.nativeSetWindowTextured(window, bl);
        }
        catch (Throwable throwable) {
            AquaUtils.logError("Unable to set textured", throwable);
        }
    }

    public static void enableTranslucency(@NotNull Window window) {
        AquaUtils.setWindowTextured(window, true);
        new ShadowMaker(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setWindowBackground(Window window, Color color) {
        if (color.equals(window.getBackground())) {
            return;
        }
        JavaSupport.lockRenderQueue();
        try {
            window.setBackground(color);
        }
        catch (Throwable throwable) {
            try {
                AquaUtils.nativeSetWindowBackground(window, color);
            }
            catch (Throwable throwable2) {
                AquaUtils.logError("Unable to set window background", throwable2);
            }
        }
        finally {
            JavaSupport.unlockRenderQueue();
        }
    }

    public static void configurePopup(Window window, float f) {
        AquaUtils.execute(window, l -> AquaUtils.nativeSetWindowCornerRadius(l, f));
    }

    public static void setWindowRepresentedFilename(@NotNull Window window, @NotNull String string) {
        try {
            AquaUtils.execute(window, l -> AquaUtils.nativeSetWindowRepresentedFilename(l, string));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void setAWTViewVisibility(Window window, boolean bl) {
        AquaUtils.execute(window, l -> AquaUtils.nativeSetAWTViewVisibility(l, bl));
    }

    public static void syncAWTView(Window window) {
        if (window.isDisplayable()) {
            Toolkit.getDefaultToolkit().sync();
            try {
                AquaUtils.execute(window, AquaUtils::nativeSyncAWTView);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public static boolean setWindowAppearance(@NotNull Window window, @Nullable String string) {
        if (window.isDisplayable()) {
            return 0L == AquaUtils.execute(window, l -> AquaUtils.nativeSetWindowAppearance(l, string));
        }
        return false;
    }

    @Nullable
    public static String getWindowEffectiveAppearanceName(@NotNull Window window) {
        if (window.isDisplayable()) {
            try {
                return AquaUtils.executeForObject(window, AquaUtils::nativeGetWindowEffectiveAppearanceName);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long execute(@NotNull Window window, NativeAction nativeAction) {
        Object[] objectArray = new Object[1];
        long l = AquaUtils.nativeGetNativeWindow(window, objectArray);
        if (l == 0L) {
            Serializable serializable;
            String string = window.getName();
            if (window instanceof Frame) {
                serializable = (Frame)window;
                string = serializable.getTitle() + " " + string;
            }
            serializable = new UnsupportedOperationException("Unable to get NSWindow for window " + string);
            throw serializable;
        }
        Lock lock = (Lock)objectArray[0];
        if (lock != null) {
            lock.lock();
            try {
                long l2 = nativeAction.run(l);
                return l2;
            }
            finally {
                lock.unlock();
            }
        }
        return nativeAction.run(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeForObject(Window window, NativeObjectAction<T> nativeObjectAction) {
        Object[] objectArray = new Object[1];
        long l = AquaUtils.nativeGetNativeWindow(window, objectArray);
        if (l == 0L) {
            String string = window.getName();
            if (window instanceof Frame) {
                Frame frame = (Frame)window;
                string = frame.getTitle() + " " + string;
            }
            throw new UnsupportedOperationException("Unable to get NSWindow for window " + string);
        }
        Lock lock = (Lock)objectArray[0];
        if (lock != null) {
            lock.lock();
            try {
                T t = nativeObjectAction.run(l);
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        return nativeObjectAction.run(l);
    }

    public static void debugWindow(Window window) {
        AquaUtils.execute(window, AquaUtils::nativeDebugWindow);
    }

    private static native long nativeGetNativeWindow(Window var0, Object[] var1);

    private static native void nativeSetTitledWindowStyle(Window var0, boolean var1, Insets var2);

    private static native void nativeSetWindowTextured(Window var0, boolean var1);

    private static native void nativeSetWindowBackground(Window var0, Color var1);

    private static native boolean nativeIsFullScreenWindow(long var0);

    private static native int nativeSetTitleBarStyle(long var0, int var2);

    private static native int nativeSetTitleBarProperties(long var0, boolean var2, boolean var3, boolean var4, boolean var5);

    private static native int nativeAddToolbarToWindow(long var0);

    private static native int nativeSetWindowCornerRadius(long var0, float var2);

    private static native int nativeSetWindowRepresentedFilename(long var0, String var2);

    private static native int nativeSetAWTViewVisibility(long var0, boolean var2);

    private static native int nativeSyncAWTView(long var0);

    private static native int nativeGetLeftSideBearing(JComponent var0, FontMetrics var1, char var2);

    public static native boolean nativeHasOpaqueBeenExplicitlySet(JComponent var0);

    public static native void nativeInstallAATextInfo(UIDefaults var0);

    private static native void nativeSetWindowVisibleField(Window var0, boolean var1);

    public static native void disablePopupCache(Popup var0);

    public static native boolean getScreenMenuBarProperty();

    public static native void setScreenMenuBar(JFrame var0, MenuBarUI var1);

    public static native void clearScreenMenuBar(JFrame var0, MenuBarUI var1);

    private static native int nativeSetWindowAppearance(long var0, @Nullable String var2);

    @Nullable
    private static native String nativeGetWindowEffectiveAppearanceName(long var0);

    @Nullable
    public static native String nativeGetApplicationAppearanceName();

    private static native void registerWindowChangedAppearanceCallback(@NotNull WindowAppearanceChangedCallback var0);

    public static native int nativeDebugWindow(long var0);

    public static native void syslog(String var0);

    static {
        AquaUtils.registerWindowChangedAppearanceCallback(new WindowAppearanceChangedCallback(){

            @Override
            public void windowAppearanceChanged(@NotNull Window window, @NotNull String string) {
                if (window instanceof RootPaneContainer) {
                    RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
                    SwingUtilities.invokeLater(() -> {
                        JRootPane jRootPane = rootPaneContainer.getRootPane();
                        AquaRootPaneUI aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class);
                        if (aquaRootPaneUI != null) {
                            aquaRootPaneUI.windowAppearanceChanged(string);
                        }
                    });
                }
            }
        });
        enableAnimations = new RecyclableSingleton<Boolean>(){

            @Override
            protected Boolean getInstance() {
                String string = AccessController.doPrivileged(() -> System.getProperty(AquaUtils.ANIMATIONS_PROPERTY));
                return !"false".equals(string);
            }
        };
        appContextMap = new HashMap<Object, Object>();
    }

    public static interface NativeAction {
        public long run(long var1);
    }

    public static abstract class RecyclableSingleton<T> {
        @Nullable
        final T get() {
            return (T)AquaUtils.getSoftReferenceValue(this, () -> this.getInstance());
        }

        void reset() {
            AquaUtils.put(this, null);
        }

        @Nullable
        protected abstract T getInstance();
    }

    static interface Selectable {
        public void paintSelected(boolean var1);
    }

    private static class ShadowMaker
    implements ActionListener,
    Runnable {
        @NotNull
        private final Window w;

        public ShadowMaker(@NotNull Window window) {
            this.w = window;
            SwingUtilities.invokeLater(this);
            Timer timer = new Timer(100, this);
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        @Override
        public void run() {
            JRootPane jRootPane = AquaUtils.getRootPane(this.w);
            if (jRootPane != null) {
                AquaUtils.syncAWTView(this.w);
                jRootPane.putClientProperty("apple.awt.windowShadow.revalidateNow", Math.random());
            }
        }
    }

    public static interface NativeObjectAction<T> {
        public T run(long var1);
    }

    private static interface WindowAppearanceChangedCallback {
        public void windowAppearanceChanged(@NotNull Window var1, @NotNull String var2);
    }

    static class SlicedShadowBorder
    extends ShadowBorder {
        private final AquaImageFactory.SlicedImageControl slices;

        SlicedShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            super(painter, painter2, n, n2, f, f2, n3);
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 3);
            super.paintBorder(null, bufferedImage.getGraphics(), 0, 0, n4, n5);
            this.slices = new AquaImageFactory.SlicedImageControl(bufferedImage, n6, n7, n8, n9, false);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.slices.paint(graphics, n, n2, n3, n4);
        }
    }

    static class ShadowBorder
    implements Border {
        private final Painter prePainter;
        private final Painter postPainter;
        private final int offsetX;
        private final int offsetY;
        private final float distance;
        private final int blur;
        private final Insets insets;
        private final ConvolveOp blurOp;

        ShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3) {
            this.prePainter = painter;
            this.postPainter = painter2;
            this.offsetX = n;
            this.offsetY = n2;
            this.distance = f;
            this.blur = n3;
            int n4 = n3 / 2;
            this.insets = new Insets(n4 - n2, n4 - n, n4 + n2, n4 + n);
            float f3 = f2 / (float)(n3 * n3);
            float[] fArray = new float[n3 * n3];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f3;
            }
            this.blurOp = new ConvolveOp(new Kernel(n3, n3, fArray));
        }

        @Override
        public final boolean isBorderOpaque() {
            return false;
        }

        @Override
        public final Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BufferedImage bufferedImage = new BufferedImage(n3 + this.blur * 2, n4 + this.blur * 2, 3);
            this.paintToImage(bufferedImage, n, n2, n3, n4);
            graphics.drawImage(bufferedImage, -this.blur, -this.blur, null);
        }

        private void paintToImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, n3 + this.blur * 2, n4 + this.blur * 2);
            int n5 = (int)((float)(n + this.blur + this.offsetX) + (float)this.insets.left * this.distance);
            int n6 = (int)((float)(n2 + this.blur + this.offsetY) + (float)this.insets.top * this.distance);
            int n7 = (int)((float)n3 - (float)(this.insets.left + this.insets.right) * this.distance);
            int n8 = (int)((float)n4 - (float)(this.insets.top + this.insets.bottom) * this.distance);
            graphics2D.setComposite(AlphaComposite.DstAtop);
            if (this.prePainter != null) {
                this.prePainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.DstAtop);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.drawImage(bufferedImage, this.blurOp, 0, 0);
            if (this.postPainter != null) {
                this.postPainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
        }
    }

    static interface Painter {
        public void paint(Graphics var1, int var2, int var3, int var4, int var5);
    }

    static abstract class LazyKeyedSingleton<K, V> {
        private Map<K, V> refs;

        LazyKeyedSingleton() {
        }

        V get(K k) {
            V v;
            if (this.refs == null) {
                this.refs = new HashMap();
            }
            if ((v = this.refs.get(k)) != null) {
                return v;
            }
            V v2 = this.getInstance(k);
            this.refs.put(k, v2);
            return v2;
        }

        protected abstract V getInstance(K var1);
    }

    static class RecyclableSingletonFromDefaultConstructor<T>
    extends RecyclableSingleton<T> {
        private final Class<T> clazz;

        RecyclableSingletonFromDefaultConstructor(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        @Nullable
        protected T getInstance() {
            return AquaUtils.instantiate(this.clazz);
        }
    }
}

