/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaTreeMouseBehavior;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.SelectionRepaintable;
import org.violetlib.aqua.TreeSelectionBoundsTracker;
import org.violetlib.aqua.VisualEffectView;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AnimatedButtonConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaTreeUI
extends BasicTreeUI
implements SelectionRepaintable,
AquaComponentUI {
    public static final String IS_CELL_FILLED_KEY = "JTree.isCellFilled";
    public static final String QUAQUA_IS_CELL_FILLED_KEY = "Quaqua.Tree.isCellFilled";
    public static final String TREE_STYLE_KEY = "JTree.style";
    public static final String QUAQUA_TREE_STYLE_KEY = "Quaqua.Tree.style";
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 0;
    private final PropertyChangeListener propertyChangeListener = new AquaPropertyChangeListener();
    private final FocusListener editingComponentFocusListener = new EditingComponentFocusListener();
    private Component editorFocusOwner;
    protected TreePath fTrackingPath;
    protected boolean fIsPressed = false;
    protected boolean fIsInBounds = false;
    protected float fAnimationTransition = -1.0f;
    protected TreeArrowMouseInputHandler fMouseHandler;
    private boolean ignoreLAChange;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected boolean isCellFilled;
    protected boolean isSideBar;
    protected boolean isStriped;
    protected boolean shouldPaintSelection;
    protected boolean isActive;
    protected boolean isFocused;
    private Font oldCellRendererFont;
    private Icon oldCellRendererIcon;
    private Icon oldCellRendererDisabledIcon;
    private SidebarVibrantEffects sidebarVibrantEffects;
    private static DropTargetListener defaultDropTargetListener = null;
    @NotNull
    protected ContainerContextualColors colors = AquaColors.CONTAINER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTreeUI();
    }

    public boolean isSideBar() {
        return this.isSideBar;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Object object = this.tree.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(object);
        this.tree.setRootVisible(false);
        this.tree.putClientProperty("JComponent.isCellContainer", true);
        this.isStriped = this.getStripedValue();
        this.updateProperties();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        AppearanceManager.installListener(this.tree);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.tree);
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.tree);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.colors = this.determineColors();
        this.colors.configureForContainer();
        AquaColors.installColors(this.tree, this.appearanceContext, this.colors);
        this.tree.repaint();
        this.repaintScrollPane();
    }

    @NotNull
    protected ContainerContextualColors determineColors() {
        if (this.isSideBar) {
            return AquaColors.SIDEBAR_CONTAINER_COLORS;
        }
        if (this.isStriped) {
            return AquaColors.STRIPED_CONTAINER_COLORS;
        }
        return AquaColors.CONTAINER_COLORS;
    }

    protected void repaintScrollPane() {
        JViewport jViewport;
        Container container;
        Container container2;
        if (this.isSideBar && (container2 = this.tree.getParent()) instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.repaint();
        }
    }

    protected AquaUIPainter.State getState() {
        return this.tree.isEnabled() ? (this.isFocused ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    protected void updateProperties() {
        if (this.tree != null) {
            this.isCellFilled = Boolean.TRUE.equals(AquaUtils.getBooleanProperty(this.tree, IS_CELL_FILLED_KEY, QUAQUA_IS_CELL_FILLED_KEY));
            String string = this.getStyleProperty();
            boolean bl = string != null && (string.equals("sideBar") || string.equals("sourceList"));
            this.updateStriped();
            if (bl != this.isSideBar) {
                this.isSideBar = bl;
                this.updateSidebar();
            }
        }
    }

    protected void updateSidebar() {
        if (this.isSideBar && this.tree.isDisplayable()) {
            this.ensureSidebarVibrantEffects();
        } else {
            this.disposeSidebarVibrantEffects();
        }
    }

    protected void ensureSidebarVibrantEffects() {
        JComponent jComponent = this.getComponentForVisualEffectView();
        if (this.sidebarVibrantEffects != null && this.sidebarVibrantEffects.getComponent() != jComponent) {
            this.disposeSidebarVibrantEffects();
        }
        if (this.sidebarVibrantEffects == null) {
            this.sidebarVibrantEffects = new SidebarVibrantEffects(jComponent);
        }
    }

    protected void disposeSidebarVibrantEffects() {
        if (this.sidebarVibrantEffects != null) {
            this.sidebarVibrantEffects.dispose();
            this.sidebarVibrantEffects = null;
        }
    }

    @NotNull
    protected JComponent getComponentForVisualEffectView() {
        Container container = this.tree.getParent();
        if (container instanceof JViewport) {
            return (JViewport)container;
        }
        return this.tree;
    }

    protected boolean shouldDisplayAsFocused() {
        return this.tree.isEditing() || AquaFocusHandler.hasFocus(this.tree);
    }

    private void updateStriped() {
        boolean bl = this.getStripedValue();
        if (bl != this.isStriped) {
            this.isStriped = bl;
            this.configureAppearanceContext(null);
        }
    }

    private boolean getStripedValue() {
        String string = this.getStyleProperty();
        return "striped".equals(string) && this.isBackgroundClear();
    }

    private boolean isBackgroundClear() {
        Color color = this.tree.getBackground();
        return color.getAlpha() == 0 || color instanceof ColorUIResource;
    }

    public boolean isStriped() {
        return this.isStriped;
    }

    protected boolean isCellFilledProperty(String string) {
        return AquaUtils.isProperty(string, IS_CELL_FILLED_KEY, QUAQUA_IS_CELL_FILLED_KEY);
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, TREE_STYLE_KEY, QUAQUA_TREE_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.tree, TREE_STYLE_KEY, QUAQUA_TREE_STYLE_KEY);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new AquaTreeMouseBehavior(this.tree);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MacPropertyChangeHandler();
    }

    @Override
    public boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        boolean bl = super.startEditing(treePath, mouseEvent);
        if (bl) {
            this.editorFocusOwner = AquaFocusHandler.getFocusableComponent(this.editingComponent);
            if (this.editorFocusOwner != null) {
                this.editorFocusOwner.addFocusListener(this.editingComponentFocusListener);
            }
        }
        return bl;
    }

    @Override
    public void completeEditing() {
        super.completeEditing();
    }

    @Override
    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.editorFocusOwner != null) {
            this.editorFocusOwner.removeFocusListener(this.editingComponentFocusListener);
        }
        super.completeEditing(bl, bl2, bl3);
        this.configureAppearanceContext(null);
    }

    @Override
    public boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        return super.isLocationInExpandControl(treePath, n, n2);
    }

    @Override
    public void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        super.checkForClickInExpandControl(treePath, n, n2);
    }

    public void setAnchorSelectionPath(TreePath treePath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    public TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeadSelectionPath(TreePath treePath, boolean bl) {
        Rectangle rectangle = bl ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        if (bl) {
            if (rectangle != null) {
                this.tree.repaint(rectangle);
            }
            if ((rectangle = this.getPathBounds(this.tree, treePath)) != null) {
                this.tree.repaint(rectangle);
            }
        }
    }

    public TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    public void setLeadSelectionPath(TreePath treePath) {
        this.setLeadSelectionPath(treePath, false);
    }

    @Override
    protected void setShowsRootHandles(boolean bl) {
        super.setShowsRootHandles(true);
    }

    @Override
    protected boolean getShowsRootHandles() {
        return true;
    }

    protected void decodeLineStyle(Object object) {
        if (object == null || NO_STYLE_STRING.equals(object)) {
            this.lineStyle = 0;
            return;
        }
        if (LEG_LINE_STYLE_STRING.equals(object)) {
            this.lineStyle = 2;
        } else if (HORIZ_STYLE_STRING.equals(object)) {
            this.lineStyle = 1;
        }
    }

    @Override
    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        if (jTree == null || this.treeState == null) {
            return null;
        }
        Insets insets = jTree.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        return this.treeState.getPathClosestTo(n - insets.left, n2 - insets.top);
    }

    @Override
    public void repaintSelection() {
        if (this.tree == null) {
            return;
        }
        Object object = this.tree.getClientProperty("JTree.selectionRepainter");
        if (object instanceof SelectionRepaintable) {
            SelectionRepaintable selectionRepaintable = (SelectionRepaintable)object;
            selectionRepaintable.repaintSelection();
            return;
        }
        Rectangle rectangle = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                if (i == 0) {
                    rectangle = this.getPathBounds(this.tree, treePathArray[i]);
                    continue;
                }
                rectangle.add(this.getPathBounds(this.tree, treePathArray[i]));
            }
            if (rectangle != null) {
                this.tree.repaint(0, rectangle.y, this.tree.getWidth(), rectangle.height);
            }
        }
    }

    @Override
    protected int getRowX(int n, int n2) {
        if (this.isSideBar && n2 > 1) {
            --n2;
        }
        return this.totalChildIndent * (n2 + this.depthOffset);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    public void paint(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        if (this.treeState == null || this.appearanceContext == null) {
            return;
        }
        if (this.sidebarVibrantEffects != null) {
            this.sidebarVibrantEffects.update();
        }
        this.isActive = AquaFocusHandler.isActive(jComponent);
        this.isFocused = this.shouldDisplayAsFocused();
        this.shouldPaintSelection = !Boolean.FALSE.equals(this.tree.getClientProperty("JTree.paintSelectionBackground"));
        Color color = this.getCurrentBackground();
        this.paintBackground(graphics, color);
        super.paint(graphics, jComponent);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(graphics, jComponent);
        }
    }

    protected void paintBackground(@NotNull Graphics graphics, @Nullable Color color) {
        if (this.tree.isOpaque()) {
            int n = this.tree.getWidth();
            int n2 = this.tree.getHeight();
            AquaUtils.fillRect(graphics, color, 0, 0, n, n2);
        }
        Rectangle rectangle = graphics.getClipBounds();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        if (treePath != null && enumeration != null) {
            this.paintRowBackgrounds(graphics, treePath, enumeration);
        } else if (this.isStriped) {
            this.paintEmptyTreeStripes(graphics);
        }
    }

    @Nullable
    public Color getCurrentBackground() {
        if (this.isSideBar) {
            return null;
        }
        return this.tree.getBackground();
    }

    protected void paintRowBackgrounds(Graphics graphics, TreePath treePath, Enumeration enumeration) {
        TreePath treePath2;
        if (!this.isStriped && !this.shouldPaintSelection) {
            return;
        }
        this.colors.configureForContainer();
        int n = this.tree.getWidth();
        int n2 = this.tree.getHeight();
        Insets insets = this.tree.getInsets();
        int n3 = n - insets.left - insets.left;
        int n4 = this.tree.getRowHeight();
        if (n4 <= 0) {
            n4 = this.tree.getFont().getSize() + 4;
        }
        int n5 = this.treeState.getRowForPath(treePath);
        Rectangle rectangle = graphics.getClipBounds();
        int n6 = rectangle.y + rectangle.height;
        while (enumeration.hasMoreElements() && (treePath2 = (TreePath)enumeration.nextElement()) != null) {
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath2);
            if (rectangle2 == null) {
                return;
            }
            Color color = this.getSpecialBackgroundForRow(n5);
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(insets.left, rectangle2.y, n3, rectangle2.height);
            }
            if (rectangle2.y + rectangle2.height >= n6) break;
            ++n5;
        }
        this.colors.configureForContainer();
    }

    @Nullable
    protected Color getSpecialBackgroundForRow(int n) {
        boolean bl;
        AppearanceContext appearanceContext = this.appearanceContext;
        boolean bl2 = bl = this.tree.isRowSelected(n) && this.shouldPaintSelection;
        if (bl) {
            if (this.sidebarVibrantEffects != null) {
                return null;
            }
            appearanceContext = appearanceContext.withSelected(true);
        } else if (!this.isStriped) {
            return null;
        }
        this.colors.configureForRow(n, bl);
        return this.colors.getBackground(appearanceContext);
    }

    protected void paintEmptyTreeStripes(Graphics graphics) {
        assert (this.appearanceContext != null);
        int n = this.tree.getWidth();
        int n2 = this.tree.getHeight();
        Insets insets = this.tree.getInsets();
        int n3 = n - insets.left - insets.left;
        int n4 = this.tree.getRowHeight();
        if (n4 <= 0) {
            n4 = this.tree.getFont().getSize() + 4;
        }
        int n5 = 0;
        for (int i = 0; i < n2; i += n4) {
            boolean bl = this.tree.isRowSelected(n5);
            this.colors.configureForRow(n5, bl);
            Color color = this.colors.getBackground(this.appearanceContext);
            graphics.setColor(color);
            graphics.fillRect(insets.left, i, n3, n4);
            ++n5;
        }
    }

    @Override
    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        assert (this.appearanceContext != null);
        if (this.editingComponent != null && this.editingRow == n) {
            return;
        }
        int n2 = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        boolean bl4 = this.tree.isRowSelected(n);
        this.colors.configureForRow(n, bl4);
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), bl4, bl, bl3, n, n2 == n);
        boolean bl5 = treePath.getPathCount() == 2;
        this.configureCellRenderer(false, component, bl5, n, bl4);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
        this.unconfigureCellRenderer(component);
    }

    protected void configureCellRenderer(boolean bl, Component component, boolean bl2, int n, boolean bl3) {
        JLabel jLabel;
        if (component instanceof DefaultTreeCellRenderer) {
            jLabel = (DefaultTreeCellRenderer)component;
            jLabel.setBorder(AquaLookAndFeel.NOTHING_BORDER);
            if (!bl) {
                assert (this.appearanceContext != null);
                ((DefaultTreeCellRenderer)jLabel).setBackgroundNonSelectionColor(AquaColors.CLEAR);
                ((DefaultTreeCellRenderer)jLabel).setBackgroundSelectionColor(AquaColors.CLEAR);
                ((DefaultTreeCellRenderer)jLabel).setBorderSelectionColor(AquaColors.CLEAR);
                ((DefaultTreeCellRenderer)jLabel).setTextNonSelectionColor(this.colors.getForeground(this.appearanceContext.withSelected(false)));
                ((DefaultTreeCellRenderer)jLabel).setTextSelectionColor(this.colors.getForeground(this.appearanceContext.withSelected(true)));
            }
        }
        if (component instanceof JLabel) {
            jLabel = (JLabel)component;
            this.oldCellRendererFont = jLabel.getFont();
            this.oldCellRendererIcon = jLabel.getIcon();
            this.oldCellRendererDisabledIcon = jLabel.getDisabledIcon();
            Color color = this.appearanceContext != null ? this.colors.getForeground(this.appearanceContext) : null;
            Font font = null;
            if (this.isSideBar) {
                Image image;
                Icon icon;
                Object object;
                Color color2 = null;
                if (this.appearanceContext != null) {
                    color = this.getSideBarForeground(bl2, bl3);
                    object = this.appearanceContext.getAppearance();
                    color2 = ((AquaAppearance)object).getColor("sidebarIcon");
                }
                if ((object = this.getSideBarFont(bl2, bl3)) != null) {
                    font = this.fixFont((Font)object);
                }
                if (bl2) {
                    jLabel.setIcon(null);
                    jLabel.setDisabledIcon(null);
                } else if (color2 != null && (icon = jLabel.getIcon()) != null && (image = AquaImageFactory.getProcessedImage(icon, (Object)color2)) != null) {
                    icon = new ImageIcon(image);
                    jLabel.setIcon(icon);
                }
            } else {
                Image image;
                AquaAppearance aquaAppearance;
                Color color3;
                Image image2;
                Icon icon = jLabel.getIcon();
                if (icon != null && (image2 = AquaIcon.getImageForIcon(icon)) != null && AquaImageFactory.isTemplateImage(image2) && (color3 = (aquaAppearance = this.appearanceContext.getAppearance()).getColor("treeIcon")) != null && (image = AquaImageFactory.getProcessedImage(icon, (Object)color3)) != null) {
                    icon = new ImageIcon(image);
                    jLabel.setIcon(icon);
                }
            }
            if (!bl && color != null) {
                jLabel.setForeground(color);
            }
            if (font != null) {
                jLabel.setFont(font);
            }
        }
    }

    protected void unconfigureCellRenderer(Component component) {
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setFont(this.oldCellRendererFont);
            jLabel.setIcon(this.oldCellRendererIcon);
            jLabel.setDisabledIcon(this.oldCellRendererDisabledIcon);
        }
    }

    protected Font getSideBarFont(boolean bl, boolean bl2) {
        if (bl) {
            return UIManager.getFont("Tree.sideBarCategory.font");
        }
        if (bl2) {
            return UIManager.getFont("Tree.sideBar.selectionFont");
        }
        return UIManager.getFont("Tree.sideBar.font");
    }

    protected Color getSideBarForeground(boolean bl, boolean bl2) {
        if (bl) {
            return AquaColors.getSystemColor(this.tree, "secondaryLabel");
        }
        AppearanceContext appearanceContext = this.appearanceContext;
        assert (appearanceContext != null);
        if (bl2) {
            appearanceContext = appearanceContext.withSelected(true);
        }
        return this.colors.getForeground(appearanceContext);
    }

    protected Font fixFont(Font font) {
        return font instanceof FontUIResource ? new MyFont(font) : font;
    }

    protected void paintHorizontalSeparators(Graphics graphics, JComponent jComponent) {
        graphics.setColor(UIManager.getColor("Tree.line"));
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y));
        int n2 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y + rectangle.height - 1));
        if (n <= -1 || n2 <= -1) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            Rectangle rectangle2;
            TreePath treePath = this.getPathForRow(this.tree, i);
            if (treePath == null || treePath.getPathCount() != 2 || (rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) == null) continue;
            graphics.drawLine(rectangle.x, rectangle2.y, rectangle.x + rectangle.width, rectangle2.y);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (this.lineStyle == 2) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.lineStyle == 2) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }
    }

    @Override
    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Icon icon;
        Object object = treePath.getLastPathComponent();
        if (bl3 || bl2 && this.treeModel.getChildCount(object) <= 0) {
            return;
        }
        Icon icon2 = icon = bl ? this.getExpandedIcon() : this.getCollapsedIcon();
        if (icon != null && !(icon instanceof UIResource)) {
            super.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            return;
        }
        boolean bl4 = AquaUtils.isLeftToRight(this.tree);
        int n2 = bl4 ? rectangle2.x - this.getRightChildIndent() + 1 : rectangle2.x + rectangle2.width + this.getRightChildIndent() - 1;
        int n3 = rectangle2.y + rectangle2.height / 2;
        AquaUIPainter.State state = this.getState(treePath);
        if (!this.fIsInBounds && state == AquaUIPainter.State.PRESSED) {
            state = AquaUIPainter.State.ACTIVE;
        }
        Configuration configuration = this.getDisclosureTriangleConfiguration(state, bl, bl4);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)configuration);
        int n4 = (int)Math.ceil(layoutInfo.getFixedVisualWidth());
        int n5 = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
        if (n4 == 0) {
            n4 = 20;
        }
        if (n5 == 0) {
            n5 = n4;
        }
        int n6 = n2 - n4 / 2;
        int n7 = n3 - n5 / 2;
        AquaUtils.configure(this.painter, this.tree, n4, n5);
        this.painter.getPainter(configuration).paint(graphics, (float)n6, (float)n7);
    }

    protected Configuration getDisclosureTriangleConfiguration(AquaUIPainter.State state, boolean bl, boolean bl2) {
        AquaUIPainter.UILayoutDirection uILayoutDirection;
        AquaUIPainter.ButtonWidget buttonWidget = AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE;
        AquaUIPainter.Size size = AquaUIPainter.Size.REGULAR;
        boolean bl3 = false;
        AquaUIPainter.ButtonState buttonState = bl ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        AquaUIPainter.UILayoutDirection uILayoutDirection2 = uILayoutDirection = bl2 ? AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT : AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT;
        if (this.fAnimationTransition >= 0.0f) {
            AquaUIPainter.ButtonState buttonState2 = buttonState == AquaUIPainter.ButtonState.ON ? AquaUIPainter.ButtonState.OFF : AquaUIPainter.ButtonState.ON;
            return new AnimatedButtonConfiguration(buttonWidget, size, state, bl3, buttonState, uILayoutDirection, buttonState2, this.fAnimationTransition);
        }
        return new ButtonConfiguration(buttonWidget, size, state, bl3, buttonState, uILayoutDirection);
    }

    @Override
    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        ImageIcon imageIcon;
        Image image;
        n = this.findCenteredX(n, icon.getIconWidth());
        n2 -= icon.getIconHeight() / 2;
        if (icon instanceof ImageIcon && AquaImageFactory.isTemplateImage(image = (imageIcon = (ImageIcon)icon).getImage())) {
            Color color = this.getIconColor();
            Image image2 = AquaImageFactory.getProcessedImage(image, (Object)color);
            boolean bl = graphics.drawImage(image2, n, n2, component);
            if (!bl) {
                new ImageIcon(image2);
                if (!graphics.drawImage(image2, n, n2, component)) {
                    AquaUtils.logError("Button icon not drawn!");
                }
            }
            return;
        }
        icon.paintIcon(component, graphics, n, n2);
    }

    @NotNull
    protected Color getIconColor() {
        return AquaColors.getSystemColor(this.tree, "expandControl");
    }

    private int findCenteredX(int n, int n2) {
        return this.tree.getComponentOrientation().isLeftToRight() ? n - (int)Math.ceil((double)n2 / 2.0) : n - (int)Math.floor((double)n2 / 2.0);
    }

    @Override
    public Icon getCollapsedIcon() {
        Icon icon = super.getCollapsedIcon();
        if (AquaUtils.isLeftToRight(this.tree)) {
            return icon;
        }
        if (!(icon instanceof UIResource)) {
            return icon;
        }
        return UIManager.getIcon("Tree.rightToLeftCollapsedIcon");
    }

    protected AquaUIPainter.State getState(TreePath treePath) {
        if (!this.tree.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (this.fIsPressed && this.fTrackingPath.equals(treePath)) {
            return AquaUIPainter.State.PRESSED;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.fMouseHandler = new TreeArrowMouseInputHandler(treePath);
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isMetaDown();
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new TreeNodeDimensions();
    }

    protected void updateDropTargetListener() {
        DropTarget dropTarget = this.tree.getDropTarget();
        if (dropTarget instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TreeDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected int getRowForPath(TreePath treePath) {
        return this.treeState.getRowForPath(treePath);
    }

    private Rectangle getPathBounds(TreePath treePath, Insets insets, Rectangle rectangle) {
        if ((rectangle = this.treeState.getBounds(treePath, rectangle)) != null) {
            rectangle.x = AquaUtils.isLeftToRight(this.tree) ? (rectangle.x += insets.left) : this.tree.getWidth() - (rectangle.x + rectangle.width) - insets.right;
            rectangle.y += insets.top;
        }
        return rectangle;
    }

    protected Rectangle getPathArrowBounds(TreePath treePath) {
        int n;
        Rectangle rectangle = this.getPathBounds(this.tree, treePath);
        Insets insets = this.tree.getInsets();
        rectangle.width = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
        int n2 = n = insets != null ? insets.left : 0;
        n = AquaUtils.isLeftToRight(this.tree) ? (n += (treePath.getPathCount() + this.depthOffset - 2) * this.totalChildIndent + this.getLeftChildIndent() - rectangle.width / 2) : (n += this.tree.getWidth() - 1 - (treePath.getPathCount() - 2 + this.depthOffset) * this.totalChildIndent - this.getLeftChildIndent() - rectangle.width / 2);
        rectangle.x = n;
        return rectangle;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.tree.getActionMap().put("aquaExpandNode", new KeyboardExpandCollapseAction(true, false));
        this.tree.getActionMap().put("aquaCollapseNode", new KeyboardExpandCollapseAction(false, false));
        this.tree.getActionMap().put("aquaFullyExpandNode", new KeyboardExpandCollapseAction(true, true));
        this.tree.getActionMap().put("aquaFullyCollapseNode", new KeyboardExpandCollapseAction(false, true));
    }

    private void expandNode(int n, boolean bl) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return;
        }
        this.tree.expandPath(treePath);
        if (!bl) {
            return;
        }
        this.expandAllNodes(treePath, n + 1);
    }

    private void expandAllNodes(TreePath treePath, int n) {
        int n2 = n;
        TreePath treePath2;
        while (treePath.isDescendant(treePath2 = this.getPathForRow(this.tree, n2))) {
            this.tree.expandPath(treePath2);
            ++n2;
        }
        return;
    }

    private void collapseNode(int n, boolean bl) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return;
        }
        if (bl) {
            this.collapseAllNodes(treePath, n + 1);
        }
        this.tree.collapsePath(treePath);
    }

    private void collapseAllNodes(TreePath treePath, int n) {
        TreePath treePath2;
        int n2 = -1;
        int n3 = n;
        while (n2 == -1) {
            treePath2 = this.getPathForRow(this.tree, n3);
            if (!treePath.isDescendant(treePath2)) {
                n2 = n3 - 1;
            }
            ++n3;
        }
        for (n3 = n2; n3 >= n; --n3) {
            treePath2 = this.getPathForRow(this.tree, n3);
            this.tree.collapsePath(treePath2);
        }
    }

    protected static JTree getComponent(DropTargetEvent dropTargetEvent) {
        DropTargetContext dropTargetContext = dropTargetEvent.getDropTargetContext();
        return (JTree)dropTargetContext.getComponent();
    }

    class AquaPropertyChangeListener
    implements PropertyChangeListener {
        AquaPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(AquaTreeUI.LINE_STYLE)) {
                AquaTreeUI.this.decodeLineStyle(propertyChangeEvent.getNewValue());
            } else if (string.equals("enabled")) {
                AquaTreeUI.this.configureAppearanceContext(null);
            }
        }
    }

    protected class EditingComponentFocusListener
    implements FocusListener {
        protected EditingComponentFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AquaTreeUI.this.stopEditing(AquaTreeUI.this.tree);
        }
    }

    protected class SidebarVibrantEffects
    extends VisualEffectView {
        protected TreeSelectionBoundsTracker bt;

        public SidebarVibrantEffects(final JComponent jComponent) {
            super(jComponent, 2, true);
            this.bt = new TreeSelectionBoundsTracker(AquaTreeUI.this.tree, this::updateSelectionBackgrounds){

                @Override
                protected int convertRowYCoordinateToSelectionDescription(int n) {
                    if (jComponent != this.tree) {
                        Point point = SwingUtilities.convertPoint(this.tree, 0, n, jComponent);
                        return point.y;
                    }
                    return n;
                }
            };
        }

        public void update() {
            if (this.bt != null) {
                this.bt.update();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.bt != null) {
                this.bt.dispose();
                this.bt = null;
            }
        }

        @Override
        protected void windowChanged(Window window) {
            super.windowChanged(window);
            if (this.bt != null) {
                this.bt.reset();
            }
        }
    }

    protected class FocusHandler
    extends BasicTreeUI.FocusHandler {
        protected FocusHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.focusChanged();
        }

        private void focusChanged() {
            AquaTreeUI.this.isFocused = AquaTreeUI.this.shouldDisplayAsFocused();
            AquaTreeUI.this.configureAppearanceContext(null);
        }
    }

    public class MacPropertyChangeHandler
    extends BasicTreeUI.PropertyChangeHandler {
        public MacPropertyChangeHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (propertyChangeEvent.getSource() == AquaTreeUI.this.tree) {
                if (string.equals("leadSelectionPath") && AquaTreeUI.this.ignoreLAChange) {
                    return;
                }
                if (string.equals("anchorSelectionPath") && AquaTreeUI.this.ignoreLAChange) {
                    return;
                }
                if (string.equals("transferHandler")) {
                    AquaTreeUI.this.updateDropTargetListener();
                    return;
                }
                if (AquaTreeUI.this.isCellFilledProperty(string)) {
                    AquaTreeUI.this.updateProperties();
                    AquaTreeUI.this.tree.repaint();
                    if (AquaTreeUI.this.treeState != null) {
                        AquaTreeUI.this.treeState.invalidateSizes();
                    }
                    return;
                }
                if (AquaTreeUI.this.isStyleProperty(string)) {
                    AquaTreeUI.this.updateProperties();
                    AquaTreeUI.this.tree.repaint();
                    return;
                }
                if (string.equals("ancestor")) {
                    AquaTreeUI.this.updateSidebar();
                }
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected class MyFont
    extends Font {
        public MyFont(Font font) {
            super(font);
        }
    }

    class TreeArrowMouseInputHandler
    extends MouseInputAdapter {
        protected Rectangle fPathBounds = new Rectangle();
        protected boolean fIsLeaf;
        protected boolean fIsExpanded;
        protected boolean fHasBeenExpanded;
        protected Rectangle fBounds;
        protected Rectangle fVisibleRect;
        int fTrackingRow;
        Insets fInsets;

        TreeArrowMouseInputHandler(TreePath treePath) {
            AquaTreeUI.this.fTrackingPath = treePath;
            this.fTrackingRow = AquaTreeUI.this.getRowForPath(AquaTreeUI.this.fTrackingPath);
            AquaTreeUI.this.fIsPressed = true;
            AquaTreeUI.this.fIsInBounds = true;
            this.fPathBounds = AquaTreeUI.this.getPathArrowBounds(treePath);
            AquaTreeUI.this.tree.addMouseListener(this);
            AquaTreeUI.this.tree.addMouseMotionListener(this);
            this.fVisibleRect = AquaTreeUI.this.tree.getVisibleRect();
            this.fInsets = AquaTreeUI.this.tree.getInsets();
            if (this.fInsets == null) {
                this.fInsets = new Insets(0, 0, 0, 0);
            }
            this.fIsLeaf = AquaTreeUI.this.treeModel.isLeaf(treePath.getLastPathComponent());
            if (this.fIsLeaf) {
                this.fHasBeenExpanded = false;
                this.fIsExpanded = false;
            } else {
                this.fIsExpanded = AquaTreeUI.this.treeState.getExpandedState(treePath);
                this.fHasBeenExpanded = AquaTreeUI.this.tree.hasBeenExpanded(treePath);
            }
            Rectangle rectangle = new Rectangle();
            this.fBounds = AquaTreeUI.this.getPathBounds(AquaTreeUI.this.fTrackingPath, this.fInsets, rectangle);
            this.paintOneControl();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(mouseEvent.getX(), mouseEvent.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(mouseEvent.getX(), mouseEvent.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            if (AquaTreeUI.this.fIsPressed) {
                boolean bl = AquaTreeUI.this.fIsInBounds;
                AquaTreeUI.this.fIsPressed = false;
                AquaTreeUI.this.fIsInBounds = false;
                if (bl) {
                    this.fIsExpanded = !this.fIsExpanded;
                    this.paintAnimation(this.fIsExpanded);
                    if (mouseEvent.isAltDown()) {
                        if (this.fIsExpanded) {
                            AquaTreeUI.this.expandNode(this.fTrackingRow, true);
                        } else {
                            AquaTreeUI.this.collapseNode(this.fTrackingRow, true);
                        }
                    } else {
                        AquaTreeUI.this.toggleExpandState(AquaTreeUI.this.fTrackingPath);
                    }
                }
            }
            AquaTreeUI.this.fTrackingPath = null;
            this.removeFromSource();
        }

        protected void paintAnimation(boolean bl) {
            this.paintAnimationFrame(0.0f);
            this.paintAnimationFrame(0.5f);
            this.paintAnimationFrame(1.0f);
            AquaTreeUI.this.fAnimationTransition = -1.0f;
        }

        protected void paintAnimationFrame(float f) {
            AquaTreeUI.this.fAnimationTransition = f;
            this.paintOneControl();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void paintOneControl() {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            Graphics graphics = AquaTreeUI.this.tree.getGraphics();
            if (graphics == null) {
                return;
            }
            try {
                graphics.setClip(this.fVisibleRect);
                if (AquaTreeUI.this.fTrackingPath == null) {
                    return;
                }
                TreePath treePath = AquaTreeUI.this.fTrackingPath.getParentPath();
                if (treePath != null) {
                    AquaTreeUI.this.paintVerticalPartOfLeg(graphics, this.fPathBounds, this.fInsets, treePath);
                    AquaTreeUI.this.paintHorizontalPartOfLeg(graphics, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                } else if (AquaTreeUI.this.isRootVisible() && this.fTrackingRow == 0) {
                    AquaTreeUI.this.paintHorizontalPartOfLeg(graphics, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                }
                AquaTreeUI.this.paintExpandControl(graphics, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
            }
            finally {
                graphics.dispose();
            }
        }

        protected void removeFromSource() {
            AquaTreeUI.this.tree.removeMouseListener(this);
            AquaTreeUI.this.tree.removeMouseMotionListener(this);
        }
    }

    protected class TreeNodeDimensions
    extends BasicTreeUI.NodeDimensionsHandler {
        protected TreeNodeDimensions() {
            super(AquaTreeUI.this);
        }

        @Override
        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            Rectangle rectangle2 = this.getBasicNodeDimensions(object, n, n2, bl, rectangle);
            if (AquaTreeUI.this.isCellFilled && rectangle2 != null && (AquaTreeUI.this.editingComponent == null || AquaTreeUI.this.editingRow != n) && AquaTreeUI.this.tree.getWidth() > 0) {
                int n3;
                Insets insets = AquaTreeUI.this.tree.getInsets();
                rectangle2.width = n3 = AquaTreeUI.this.tree.getWidth() - insets.right - rectangle2.x;
            }
            return rectangle2;
        }

        public Rectangle getBasicNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (AquaTreeUI.this.editingComponent != null && AquaTreeUI.this.editingRow == n) {
                Dimension dimension = AquaTreeUI.this.editingComponent.getPreferredSize();
                int n3 = AquaTreeUI.this.getRowHeight();
                if (n3 > 0 && n3 != dimension.height) {
                    dimension.height = n3;
                }
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            if (AquaTreeUI.this.currentCellRenderer != null) {
                boolean bl2 = true;
                Component component = AquaTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(AquaTreeUI.this.tree, object, bl2, bl, AquaTreeUI.this.treeModel.isLeaf(object), n, false);
                boolean bl3 = n2 == 1;
                AquaTreeUI.this.configureCellRenderer(true, component, bl3, n, bl2);
                if (AquaTreeUI.this.tree != null) {
                    AquaTreeUI.this.rendererPane.add(component);
                    component.validate();
                }
                Dimension dimension = component.getPreferredSize();
                AquaTreeUI.this.unconfigureCellRenderer(component);
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            return null;
        }
    }

    public static class TreeDropTargetListener
    extends DropTargetAdapter {
        private boolean isStateSaved;
        private int[] selectedIndices;

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            JTree jTree = AquaTreeUI.getComponent(dropTargetDragEvent);
            TransferHandler transferHandler = jTree.getTransferHandler();
            if (transferHandler.canImport(jTree, dropTargetDragEvent.getCurrentDataFlavors())) {
                this.saveComponentState(jTree);
                this.isStateSaved = true;
            } else {
                this.isStateSaved = false;
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            JTree jTree = AquaTreeUI.getComponent(dropTargetDragEvent);
            TransferHandler transferHandler = jTree.getTransferHandler();
            if (transferHandler.canImport(jTree, dropTargetDragEvent.getCurrentDataFlavors())) {
                this.updateInsertionLocation(jTree, dropTargetDragEvent.getLocation());
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.isStateSaved) {
                JTree jTree = AquaTreeUI.getComponent(dropTargetEvent);
                this.restoreComponentState(jTree);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        protected void saveComponentState(JTree jTree) {
            this.selectedIndices = jTree.getSelectionRows();
        }

        protected void restoreComponentState(JTree jTree) {
            jTree.setSelectionRows(this.selectedIndices);
        }

        protected void updateInsertionLocation(JTree jTree, Point point) {
            BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
            TreePath treePath = basicTreeUI.getClosestPathForLocation(jTree, point.x, point.y);
            if (treePath != null) {
                jTree.setSelectionPath(treePath);
            }
        }
    }

    class KeyboardExpandCollapseAction
    extends AbstractAction {
        private final boolean expand;
        private final boolean recursive;

        public KeyboardExpandCollapseAction(boolean bl, boolean bl2) {
            this.expand = bl;
            this.recursive = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AquaTreeUI.this.tree == null || 0 > AquaTreeUI.this.getRowCount(AquaTreeUI.this.tree)) {
                return;
            }
            TreePath[] treePathArray = AquaTreeUI.this.tree.getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            for (int i = treePathArray.length - 1; i >= 0; --i) {
                TreePath treePath = treePathArray[i];
                if (this.expand) {
                    AquaTreeUI.this.expandNode(AquaTreeUI.this.tree.getRowForPath(treePath), this.recursive);
                    continue;
                }
                if (treePathArray.length == 1 && AquaTreeUI.this.tree.isCollapsed(treePath)) {
                    TreePath treePath2 = treePath.getParentPath();
                    if (treePath2 == null || treePath2.getParentPath() == null && !AquaTreeUI.this.tree.isRootVisible()) continue;
                    AquaTreeUI.this.tree.scrollPathToVisible(treePath2);
                    AquaTreeUI.this.tree.setSelectionPath(treePath2);
                    continue;
                }
                AquaTreeUI.this.collapseNode(AquaTreeUI.this.tree.getRowForPath(treePath), this.recursive);
            }
        }

        @Override
        public boolean isEnabled() {
            return AquaTreeUI.this.tree != null && AquaTreeUI.this.tree.isEnabled();
        }
    }
}

