/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.plaf.TableUI;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaTableUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.SelectionRepaintable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.treetable.TreeTable;
import org.violetlib.treetable.TreeTableCellRenderer;
import org.violetlib.treetable.ui.BasicTreeTableUI;

public class AquaTreeTableUI
extends BasicTreeTableUI
implements AquaComponentUI {
    protected MyHandler handler = new MyHandler();
    @NotNull
    protected ContainerContextualColors colors;
    @Nullable
    protected AppearanceContext appearanceContext;

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListener(this.treeTable);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.treeTable);
        super.uninstallListeners();
    }

    @Override
    protected BasicTreeTableUI.Handler createHandler() {
        return this.handler;
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        JTable jTable = this.getTable();
        JTree jTree = this.getTree();
        AppearanceManager.updateAppearancesInSubtree(jTable);
        AppearanceManager.updateAppearancesInSubtree(jTree);
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        JTable jTable = this.getTable();
        JTree jTree = this.getTree();
        AquaFocusHandler.updateComponentTreeUIActivation(jTable, bl);
        AquaFocusHandler.updateComponentTreeUIActivation(jTree, bl);
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.treeTable);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        boolean bl = this.computeStriped();
        this.colors = bl ? AquaColors.STRIPED_CONTAINER_COLORS : AquaColors.CONTAINER_COLORS;
        this.colors.configureForContainer();
        AquaColors.installColors(this.treeTable, this.appearanceContext, this.colors);
        this.treeTable.repaint();
    }

    protected AquaUIPainter.State getState() {
        return this.treeTable.isEnabled() ? (AquaFocusHandler.hasFocus(this.treeTable) ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    protected boolean computeStriped() {
        JTable jTable = this.getTable();
        AquaTableUI aquaTableUI = AquaUtils.getUI(jTable, AquaTableUI.class);
        return aquaTableUI != null && aquaTableUI.isStriped();
    }

    @Override
    protected JTree createAndConfigureTree() {
        JTree jTree = super.createAndConfigureTree();
        jTree.setFocusable(false);
        jTree.putClientProperty("Component.hasFocusDelegate", this.treeTable);
        jTree.putClientProperty("JTree.paintSelectionBackground", false);
        return jTree;
    }

    @Override
    protected JTable createAndConfigureTable() {
        JTable jTable = super.createAndConfigureTable();
        jTable.setFocusable(false);
        jTable.putClientProperty("Component.hasFocusDelegate", this.treeTable);
        return jTable;
    }

    @Override
    protected void finishConfiguration(JTree jTree, JTable jTable) {
        jTree.putClientProperty("JTree.selectionRepainter", jTable);
        this.configureAppearanceContext(null);
    }

    @Override
    protected TreeTableCellRenderer createFocusRenderer() {
        return null;
    }

    @Override
    protected boolean hasTreeHandle(TreeTable treeTable, TreePath treePath) {
        return !treeTable.isLeaf(treePath);
    }

    @Override
    protected List<String> getProperties() {
        ArrayList<String> arrayList = new ArrayList<String>(super.getProperties());
        arrayList.add("Frame.active");
        return arrayList;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeListener();
    }

    public void repaintSelection() {
        TableUI tableUI = this.getTable().getUI();
        if (tableUI instanceof SelectionRepaintable) {
            SelectionRepaintable selectionRepaintable = (SelectionRepaintable)((Object)tableUI);
            selectionRepaintable.repaintSelection();
        }
    }

    protected void handleDoubleClick(TreePath treePath) {
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    protected class MyHandler
    extends BasicTreeTableUI.Handler {
        protected MyHandler() {
        }

        @Override
        protected void focusChanged() {
            AquaTreeTableUI.this.configureAppearanceContext(null);
            AquaTreeTableUI.this.repaintSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if ("Frame.active".equals(propertyChangeEvent.getPropertyName())) {
                AquaTreeTableUI.this.getTree().putClientProperty("Frame.active", propertyChangeEvent.getNewValue());
                AquaTreeTableUI.this.getTable().putClientProperty("Frame.active", propertyChangeEvent.getNewValue());
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaTreeTableUI.this.handler.propertyChange(propertyChangeEvent);
        }
    }
}

