/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaInternalFrameUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;

public class AquaTitleBar {
    private static final int sMaxIconWidth = 15;
    private static final int sMaxIconHeight = 15;
    private static final int sAfterIconPad = 5;
    protected final AquaUIPainter titleBarPainter = AquaPainting.create();
    protected final JInternalFrame frame;
    protected final AquaUIPainter.TitleBarWidget widget;
    protected final TitleBarLayoutConfiguration layoutConfiguration;
    protected final int titleBarHeight;
    private int width;
    private TitleBarLayout titleBarLayout;

    public AquaTitleBar(JInternalFrame jInternalFrame, AquaUIPainter.TitleBarWidget titleBarWidget) {
        this.frame = jInternalFrame;
        this.widget = titleBarWidget;
        this.layoutConfiguration = new TitleBarLayoutConfiguration(this.widget);
        LayoutInfo layoutInfo = this.titleBarPainter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)this.layoutConfiguration);
        this.titleBarHeight = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
    }

    public void setWidth(int n) {
        if (n != this.width) {
            this.width = n;
            this.invalidateLayout();
        }
    }

    public void invalidateLayout() {
        this.titleBarLayout = null;
    }

    public int getTitleBarHeight() {
        return this.titleBarHeight;
    }

    public int getWhichButtonHit(int n, int n2) {
        TitleBarLayout titleBarLayout = this.getTitleBarLayout();
        if (titleBarLayout.closeButtonBounds.contains(n, n2)) {
            return 0;
        }
        if (titleBarLayout.minimizeButtonBounds.contains(n, n2)) {
            return 1;
        }
        if (titleBarLayout.resizeButtonBounds.contains(n, n2)) {
            return 2;
        }
        return -1;
    }

    public boolean getWithinRolloverArea(int n, int n2) {
        if (n2 < 0 || n2 >= this.titleBarHeight) {
            return false;
        }
        TitleBarLayout titleBarLayout = this.getTitleBarLayout();
        return n >= titleBarLayout.buttonAreaLeft && n <= titleBarLayout.buttonAreaRight;
    }

    protected TitleBarLayout getTitleBarLayout() {
        if (this.titleBarLayout == null) {
            this.titleBarLayout = this.createTitleBarLayout();
        }
        return this.titleBarLayout;
    }

    protected TitleBarLayout createTitleBarLayout() {
        TitleBarLayout titleBarLayout = new TitleBarLayout();
        titleBarLayout.buttonAreaLeft = Integer.MAX_VALUE;
        titleBarLayout.buttonAreaRight = 0;
        AquaUILayoutInfo aquaUILayoutInfo = this.titleBarPainter.getLayoutInfo();
        for (AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget : Arrays.asList(AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX, AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX, AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX)) {
            Insetter insetter = aquaUILayoutInfo.getTitleBarButtonInsets(this.layoutConfiguration, titleBarButtonWidget);
            Rectangle rectangle = insetter.apply(this.width, this.titleBarHeight);
            titleBarLayout.buttonAreaLeft = Math.min(titleBarLayout.buttonAreaLeft, rectangle.x);
            titleBarLayout.buttonAreaRight = Math.max(titleBarLayout.buttonAreaRight, rectangle.x + rectangle.width);
            if (titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
                titleBarLayout.closeButtonBounds = rectangle;
                continue;
            }
            if (titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX) {
                titleBarLayout.minimizeButtonBounds = rectangle;
                continue;
            }
            if (titleBarButtonWidget != AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX) continue;
            titleBarLayout.resizeButtonBounds = rectangle;
        }
        Insetter insetter = this.titleBarPainter.getLayoutInfo().getTitleBarLabelInsets(this.layoutConfiguration);
        if (insetter != null) {
            titleBarLayout.titleBounds = insetter.apply(this.width, this.titleBarHeight);
        }
        return titleBarLayout;
    }

    public void paint(@NotNull Graphics graphics) {
        AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(this.frame);
        boolean bl = AquaFocusHandler.isActive(this.frame) && (this.frame.isSelected() || this.widget == AquaUIPainter.TitleBarWidget.UTILITY_WINDOW);
        EffectName effectName = bl ? EffectName.EFFECT_NONE : EffectName.EFFECT_DISABLED;
        Color color = aquaAppearance.getColorForOptionalEffect("text", effectName);
        assert (color != null);
        TitleBarConfiguration titleBarConfiguration = this.getConfiguration();
        AquaUtils.configure(this.titleBarPainter, this.frame.getRootPane(), this.width, this.titleBarHeight);
        this.titleBarPainter.getPainter((Configuration)titleBarConfiguration).paint(graphics, 0.0f, 0.0f);
        this.paintTitleContents(graphics, color);
    }

    public Rectangle getButtonArea() {
        TitleBarLayout titleBarLayout = this.getTitleBarLayout();
        return new Rectangle(titleBarLayout.buttonAreaLeft, 0, titleBarLayout.buttonAreaRight - titleBarLayout.buttonAreaLeft, this.titleBarHeight);
    }

    protected TitleBarConfiguration getConfiguration() {
        AquaUIPainter.State state = this.frame.isSelected() && AquaFocusHandler.isActive(this.frame) ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
        AquaUIPainter.State state2 = this.getButtonState(0, this.isClosable());
        AquaUIPainter.State state3 = this.getButtonState(1, this.isIconifiable());
        AquaUIPainter.State state4 = this.getButtonState(2, this.isMaximizable());
        TitleBarConfiguration.ResizeAction resizeAction = this.getResizeAction(this.frame);
        boolean bl = this.isDirty();
        return new TitleBarConfiguration(this.widget, state, state2, state3, state4, resizeAction, bl);
    }

    protected boolean isClosable() {
        return this.frame.isClosable();
    }

    protected boolean isIconifiable() {
        return this.frame.isIconifiable() && !this.frame.isMaximum();
    }

    protected boolean isMaximizable() {
        return this.frame.isMaximizable();
    }

    protected AquaUIPainter.State getButtonState(int n, boolean bl) {
        AquaInternalFrameUI aquaInternalFrameUI = (AquaInternalFrameUI)this.frame.getUI();
        int n2 = aquaInternalFrameUI.getWhichButtonPressed();
        boolean bl2 = aquaInternalFrameUI.getMouseOverPressedButton();
        boolean bl3 = aquaInternalFrameUI.getRollover();
        boolean bl4 = this.frame.isSelected() || this.widget == AquaUIPainter.TitleBarWidget.UTILITY_WINDOW;
        boolean bl5 = AquaFocusHandler.isActive(this.frame) && (bl3 || bl4);
        return this.getState(n2 == n && bl2, bl3, bl5, bl);
    }

    protected AquaUIPainter.State getState(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl4) {
            return AquaUIPainter.State.DISABLED;
        }
        if (!bl3) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (bl) {
            return AquaUIPainter.State.PRESSED;
        }
        if (bl2) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected void paintTitleContents(@NotNull Graphics graphics, @NotNull Color color) {
        TitleBarLayout titleBarLayout = this.getTitleBarLayout();
        Rectangle rectangle = titleBarLayout.titleBounds;
        if (rectangle == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.frame.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = rectangle.y + (rectangle.height + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
        int n2 = this.getIconWidth();
        if (n2 > 0) {
            n2 += 5;
        }
        int n3 = rectangle.width - n2;
        String string = this.frame.getTitle();
        int n4 = 0;
        int n5 = rectangle.x;
        boolean bl = false;
        if (string != null && !string.equals("")) {
            n4 = SwingUtilities.computeStringWidth(fontMetrics, string);
            String string2 = "\u2026";
            if (n4 > n3) {
                int n6;
                int n7;
                bl = true;
                n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n7 = 0; n7 < string.length() && n4 + (n6 = fontMetrics.charWidth(string.charAt(n7))) <= n3; ++n7) {
                    n4 += n6;
                }
                string = string.substring(0, n7) + string2;
            }
            if (!bl && (n5 = (rectangle.width - (n4 + n2)) / 2) < rectangle.x) {
                n5 = rectangle.x;
            }
            graphics.setColor(color);
            JavaSupport.drawString(this.frame, (Graphics2D)graphics, string, n5 + n2, n);
            graphics.setFont(font);
        }
        int n8 = rectangle.y + (rectangle.height - this.getIconHeight()) / 2;
        this.paintTitleIcon(graphics, n5, n8);
    }

    protected void paintTitleIcon(Graphics graphics, int n, int n2) {
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon == null) {
            return;
        }
        if (icon instanceof ImageIcon && (icon.getIconWidth() > 15 || icon.getIconHeight() > 15)) {
            Image image = ((ImageIcon)icon).getImage();
            ((ImageIcon)icon).setImage(image.getScaledInstance(15, 15, 4));
        }
        icon.paintIcon(this.frame, graphics, n, n2);
    }

    protected int getIconWidth() {
        int n = 0;
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null) {
            n = Math.min(icon.getIconWidth(), 15);
        }
        return n;
    }

    protected int getIconHeight() {
        int n = 0;
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null) {
            n = Math.min(icon.getIconHeight(), 15);
        }
        return n;
    }

    protected TitleBarConfiguration.ResizeAction getResizeAction(JInternalFrame jInternalFrame) {
        AquaInternalFrameUI aquaInternalFrameUI = (AquaInternalFrameUI)jInternalFrame.getUI();
        if (jInternalFrame.isMaximizable() && !aquaInternalFrameUI.getOption()) {
            return jInternalFrame.isMaximum() ? TitleBarConfiguration.ResizeAction.FULL_SCREEN_EXIT : TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER;
        }
        return TitleBarConfiguration.ResizeAction.ZOOM_ENTER;
    }

    protected boolean isDirty() {
        Object object = this.frame.getClientProperty("windowModified");
        return Boolean.TRUE.equals(object);
    }

    private class TitleBarLayout {
        int buttonAreaLeft;
        int buttonAreaRight;
        Rectangle titleBounds;
        Rectangle closeButtonBounds;
        Rectangle minimizeButtonBounds;
        Rectangle resizeButtonBounds;

        private TitleBarLayout() {
        }
    }
}

