/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Border2D;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insets2DUIResource;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;

public class AquaTextComponentBorder
extends AquaBorder
implements FocusRingOutlineProvider,
Border2D {
    @NotNull
    protected final JTextComponent tc;

    public AquaTextComponentBorder(@NotNull JTextComponent jTextComponent) {
        this.tc = jTextComponent;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintBackground(@NotNull Component component, Graphics graphics, @Nullable Color color) {
        if (component.isOpaque()) {
            if (color != null) {
                graphics.setColor(color);
                int n = component.getWidth();
                int n2 = component.getHeight();
                graphics.fillRect(0, 0, n, n2);
            }
        } else {
            Painter painter = this.getConfiguredPainter(component);
            painter.paint(graphics, 0.0f, 0.0f);
        }
    }

    @NotNull
    public LayoutInfo getLayoutInfo() {
        TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration();
        return this.painter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)textFieldLayoutConfiguration);
    }

    @Override
    @Nullable
    public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
        if (jComponent == this.tc) {
            TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration();
            AppearanceManager.ensureAppearance(this.tc);
            AquaUtils.configure(this.painter, this.tc, this.tc.getWidth(), this.tc.getHeight());
            return this.painter.getOutline((LayoutConfiguration)textFieldLayoutConfiguration);
        }
        return null;
    }

    public int getTextMargin() {
        if (AquaCellEditorPolicy.getInstance().getCellStatus(this.tc) != null) {
            return 1;
        }
        AquaUIPainter.TextFieldWidget textFieldWidget = this.getWidget();
        int n = textFieldWidget == AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND ? 11 : 3;
        Insets insets = this.getBorderInsets(this.tc);
        int n2 = (insets.left + insets.right) / 2;
        return Math.max(0, n - n2);
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component component) {
        if (AquaCellEditorPolicy.getInstance().getCellStatus(this.tc) != null) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        Insetter insetter = this.getTextInsets();
        Insets2D insets2D = insetter.asInsets2D();
        if (insets2D != null) {
            int n = (int)Math.ceil(insets2D.getLeft());
            int n2 = (int)Math.ceil(insets2D.getRight());
            int n3 = (int)Math.floor(insets2D.getTop());
            int n4 = (int)Math.ceil(insets2D.getBottom());
            return new InsetsUIResource(n3, n, n4, n2);
        }
        return new InsetsUIResource(3, 3, 3, 3);
    }

    @Override
    @NotNull
    public Insets2D getBorderInsets2D(@NotNull Component component) {
        if (AquaCellEditorPolicy.getInstance().getCellStatus(this.tc) != null) {
            return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
        }
        Insetter insetter = this.getTextInsets();
        Insets2D insets2D = insetter.asInsets2D();
        if (insets2D != null) {
            return new Insets2DUIResource(insets2D);
        }
        return new Insets2DUIResource(3.0f, 3.0f, 3.0f, 3.0f);
    }

    @NotNull
    public Insetter getTextInsets() {
        TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration();
        return this.painter.getLayoutInfo().getTextFieldTextInsets(textFieldLayoutConfiguration);
    }

    protected int getExtraHeight() {
        TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration();
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldLayoutConfiguration.getWidget();
        switch (textFieldWidget) {
            case TEXT_FIELD: 
            case TEXT_FIELD_ROUND: {
                return 3;
            }
        }
        return 0;
    }

    @NotNull
    protected Painter getConfiguredPainter(@NotNull Component component) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        AppearanceManager.ensureAppearance(this.tc);
        AquaUtils.configure(this.painter, this.tc, n, n2);
        TextFieldConfiguration textFieldConfiguration = this.getConfiguration();
        return this.painter.getPainter((Configuration)textFieldConfiguration);
    }

    @NotNull
    protected TextFieldLayoutConfiguration getLayoutConfiguration() {
        AquaUIPainter.TextFieldWidget textFieldWidget = this.getWidget();
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(this.tc);
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(this.tc);
        return new TextFieldLayoutConfiguration(textFieldWidget, size, uILayoutDirection);
    }

    @NotNull
    protected TextFieldConfiguration getConfiguration() {
        AquaUIPainter.TextFieldWidget textFieldWidget = this.getWidget();
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(this.tc);
        AquaUIPainter.State state = this.getState();
        boolean bl = AquaUIPainter.State.ACTIVE == state && this.tc.hasFocus();
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(this.tc);
        return new TextFieldConfiguration(textFieldWidget, size, state, bl, uILayoutDirection);
    }

    @NotNull
    protected AquaUIPainter.TextFieldWidget getWidget() {
        Object object = this.tc.getClientProperty("JTextField.style");
        if ("round".equals(object)) {
            return AquaUtils.isOnToolbar(this.tc) ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND;
        }
        if (AquaUtils.isOnToolbar(this.tc)) {
            return AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND_TOOLBAR;
        }
        return AquaUIPainter.TextFieldWidget.TEXT_FIELD;
    }

    @NotNull
    protected AquaUIPainter.State getState() {
        if (!AquaFocusHandler.isActive(this.tc)) {
            return this.tc.isEnabled() ? AquaUIPainter.State.INACTIVE : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        return this.tc.isEnabled() ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.DISABLED;
    }
}

