/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaTableHeaderCellRenderer;
import org.violetlib.aqua.AquaTableUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.EffectName;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaTableHeaderUI
extends BasicTableHeaderUI
implements AquaComponentUI {
    protected int borderHeight;
    private TableCellRenderer prevRenderer = null;
    private PropertyChangeListener propertyChangeListener;
    @NotNull
    protected BasicContextualColors colors = AquaColors.TABLE_HEADER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;
    @Nullable
    protected Color separatorColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTableHeaderUI();
    }

    @Nullable
    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public int getBorderHeight() {
        return this.borderHeight;
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.borderHeight = UIManager.getInt("TableHeader.borderHeight");
        this.prevRenderer = this.header.getDefaultRenderer();
        if (this.prevRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new AquaTableHeaderCellRenderer());
        }
        this.configureAppearanceContext(null);
    }

    @Override
    public void uninstallDefaults() {
        if (this.header.getDefaultRenderer() instanceof AquaTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.prevRenderer);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new AquaPropertyChangeListener();
        this.header.addPropertyChangeListener(this.propertyChangeListener);
        AppearanceManager.installListener(this.header);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.header);
        this.header.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.header);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(this.header, this.appearanceContext, this.colors);
        EffectName effectName = state == AquaUIPainter.State.ACTIVE ? EffectName.EFFECT_NONE : EffectName.EFFECT_DISABLED;
        this.separatorColor = aquaAppearance.getColorForEffect("tableHeaderSeparator", effectName);
        this.header.repaint();
    }

    @NotNull
    protected AquaUIPainter.State getState() {
        return AquaFocusHandler.isActive(this.header) ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Color color = jComponent.getBackground();
        if (jComponent.isOpaque()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        AquaTableHeaderPainter aquaTableHeaderPainter = new AquaTableHeaderPainter(color);
        aquaTableHeaderPainter.paint(graphics, jComponent);
        if (this.separatorColor != null) {
            graphics.setColor(this.separatorColor);
            graphics.fillRect(0, jComponent.getHeight() - this.borderHeight, jComponent.getWidth(), this.borderHeight);
        }
    }

    private int getHeaderHeightAqua() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (tableColumn.getHeaderRenderer() == null && bl) continue;
            Component component = this.getHeaderRendererAqua(i);
            int n2 = component.getPreferredSize().height;
            n = Math.max(n, n2);
            if (n2 <= 4) continue;
            bl = true;
        }
        return n + this.borderHeight;
    }

    private Component getHeaderRendererAqua(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private Dimension createHeaderSizeAqua(long l) {
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeightAqua());
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSizeAqua(l);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSizeAqua(l);
    }

    private class AquaPropertyChangeListener
    implements PropertyChangeListener {
        private AquaPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTable jTable;
            AquaTableUI aquaTableUI;
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && string.equals("background") && (aquaTableUI = AquaUtils.getUI(jTable = AquaTableHeaderUI.this.header.getTable(), AquaTableUI.class)) != null) {
                aquaTableUI.repaintScrollPaneCorner();
            }
        }
    }

    private class AquaTableHeaderPainter {
        @NotNull
        private final Color background;

        public AquaTableHeaderPainter(Color color) {
            this.background = color;
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            int n;
            if (AquaTableHeaderUI.this.header.getColumnModel().getColumnCount() <= 0) {
                return;
            }
            boolean bl = AquaTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            Rectangle rectangle = graphics.getClipBounds();
            Point point = rectangle.getLocation();
            Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
            TableColumnModel tableColumnModel = AquaTableHeaderUI.this.header.getColumnModel();
            int n2 = AquaTableHeaderUI.this.header.columnAtPoint(bl ? point : point2);
            int n3 = AquaTableHeaderUI.this.header.columnAtPoint(bl ? point2 : point);
            if (n2 == -1) {
                n2 = 0;
            }
            if (n3 == -1) {
                n3 = tableColumnModel.getColumnCount() - 1;
            }
            TableColumn tableColumn = AquaTableHeaderUI.this.header.getDraggedColumn();
            Rectangle rectangle2 = AquaTableHeaderUI.this.header.getHeaderRect(bl ? n2 : n3);
            if (bl) {
                for (n = n2; n <= n3; ++n) {
                    int n4;
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                    rectangle2.width = n4 = tableColumn2.getWidth();
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle2, n);
                    }
                    rectangle2.x += n4;
                }
            } else {
                for (n = n3; n >= n2; --n) {
                    int n5;
                    TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                    rectangle2.width = n5 = tableColumn3.getWidth();
                    if (tableColumn3 != tableColumn) {
                        this.paintCell(graphics, rectangle2, n);
                    }
                    rectangle2.x += n5;
                }
            }
            if (tableColumn != null) {
                n = this.viewIndexForColumn(tableColumn);
                Rectangle rectangle3 = AquaTableHeaderUI.this.header.getHeaderRect(n);
                graphics.setColor(AquaTableHeaderUI.this.header.getParent().getBackground());
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                rectangle3.x += AquaTableHeaderUI.this.header.getDraggedDistance();
                graphics.setColor(this.background);
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                this.paintCell(graphics, rectangle3, n);
            }
            AquaTableHeaderUI.this.rendererPane.removeAll();
        }

        private Component getHeaderRenderer(int n) {
            TableColumn tableColumn = AquaTableHeaderUI.this.header.getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = AquaTableHeaderUI.this.header.getDefaultRenderer();
            }
            boolean bl = !AquaTableHeaderUI.this.header.isPaintingForPrint() && AquaTableHeaderUI.this.header.hasFocus();
            Component component = tableCellRenderer.getTableCellRendererComponent(AquaTableHeaderUI.this.header.getTable(), tableColumn.getHeaderValue(), false, bl, -1, n);
            return component;
        }

        private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
            Color color;
            Color color2;
            Component component = this.getHeaderRenderer(n);
            Color color3 = this.getOverrideCellBackground(n);
            if (color3 != null) {
                component.setBackground(color3);
            }
            if ((color2 = component.getBackground()) instanceof ColorUIResource) {
                color = AquaColors.CLEAR;
                component.setBackground(color);
            }
            if ((color = component.getForeground()) instanceof ColorUIResource) {
                boolean bl = false;
                assert (AquaTableHeaderUI.this.appearanceContext != null);
                AppearanceContext appearanceContext = AquaTableHeaderUI.this.appearanceContext.withSelected(bl);
                Color color4 = AquaTableHeaderUI.this.colors.getForeground(appearanceContext);
                component.setForeground(color4);
            }
            AquaTableHeaderUI.this.rendererPane.paintComponent(graphics, component, AquaTableHeaderUI.this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            Color color5 = component.getForeground();
            if (color5 instanceof UIResource) {
                component.setForeground(null);
            }
            if ((color3 = component.getBackground()) instanceof UIResource) {
                component.setBackground(null);
            }
        }

        protected Color getOverrideCellBackground(int n) {
            return null;
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel tableColumnModel = AquaTableHeaderUI.this.header.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                if (tableColumnModel.getColumn(i) != tableColumn) continue;
                return i;
            }
            return -1;
        }
    }
}

