/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaSplitPaneUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;

public class AquaSplitPaneDivider
extends BasicSplitPaneDivider {
    private final AquaUIPainter painter = AquaPainting.create();
    protected final AquaSplitPaneUI ui;
    private static final AquaUtils.LazyKeyedSingleton<Integer, Image> directionArrows = new AquaUtils.LazyKeyedSingleton<Integer, Image>(){

        @Override
        protected Image getInstance(Integer n) {
            Image image = AquaImageFactory.getArrowImageForDirection(n);
            if (image != null) {
                int n2 = image.getHeight(null) * 5 / 7;
                int n3 = image.getWidth(null) * 5 / 7;
                Image image2 = image.getScaledInstance(n3, n2, 4);
                return AquaImageFactory.getProcessedImage(image2, AquaImageFactory.LIGHTEN_50);
            }
            return null;
        }
    };

    public AquaSplitPaneDivider(AquaSplitPaneUI aquaSplitPaneUI) {
        super(aquaSplitPaneUI);
        this.ui = aquaSplitPaneUI;
        this.setLayout(new DividerLayout());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.splitPane) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                boolean bl = this.splitPane.isEnabled();
                if (this.leftButton != null) {
                    this.leftButton.setEnabled(bl);
                }
                if (this.rightButton != null) {
                    this.rightButton.setEnabled(bl);
                }
            } else if ("orientation".equals(string)) {
                if (this.rightButton != null) {
                    this.remove(this.rightButton);
                    this.rightButton = null;
                }
                if (this.leftButton != null) {
                    this.remove(this.leftButton);
                    this.leftButton = null;
                }
                this.oneTouchExpandableChanged();
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    protected int getMinDividerSize() {
        int n = this.ui.getFixedDividerSize();
        return n > 0 ? n : 2;
    }

    protected int getMaxDividerSize() {
        int n = this.ui.getFixedDividerSize();
        return n > 0 ? n : 11;
    }

    public int getDividerExtension() {
        return this.ui.getDividerExtension();
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(this.splitPane);
        Color color = aquaAppearance.getColor("separator");
        Dimension dimension = this.getSize();
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        boolean bl2 = this.splitPane.getOrientation() == 1;
        int n4 = this.getMinDividerSize();
        int n5 = this.getMaxDividerSize();
        if (bl2) {
            if (dimension.width > n5) {
                n = dimension.width - n5;
                n2 = n / 2;
                dimension.width = n5;
            }
            if (dimension.width < n4) {
                bl = false;
            }
        } else {
            if (dimension.height > n5) {
                n = dimension.height - n5;
                n3 = n / 2;
                dimension.height = n5;
            }
            if (dimension.height < n4) {
                bl = false;
            }
        }
        if (bl) {
            AquaUIPainter.DividerWidget dividerWidget = this.ui.getWidget();
            AquaUIPainter.State state = this.getState();
            AquaUIPainter.Orientation orientation = bl2 ? AquaUIPainter.Orientation.VERTICAL : AquaUIPainter.Orientation.HORIZONTAL;
            AquaUtils.configure(this.painter, this.splitPane, dimension.width, dimension.height);
            SplitPaneDividerConfiguration splitPaneDividerConfiguration = new SplitPaneDividerConfiguration(dividerWidget, state, orientation, 0);
            this.painter.getPainter((Configuration)splitPaneDividerConfiguration).paint(graphics, (float)n2, (float)n3);
        } else {
            AquaUtils.fillRect(graphics, color, n2, n3, dimension.width, dimension.height);
        }
        super.paint(graphics);
    }

    protected AquaUIPainter.State getState() {
        return this.splitPane.isEnabled() ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.DISABLED;
    }

    @Override
    protected void dragDividerTo(int n) {
        ((AquaSplitPaneUI)this.splitPaneUI).dragDividerTo(n += this.getDividerExtension());
    }

    @Override
    protected void finishDraggingTo(int n) {
        ((AquaSplitPaneUI)this.splitPaneUI).finishDraggingTo(n += this.getDividerExtension());
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        return AquaSplitPaneDivider.createButtonForDirection(this.getDirection(true));
    }

    @Override
    protected JButton createRightOneTouchButton() {
        return AquaSplitPaneDivider.createButtonForDirection(this.getDirection(false));
    }

    @NotNull
    static JButton createButtonForDirection(int n) {
        Image image = directionArrows.get(n);
        JButton jButton = image != null ? new JButton(new ImageIcon(image)) : new JButton();
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setRequestFocusEnabled(false);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return jButton;
    }

    int getDirection(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.splitPane.getOrientation() == 1;
        if (bl2) {
            return bl ? 7 : 3;
        }
        return bl ? 1 : 5;
    }

    protected class DividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected DividerLayout() {
            super(AquaSplitPaneDivider.this);
        }

        @Override
        public void layoutContainer(Container container) {
            boolean bl;
            int n = AquaSplitPaneDivider.this.getMaxDividerSize();
            Dimension dimension = AquaSplitPaneDivider.this.getSize();
            if (AquaSplitPaneDivider.this.leftButton == null || AquaSplitPaneDivider.this.rightButton == null || container != AquaSplitPaneDivider.this) {
                return;
            }
            if (!AquaSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                AquaSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                AquaSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                return;
            }
            Icon icon = AquaSplitPaneDivider.this.leftButton.getIcon();
            Icon icon2 = AquaSplitPaneDivider.this.rightButton.getIcon();
            int n2 = Math.max(icon.getIconWidth(), icon2.getIconWidth());
            int n3 = Math.max(icon.getIconHeight(), icon2.getIconHeight());
            boolean bl2 = bl = AquaSplitPaneDivider.this.splitPane.getOrientation() == 1;
            if (bl) {
                if (n2 > dimension.width || n2 > n) {
                    AquaSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    AquaSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                    return;
                }
                int n4 = dimension.width - n2;
                int n5 = n4 / 2;
                int n6 = n3 + 2;
                AquaSplitPaneDivider.this.rightButton.setBounds(n5, n6, n2, n3);
                AquaSplitPaneDivider.this.leftButton.setBounds(n5, n6 -= n3 + 2, n2, n3);
            } else {
                if (n3 > dimension.height || n3 > n) {
                    AquaSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    AquaSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                    return;
                }
                int n7 = dimension.height - n3;
                int n8 = n7 / 2;
                int n9 = n2 + 2;
                AquaSplitPaneDivider.this.rightButton.setBounds(n9, n8, n2, n3);
                AquaSplitPaneDivider.this.leftButton.setBounds(n9 -= n2 + 2, n8, n2, n3);
            }
        }
    }
}

