/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BackgroundPainter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;

public class AquaBoxPainter
implements BackgroundPainter {
    private static final int topInset = 10;
    private static final int sideInset = 15;
    private static final int topBorderInset = 15;
    private static final int sideBorderInset = 23;
    private static final int titleIndent = 10;
    private static Border titledBorder = new BorderUIResource.EmptyBorderUIResource(26, 23, 15, 23);
    private static Border titlelessBorder = new BorderUIResource.EmptyBorderUIResource(15, 23, 15, 23);
    protected final AquaUIPainter painter = AquaPainting.create();
    private static final AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaBoxPainter> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaBoxPainter>(AquaBoxPainter.class);

    public static AquaBoxPainter getInstance() {
        return (AquaBoxPainter)instance.get();
    }

    public static Border getBorderForTitledBox() {
        return titledBorder;
    }

    public static Border getTitlelessBorder() {
        return titlelessBorder;
    }

    @Override
    public void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = jComponent.getInsets();
        int n5 = Math.max(0, insets.left - 15);
        int n6 = Math.max(0, insets.top - 10);
        int n7 = Math.max(0, n3 - n5 - Math.max(0, insets.right - 15));
        int n8 = Math.max(0, n4 - n6 - Math.max(0, insets.bottom - 10));
        AquaUtils.configure(this.painter, jComponent, n7, n8);
        Configuration configuration = this.getConfiguration();
        this.painter.getPainter(configuration).paint(graphics, (float)n5, (float)n6);
        Object object = jComponent.getClientProperty("Aqua.groupBoxTitle");
        if (object instanceof String) {
            String string = (String)object;
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(AquaFonts.getControlTextSmallFont());
            Dimension dimension = jLabel.getPreferredSize();
            int n9 = dimension.width;
            int n10 = dimension.height;
            if (n6 >= n10) {
                int n11 = n5 + 10;
                int n12 = n6 - n10;
                graphics.translate(n11, n12);
                jLabel.setSize(n9, n10);
                jLabel.paint(graphics);
                graphics.translate(-n11, -n12);
            }
        }
    }

    protected Configuration getConfiguration() {
        return new GroupBoxConfiguration(AquaUIPainter.State.ACTIVE, false);
    }
}

