/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.vappearances.VAppearance;
import org.violetlib.vappearances.VAppearances;

public class AquaAppearances {
    @NotNull
    private static final Map<String, AquaAppearance> appearances = new HashMap<String, AquaAppearance>();
    @NotNull
    private static final String defaultAppearanceName = "NSAppearanceNameAqua";
    @NotNull
    private static final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    @NotNull
    public static AquaAppearance get(@NotNull String string) {
        AquaAppearance aquaAppearance = appearances.get(string);
        if (aquaAppearance == null) {
            try {
                VAppearance vAppearance = VAppearances.getAppearance((String)string);
                aquaAppearance = new AquaAppearance(vAppearance);
            }
            catch (IOException iOException) {
                AquaUtils.syslog("Unable to get " + string + ": " + iOException.getMessage());
                aquaAppearance = AquaAppearances.getDefaultAppearance();
            }
            appearances.put(string, aquaAppearance);
        }
        return aquaAppearance;
    }

    @NotNull
    public static AquaAppearance getDefaultAppearance() {
        AquaAppearance aquaAppearance = appearances.get(defaultAppearanceName);
        if (aquaAppearance == null) {
            try {
                VAppearance vAppearance = VAppearances.getAppearance((String)defaultAppearanceName);
                aquaAppearance = new AquaAppearance(vAppearance);
            }
            catch (IOException iOException) {
                AquaUtils.syslog("Unable to get NSAppearanceNameAqua: " + iOException.getMessage());
                iOException.printStackTrace();
                throw new UnsupportedOperationException("Default appearance NSAppearanceNameAqua is not available");
            }
            appearances.put(defaultAppearanceName, aquaAppearance);
        }
        return aquaAppearance;
    }

    @NotNull
    public static AquaAppearance getVibrantAppearance(@NotNull AquaAppearance aquaAppearance) {
        String string = aquaAppearance.getName();
        if (string.contains("Vibrant")) {
            return aquaAppearance;
        }
        if (string.contains("Dark")) {
            return AquaAppearances.get("NSAppearanceNameVibrantDark");
        }
        return AquaAppearances.get("NSAppearanceNameVibrantLight");
    }

    public static void addChangeListener(@NotNull ChangeListener changeListener) {
        changeListeners.add(changeListener);
    }

    public static void removeChangeListener(@NotNull ChangeListener changeListener) {
        changeListeners.remove(changeListener);
    }

    private static void appearanceChanged(@NotNull ChangeEvent changeEvent) {
        if (changeEvent instanceof VAppearances.AppearanceChangeEvent) {
            VAppearances.AppearanceChangeEvent appearanceChangeEvent = (VAppearances.AppearanceChangeEvent)changeEvent;
            VAppearance vAppearance = appearanceChangeEvent.getAppearance();
            String string = vAppearance.getName();
            AquaAppearance aquaAppearance = new AquaAppearance(vAppearance);
            appearances.put(string, aquaAppearance);
            for (ChangeListener changeListener : changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        } else {
            throw new RuntimeException("Unexpected change event: " + changeEvent);
        }
    }

    static {
        VAppearances.addChangeListener(AquaAppearances::appearanceChanged);
    }
}

