/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.jnr.aqua.AquaNativeRendering;
import org.violetlib.vappearances.VAppearance;

public class AquaAppearance
implements VAppearance {
    @NotNull
    private final VAppearance appearance;
    @NotNull
    private final Map<String, Color> colors;
    @NotNull
    private static final Colors defaultColors = AquaAppearance.createDefaultColors();
    @NotNull
    private static final Colors lightColors = AquaAppearance.createLightColors();
    @NotNull
    private static final Colors darkColors = AquaAppearance.createDarkColors();
    @NotNull
    private static final Colors highContrastLightColors = AquaAppearance.createHighContrastLightColors();
    @NotNull
    private static final Colors highContrastDarkColors = AquaAppearance.createHighContrastDarkColors();
    private static final int NO_INACTIVE = 1;

    public AquaAppearance(@NotNull VAppearance vAppearance) {
        this.appearance = vAppearance;
        Colors colors = new Colors();
        colors.add(defaultColors);
        colors.addAll(vAppearance.getColors());
        Map map = AquaNativeRendering.createPainter().getColors(vAppearance);
        colors.addAll(map);
        if (vAppearance.isDark()) {
            colors.add(darkColors);
            if (vAppearance.isHighContrast()) {
                colors.add(highContrastDarkColors);
            }
        } else {
            colors.add(lightColors);
            if (vAppearance.isHighContrast()) {
                colors.add(highContrastLightColors);
            }
        }
        AquaAppearance.installFixups(colors, vAppearance);
        this.colors = colors.getColors();
    }

    @NotNull
    public String getName() {
        return this.appearance.getName();
    }

    public boolean isDark() {
        return this.appearance.isDark();
    }

    public boolean isHighContrast() {
        return this.appearance.isHighContrast();
    }

    @NotNull
    public Map<String, Color> getColors() {
        return this.appearance.getColors();
    }

    @Nullable
    public Color getColor(@NotNull String string) {
        Color color = this.colors.get(string);
        if (AquaColors.isDebugging()) {
            AquaUtils.logDebug("  Color " + string + ": " + AquaColors.toString(color));
        }
        return color;
    }

    @Nullable
    public Color getColorForEffect(@NotNull String string, @NotNull EffectName effectName) {
        if (effectName == EffectName.EFFECT_NONE) {
            return this.colors.get(string);
        }
        String string2 = string + "_" + effectName;
        Color color = this.colors.get(string2);
        return color;
    }

    @Nullable
    public Color getColorForOptionalEffect(@NotNull String string, @NotNull EffectName effectName) {
        if (effectName == EffectName.EFFECT_NONE) {
            return this.colors.get(string);
        }
        String string2 = string + "_" + effectName;
        Color color = this.colors.get(string2);
        return color != null ? color : this.colors.get(string);
    }

    public boolean isBasedOn(@NotNull VAppearance vAppearance) {
        return vAppearance == this.appearance;
    }

    @NotNull
    private static Colors createDefaultColors() {
        Colors colors = new Colors();
        colors.add("clear", 0, 0);
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("selectedTextBackground_inactive", "unemphasizedSelectedTextBackground");
            colors.add("selectedCellBackground_inactive", "unemphasizedSelectedTextBackground");
        } else {
            colors.add("selectedTextBackground_inactive", "clear");
            colors.add("selectedCellBackground_inactive", "clear");
        }
        colors.add("texturedWindowBackground", "windowBackground");
        colors.add("texturedWindowBackground_disabled", "windowBackground_disabled");
        colors.add("topWindowMarginBackground", "windowBackground");
        colors.add("topWindowMarginBackground_disabled", "windowBackground_disabled");
        colors.add("bottomWindowMarginBackground", "windowBackground");
        colors.add("bottomWindowMarginBackground_disabled", "windowBackground_disabled");
        colors.add("topTexturedWindowMarginBackground", "texturedWindowBackground");
        colors.add("topTexturedWindowMarginBackground_disabled", "texturedWindowBackground_disabled");
        colors.add("bottomTexturedWindowMarginBackground", "texturedWindowBackground");
        colors.add("bottomTexturedWindowMarginBackground_disabled", "texturedWindowBackground_disabled");
        colors.add("topWindowDivider", "separator");
        colors.add("topWindowDivider_disabled", "separator_disabled");
        colors.add("bottomWindowDivider", "separator");
        colors.add("bottomWindowDivider_disabled", "separator_disabled");
        colors.add("topTexturedWindowDivider", "separator");
        colors.add("topTexturedWindowDivider_disabled", "separator_disabled");
        colors.add("bottomTexturedWindowDivider", "separator");
        colors.add("bottomTexturedWindowDivider_disabled", "separator_disabled");
        colors.add("text_inactive", "text");
        colors.add("selectedText_inactive", "unemphasizedSelectedText");
        colors.add("textBackground_inactive", "textBackground");
        colors.add("cellBackground", "textBackground");
        colors.add("selectedCellBackground", "selectedTextBackground");
        colors.addAll("cell", "text");
        colors.add("selectedCell_focused", "alternateSelectedControlText");
        colors.add("selectedCell", "unemphasizedSelectedText");
        colors.add("selectedCell_inactive", "unemphasizedSelectedText");
        colors.addAll("texturedToolbarText", "texturedText");
        colors.addAll("tabText", "segmentedText");
        colors.addAll("nonexclusiveTexturedText", "texturedText");
        colors.addAll("nonexclusiveText", "segmentedText");
        colors.addAll("segmentedSeparatedText", "segmentedText");
        colors.addAll("nonexclusiveSeparatedText", "segmentedSeparatedText");
        colors.addAll("nonexclusiveTexturedToolbarText", "nonexclusiveTexturedText");
        colors.addAll("texturedSegmentedText", "segmentedText");
        colors.addAll("texturedSegmentedToolbarText", "texturedSegmentedText");
        colors.addAll("gradientSegmentedText", "gradientText");
        colors.addAll("pushPopText", "pushButtonText");
        colors.addAll("roundedRectText", "gradientText", 1);
        colors.addAll("bevelText", "gradientText", 1);
        colors.defineNoInactive("pushButtonText");
        colors.addAll("segmentedText", "pushButtonText", 1);
        colors.add("segmentedText_pressed", "segmentedText");
        colors.add("selectedSegmentedText_pressed", "selectedSegmentedText");
        colors.add("texturedSegmentedText_pressed", "texturedSegmentedText");
        colors.add("selectedTexturedSegmentedText_pressed", "selectedTexturedSegmentedText");
        colors.add("nonexclusiveTexturedText_pressed", "nonexclusiveTexturedText");
        colors.add("selectedNonexclusiveTexturedText_pressed", "selectedNonexclusiveTexturedText");
        colors.add("texturedSegmentedToolbarText_pressed", "texturedSegmentedToolbarText");
        colors.add("selectedTexturedSegmentedToolbarText_pressed", "selectedTexturedSegmentedToolbarText");
        colors.add("nonexclusiveTexturedToolbarText_pressed", "nonexclusiveTexturedToolbarText");
        colors.add("selectedNonexclusiveTexturedToolbarText_pressed", "selectedNonexclusiveTexturedToolbarText");
        colors.defineNoInactive("gradientText");
        colors.add("selectedGradientText_disabled", "gradientText_disabled");
        return colors;
    }

    @NotNull
    private static Colors createLightColors() {
        Colors colors = new Colors();
        colors.add("texturedWindowBackground", 212);
        colors.add("texturedWindowBackground_disabled", 246);
        colors.add("capsLockIcon", 0, 100);
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("text_disabled", 0, 89);
            colors.add("textBackground_disabled", 255, 89);
            colors.add("windowBackground", 236);
            colors.add("separator_disabled", 0, 8);
            colors.add("controlText_disabled", 0, 77);
            colors.add("alternateSelectedControlText_disabled", 255, 89);
            colors.add("selectedMenuItemText", 255);
        }
        colors.add("windowBackground_disabled", "windowBackground");
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("systemBlue_disabled", 0, 122, 255, 89);
            colors.add("systemGray_disabled", 143, 143, 148, 89);
            colors.add("systemGreen_disabled", 41, 204, 64, 89);
            colors.add("systemOrange_disabled", 255, 148, 0, 89);
            colors.add("systemPurple_disabled", 89, 87, 214, 89);
            colors.add("systemRed_disabled", 255, 59, 48, 89);
            colors.add("systemYellow_disabled", 255, 204, 0, 89);
        }
        colors.add("tagBlue", 52, 148, 255);
        colors.add("tagGray", 164, 164, 168);
        colors.add("tagGreen", 91, 215, 105);
        colors.add("tagOrange", 255, 170, 71);
        colors.add("tagPurple", 190, 118, 229);
        colors.add("tagRed", 255, 99, 92);
        colors.add("tagYellow", 254, 214, 75);
        colors.add("tagBlue_disabled", 155, 203, 255);
        colors.add("tagGray_disabled", 210, 210, 212);
        colors.add("tagGreen_disabled", 175, 236, 181);
        colors.add("tagOrange_disabled", 255, 213, 165);
        colors.add("tagPurple_disabled", 223, 187, 243);
        colors.add("tagRed_disabled", 255, 177, 175);
        colors.add("tagYellow_disabled", 254, 235, 168);
        if (OSXSystemProperties.OSVersion == 1013) {
            colors.add("openOptionsArea", 205);
            colors.add("saveOptionsArea", 229);
        } else if (OSXSystemProperties.OSVersion >= 1014) {
            colors.add("openOptionsArea", 212);
            colors.add("saveOptionsArea", 236);
        }
        colors.add("selectedBrowserExpandArrow", 110);
        colors.add("selectedBrowserExpandArrow_focused", 255);
        colors.add("browserExpandArrow", 127);
        colors.add("scrollPaneGrabber", 163);
        colors.add("scrollPaneBorder", 197);
        colors.add("texturedText", 0, 170);
        colors.add("texturedText_focused", 0);
        colors.add("texturedText_disabled", 0, 64);
        colors.add("texturedText_inactive", 178);
        colors.add("texturedText_pressed", 34);
        colors.add("texturedText_inactive_disabled", 211);
        colors.add("selectedTexturedText", 255);
        colors.add("selectedTexturedText_disabled", 255, 155);
        colors.add("selectedTexturedText_pressed", "selectedTexturedText");
        colors.add("selectedTexturedText_inactive", 164);
        colors.add("selectedTexturedText_inactive_disabled", 185);
        colors.add("recessedText", 0, 160);
        colors.add("recessedText_disabled", 0, 64);
        colors.add("recessedText_inactive", 0, 64);
        colors.add("recessedText_pressed", 255);
        colors.add("recessedText_rollover", 255);
        colors.add("recessedText_inactive_disabled", 0, 32);
        colors.add("selectedRecessedText", 255);
        colors.add("selectedRecessedText_disabled", 255, 160);
        colors.add("selectedRecessedText_pressed", 255);
        colors.add("selectedRecessedText_rollover", 255);
        colors.add("selectedRecessedText_inactive", 0, 64);
        colors.add("selectedRecessedText_inactive_disabled", 0, 32);
        colors.add("pushButtonText", 34);
        colors.add("pushButtonText_disabled", 0, 64);
        colors.add("pushButtonText_pressed", 255, 224);
        colors.add("pushButtonText_focused", 250);
        colors.add("selectedPushButtonText", "alternateSelectedControlText");
        colors.add("pushPopText_pressed", 0, 224);
        colors.add("selectedSegmentedText", 255);
        colors.add("selectedSegmentedText_disabled", 172);
        colors.add("selectedSegmentedText_inactive", 34);
        if (OSXSystemProperties.OSVersion < 1011) {
            colors.add("selectedNonexclusiveTexturedText", 0, 122, 255);
            colors.add("selectedNonexclusiveTexturedText_disabled", 0, 122, 255, 120);
        } else if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("selectedNonexclusiveTexturedText", 37, 125, 252);
            colors.add("selectedNonexclusiveTexturedText_disabled", 37, 125, 252, 120);
        } else {
            colors.add("selectedNonexclusiveTexturedText", "controlAccent");
            colors.add("selectedNonexclusiveTexturedText_disabled", "controlAccent_disabled");
            colors.add("selectedNonexclusiveTexturedText_inactive", "segmentedText_disabled");
        }
        colors.add("texturedSegmentedText", 0, 150);
        colors.add("texturedSegmentedText_disabled", 0, 64);
        colors.add("texturedSegmentedText_inactive", 0, 64);
        colors.add("texturedSegmentedText_inactive_disabled", 0, 32);
        colors.add("selectedTexturedSegmentedText_disabled", 255, 144);
        colors.add("selectedTexturedSegmentedText_inactive", 0, 64);
        colors.add("selectedTexturedSegmentedText_inactive_disabled", 0, 32);
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("gradientText", 0, 216);
        } else {
            colors.add("gradientText", "controlText");
        }
        colors.add("gradientText_disabled", 0, 64);
        colors.add("selectedGradientText", 0, 216);
        colors.add("roundText", 0, 220);
        colors.add("selectedRoundText", 255);
        colors.add("roundText_disabled", 0, 64);
        colors.add("selectedRoundText_disabled", 0, 64);
        colors.add("toolbarItemText", 89);
        colors.add("toolbarItemText_disabled", 150);
        colors.add("toolbarItemText_inactive", 172);
        colors.add("toolbarItemText_inactive_disabled", 172);
        colors.add("toolbarItemText_focused", 250);
        colors.add("selectedToolbarItemText", 81);
        colors.add("selectedToolbarItemText_disabled", 172);
        colors.add("selectedToolbarItemText_inactive", 153);
        colors.add("selectedToolbarItemText_inactive_disabled", 198);
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("inlineButtonText", 255);
        } else {
            colors.add("inlineButtonText", 255, 224);
        }
        colors.add("inlineButtonText_inactive", "inlineButtonText");
        colors.add("inlineButtonText_disabled", 0, 64);
        colors.add("inlineButtonText_pressed", 255, 224);
        colors.add("categoryText", 30, 220);
        colors.add("expandControl", 30, 220);
        colors.add("sidebarBorder", 220);
        colors.add("sidebarIcon", 30, 220);
        colors.add("treeIcon", 140);
        colors.add("tableHeader", 37);
        colors.add("tableHeader_disabled", 37);
        colors.add("selectedTableHeader", 37);
        colors.add("tableHeaderBackground", 240);
        colors.add("tableHeaderBackground_disabled", 246);
        colors.add("tableHeaderSeparator", 192);
        colors.add("tableHeaderSeparator_disabled", 197);
        colors.add("browserColumnSeparator", 128);
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.addColorGradient("topTexturedWindowMarginBackground", 255, 194, 120);
            colors.addAlphaGradient("bottomTexturedWindowMarginBackground", 255, 104, 28);
            colors.addAlphaGradient("topWindowMarginBackground", 0, 4, 28);
            colors.addAlphaGradient("bottomWindowMarginBackground", 0, 8, 22);
        } else {
            colors.addColorGradient("topTexturedWindowMarginBackground", 255, 180, 80);
            colors.addAlphaGradient("bottomTexturedWindowMarginBackground", 255, 144, 8);
            colors.addAlphaGradient("topWindowMarginBackground", 0, 8, 36);
            colors.addAlphaGradient("bottomWindowMarginBackground", 0, 0, 24);
        }
        colors.add("topWindowMarginBackground_disabled", 246);
        colors.add("bottomWindowMarginBackground_disabled", 246);
        colors.add("topTexturedWindowBackground_disabled", 246);
        colors.add("bottomTexturedWindowBackground_disabled", 246);
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("topWindowDivider", 0, 36);
            colors.add("topWindowDivider_disabled", 0, 28);
            colors.add("bottomWindowDivider", 0, 36);
            colors.add("bottomWindowDivider_disabled", 0, 38);
        } else {
            colors.add("topWindowDivider", 0, 32);
            colors.add("topWindowDivider_disabled", 0, 28);
            colors.add("bottomWindowDivider", 0, 28);
            colors.add("bottomWindowDivider_disabled", 0, 28);
        }
        colors.add("topTexturedWindowDivider", 0, 32);
        colors.add("topTexturedWindowDivider_disabled", 0, 28);
        colors.add("bottomTexturedWindowDivider", 0, 56);
        colors.add("bottomTexturedWindowDivider_disabled", 0, 28);
        return colors;
    }

    @NotNull
    private static Colors createHighContrastLightColors() {
        Colors colors = new Colors();
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.add("windowBackground", 246);
            colors.add("windowBackground_disabled", 246);
            colors.add("texturedWindowBackground", 207);
        } else {
            colors.add("windowBackground", 236);
            colors.add("windowBackground_disabled", 236);
            colors.add("texturedWindowBackground", 212);
        }
        if (OSXSystemProperties.OSVersion < 1014) {
            colors.addAlphaGradient("topWindowMarginBackground", 0, 16, 40);
            colors.addAlphaGradient("bottomWindowMarginBackground", 0, 22, 36);
        } else {
            colors.addAlphaGradient("topWindowMarginBackground", 0, 8, 34);
            colors.addAlphaGradient("bottomWindowMarginBackground", 0, 0, 26);
            colors.addColorGradient("topTexturedWindowMarginBackground", 255, 200, 104);
            colors.addAlphaGradient("bottomTexturedWindowMarginBackground", 255, 144, 8);
        }
        int n = 0;
        int n2 = OSXSystemProperties.OSVersion < 1014 ? 64 : 74;
        colors.add("topWindowDivider", n, n2);
        colors.add("bottomWindowDivider", n, n2);
        colors.add("topTexturedWindowDivider", n, n2);
        colors.add("bottomTexturedWindowDivider", n, n2);
        colors.add("topWindowDivider_disabled", n, n2);
        colors.add("bottomWindowDivider_disabled", n, n2);
        colors.add("topTexturedWindowDivider_disabled", n, n2);
        colors.add("bottomTexturedWindowDivider_disabled", n, n2);
        colors.add("tagBlue", 68, 171, 229);
        colors.add("tagGray", 164, 164, 167);
        colors.add("tagGreen", 72, 188, 79);
        colors.add("tagOrange", 234, 147, 66);
        colors.add("tagPurple", 160, 106, 188);
        colors.add("tagRed", 255, 99, 92);
        colors.add("tagYellow", 248, 192, 73);
        colors.add("tagBlue_disabled", 163, 214, 242);
        colors.add("tagGray_disabled", 210, 210, 211);
        colors.add("tagGreen_disabled", 166, 223, 168);
        colors.add("tagOrange_disabled", 245, 202, 162);
        colors.add("tagPurple_disabled", 208, 182, 222);
        colors.add("tagRed_disabled", 255, 177, 175);
        colors.add("tagYellow_disabled", 252, 224, 167);
        colors.add("scrollPaneGrabber", 87);
        colors.add("scrollPaneBorder", 0, 128);
        return colors;
    }

    private static void installFixups(@NotNull Colors colors, @NotNull VAppearance vAppearance) {
        Color color;
        if (OSXSystemProperties.OSVersion < 1014) {
            boolean bl;
            color = colors.get("controlAccent");
            boolean bl2 = bl = color != null && color.getBlue() - color.getRed() < 30;
            if (bl) {
                colors.add("menuSelectedBackground", 162, 162, 168);
                colors.add("menuBackground", 240);
            } else {
                colors.add("menuSelectedBackground", 54, 148, 253);
                colors.add("menuBackground", 0, 0);
            }
            colors.add("menuForeground", 61);
        }
        if (vAppearance.isDark() && (color = colors.get("alternatingContentBackground_1_disabled")) != null && color.getRed() == 255 && color.getAlpha() == 128) {
            colors.add("alternatingContentBackground_1_disabled", 128, 13);
        }
    }

    @NotNull
    private static Colors createDarkColors() {
        Colors colors = new Colors();
        colors.add("capsLockIcon", 255, 96);
        colors.add("windowBackground_disabled", 45);
        colors.add("texturedWindowBackground", 42);
        colors.add("texturedWindowBackground_disabled", 45);
        colors.add("tagBlue", 63, 157, 255);
        colors.add("tagGray", 172, 172, 176);
        colors.add("tagGreen", 97, 223, 113);
        colors.add("tagOrange", 255, 178, 75);
        colors.add("tagPurple", 204, 124, 245);
        colors.add("tagRed", 255, 107, 99);
        colors.add("tagYellow", 255, 222, 78);
        colors.add("tagBlue_disabled", 47, 94, 142);
        colors.add("tagGray_disabled", 100, 101, 103);
        colors.add("tagGreen_disabled", 64, 126, 72);
        colors.add("tagOrange_disabled", 142, 104, 53);
        colors.add("tagPurple_disabled", 117, 77, 137);
        colors.add("tagRed_disabled", 142, 68, 64);
        colors.add("tagYellow_disabled", 142, 126, 55);
        colors.add("cellBackground", "clear");
        colors.add("selectedCellBackground_inactive", "selectedTextBackground_inactive");
        colors.add("cell", "controlText");
        colors.add("selectedCell", "controlText");
        colors.add("selectedCell_focused", "alternateSelectedControlText");
        colors.add("selectedCell_inactive", "controlText");
        colors.add("openOptionsArea", 42);
        colors.add("openOptionsArea_disabled", 45);
        colors.remove("saveOptionsArea");
        colors.add("selectedBrowserExpandArrow", 172);
        colors.add("selectedBrowserExpandArrow_focused", 255);
        colors.add("browserExpandArrow", 154);
        colors.add("scrollPaneGrabber", 255, 72);
        colors.add("scrollPaneBorder", 155, 128);
        colors.add("texturedText", "controlText");
        colors.add("texturedText_focused", 0, 192);
        colors.add("texturedText_disabled", "disabledControlText");
        colors.add("texturedText_inactive", "disabledControlText");
        colors.add("texturedText_inactive_disabled", 0, 96);
        colors.add("selectedTexturedText", 0, 192);
        colors.add("selectedTexturedText_disabled", 0, 64);
        colors.add("selectedTexturedText_inactive", 0, 128);
        colors.add("selectedTexturedText_inactive_disabled", 0, 64);
        colors.add("texturedToolbarText", 255);
        colors.add("texturedToolbarText_inactive", 255, 64);
        colors.add("texturedToolbarText_disabled", "disabledControlText");
        colors.add("texturedToolbarText_inactive_disabled", 255, 32);
        colors.add("selectedTexturedToolbarText", 0, 128);
        colors.add("selectedTexturedToolbarText_inactive", "selectedTexturedText_inactive");
        colors.add("selectedTexturedToolbarText_disabled", 0, 32);
        colors.add("selectedTexturedToolbarText_inactive_disabled", "selectedTexturedText_inactive_disabled");
        colors.add("texturedSegmentedText_inactive", 255, 64);
        colors.add("texturedSegmentedText_inactive_disabled", 255, 32);
        colors.add("selectedTexturedSegmentedText", 0, 176);
        colors.add("selectedTexturedSegmentedText_disabled", 0, 64);
        colors.add("selectedTexturedSegmentedText_inactive", 0, 96);
        colors.add("selectedTexturedSegmentedText_inactive_disabled", 0, 64);
        colors.add("nonexclusiveTexturedText", 0, 224);
        colors.add("selectedNonexclusiveTexturedText", "controlAccent_rollover");
        colors.add("selectedNonexclusiveTexturedText_disabled", "controlAccent_disabled");
        colors.add("selectedNonexclusiveTexturedText_inactive", 0, 96);
        colors.add("selectedNonexclusiveTexturedText_inactive_disabled", 0, 48);
        colors.add("texturedSegmentedToolbarText", 255);
        colors.add("texturedSegmentedToolbarText_inactive", 255, 80);
        colors.add("texturedSegmentedToolbarText_inactive_disabled", 255, 32);
        colors.add("selectedTexturedSegmentedToolbarText", 0, 160);
        colors.add("selectedTexturedSegmentedToolbarText_disabled", 0, 32);
        colors.add("selectedTexturedSegmentedToolbarText_inactive", 0, 128);
        colors.add("selectedTexturedSegmentedToolbarText_inactive_disabled", 0, 64);
        colors.add("nonexclusiveTexturedToolbarText_inactive", 255, 80);
        colors.add("selectedNonexclusiveTexturedToolbarText_inactive", 255, 80);
        colors.add("recessedText", "controlText");
        colors.add("recessedText_disabled", 255, 50);
        colors.add("recessedText_inactive", "recessedText_disabled");
        colors.add("recessedText_pressed", "controlText_pressed");
        colors.add("recessedText_rollover", "controlText_rollover");
        colors.add("selectedRecessedText", 0, 192);
        colors.add("selectedRecessedText_disabled", 0, 64);
        colors.add("selectedRecessedText_pressed", "controlText_pressed");
        colors.add("selectedRecessedText_rollover", "controlText_rollover");
        colors.add("selectedRecessedText_inactive", 0, 192);
        colors.add("pushButtonText", "controlText");
        colors.add("pushButtonText_disabled", "disabledControlText");
        colors.add("pushButtonText_pressed", "controlText_pressed");
        colors.add("pushButtonText_focused", "controlText");
        colors.add("selectedPushButtonText", "controlText");
        colors.add("pushPopText_pressed", "controlText_pressed");
        colors.add("segmentedText", "controlText");
        colors.add("segmentedText_disabled", "disabledControlText");
        colors.add("segmentedText_focused", "controlText");
        colors.add("selectedSegmentedText", "controlText");
        colors.add("selectedSegmentedText_disabled", 0, 64);
        colors.add("selectedSegmentedText_inactive", 0, 192);
        colors.add("nonexclusiveText_disabled", "disabledControlText");
        colors.add("nonexclusiveText_inactive", "controlText");
        colors.add("gradientText", "controlText");
        colors.add("gradientText_disabled", "disabledControlText");
        colors.add("selectedGradientText", 0, 180);
        colors.add("selectedGradientText_inactive", 0, 192);
        colors.add("selectedGradientText_disabled", 0, 64);
        colors.add("selectedGradientSegmentedText", "controlText");
        colors.add("selectedGradientSegmentedText_inactive", 0, 192);
        colors.add("selectedGradientSegmentedText_disabled", "disabledControlText");
        colors.add("selectedGradientSegmentedText_inactive_disabled", 0, 64);
        colors.add("selectedRoundedRectText", "roundedRectText");
        colors.add("selectedRoundedRectText_inactive", "roundedRectText_inactive");
        colors.add("selectedRoundedRectText_disabled", "roundedRectText_disabled");
        colors.add("selectedRoundedRectText_inactive_disabled", "roundedRectText_inactive_disabled");
        colors.addAll("bevelText", "roundedRectText", 1);
        colors.add("roundText", "controlText");
        colors.add("selectedRoundText", 0, 224);
        colors.add("roundText_disabled", "disabledControlText");
        colors.add("selectedRoundText_disabled", 0, 64);
        colors.add("toolbarItemText", "controlText");
        colors.add("toolbarItemText_disabled", "disabledControlText");
        colors.add("toolbarItemText_inactive", "disabledControlText");
        colors.add("toolbarItemText_inactive_disabled", "disabledControlText");
        colors.add("toolbarItemText_focused", "alternateSelectedControlText");
        colors.add("selectedToolbarItemText", "alternateSelectedControlText");
        colors.add("selectedToolbarItemText_disabled", "alternateSelectedControlText_disabled");
        colors.add("selectedToolbarItemText_inactive", "alternateSelectedControlText_disabled");
        colors.add("selectedToolbarItemText_inactive_disabled", "alternateSelectedControlText_disabled");
        colors.add("inlineButtonText", 50);
        colors.add("inlineButtonText_disabled", 50);
        colors.add("inlineButtonText_inactive", 50);
        colors.add("categoryText", 255, 160);
        colors.add("expandControl", 255, 160);
        colors.add("sidebarBorder", 0);
        colors.add("sidebarIcon", 255, 160);
        colors.add("treeIcon", 160);
        colors.add("tableHeader", 230);
        colors.add("tableHeader_disabled", 223);
        colors.add("selectedTableHeader", 230);
        colors.add("tableHeaderBackground", 46);
        colors.add("tableHeaderBackground_disabled", 48);
        colors.add("tableHeaderSeparator", 70);
        colors.add("tableHeaderSeparator_disabled", 83);
        colors.add("browserColumnSeparator", 60);
        colors.addMagicAlphaGradient("topTexturedWindowMarginBackground", 255, 24, 8);
        colors.add("topTexturedWindowMarginBackground_disabled", new AquaColors.TintedEraser(0, 32));
        colors.addColorGradient("bottomTexturedWindowMarginBackground", 60, 38, 128);
        colors.addAlphaGradient("topWindowMarginBackground", 255, 24, 8);
        colors.add("topWindowMarginBackground_disabled", new AquaColors.TintedEraser(32, 64));
        colors.addColorGradient("bottomWindowMarginBackground", 50, 40, 255);
        colors.add("topWindowDivider_disabled", 55);
        return colors;
    }

    @NotNull
    private static Colors createHighContrastDarkColors() {
        Colors colors = new Colors();
        colors.add("windowBackground", 50);
        colors.add("texturedWindowBackground", 53);
        colors.add("tagBlue", 103, 176, 255);
        colors.add("tagGray", 172, 172, 176);
        colors.add("tagGreen", 91, 215, 105);
        colors.add("tagOrange", 255, 170, 71);
        colors.add("tagPurple", 226, 165, 254);
        colors.add("tagRed", 255, 135, 129);
        colors.add("tagYellow", 254, 214, 75);
        colors.add("tagBlue_disabled", 67, 104, 144);
        colors.add("tagGray_disabled", 102, 102, 104);
        colors.add("tagGreen_disabled", 62, 123, 69);
        colors.add("tagOrange_disabled", 143, 101, 52);
        colors.add("tagPurple_disabled", 128, 98, 143);
        colors.add("tagRed_disabled", 143, 83, 80);
        colors.add("tagYellow_disabled", 143, 123, 55);
        colors.add("scrollPaneGrabber", 255, 196);
        colors.add("scrollPaneBorder", 153, 128);
        colors.addColorGradient("bottomTexturedWindowMarginBackground", 80, 48, 128);
        colors.addColorGradient("bottomWindowMarginBackground", 66, 53, 255);
        int n = 255;
        int n2 = 104;
        colors.add("topWindowDivider", n, n2);
        colors.add("bottomWindowDivider", n, n2);
        colors.add("topTexturedWindowDivider", n, n2);
        colors.add("bottomTexturedWindowDivider", n, n2);
        colors.add("topWindowDivider_disabled", n, n2);
        colors.add("bottomWindowDivider_disabled", n, n2);
        colors.add("topTexturedWindowDivider_disabled", n, n2);
        colors.add("bottomTexturedWindowDivider_disabled", n, n2);
        return colors;
    }

    @NotNull
    public String toString() {
        return super.toString() + "[" + this.appearance.getName() + "]";
    }

    private static class Colors {
        @NotNull
        private final Map<String, Color> colors = new HashMap<String, Color>();
        @NotNull
        private final Map<String, String> synonyms = new HashMap<String, String>();

        private Colors() {
        }

        @NotNull
        public Map<String, Color> getColors() {
            this.applySynonyms(this.synonyms);
            return Collections.unmodifiableMap(this.colors);
        }

        private void applySynonyms(@NotNull Map<String, String> map) {
            Color color;
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            for (String string : map.keySet()) {
                color = this.getIndirect(string, 5);
                if (color == null) continue;
                hashMap.put(string, color);
            }
            for (String string : hashMap.keySet()) {
                color = (Color)hashMap.get(string);
                this.colors.put(string, color);
            }
        }

        @Nullable
        private Color getIndirect(@NotNull String string, int n) {
            if (n < 0) {
                return null;
            }
            String string2 = this.synonyms.get(string);
            if (string2 != null) {
                return this.getIndirect(string2, n - 1);
            }
            return this.colors.get(string);
        }

        @NotNull
        private String getIndirectPath(@NotNull String string, int n) {
            if (n < 0) {
                return "...";
            }
            String string2 = this.synonyms.get(string);
            if (string2 != null) {
                return string + " " + this.getIndirectPath(string2, n - 1);
            }
            return string;
        }

        @Nullable
        public Color get(@NotNull String string) {
            return this.colors.get(string);
        }

        private void internalAdd(@NotNull String string, @NotNull Color color) {
            this.synonyms.remove(string);
            if (!(color instanceof ColorUIResource)) {
                color = new ColorUIResource(color);
            }
            this.colors.put(string, color);
        }

        public void add(@NotNull String string, int n) {
            ColorUIResource colorUIResource = new ColorUIResource(n, n, n);
            this.internalAdd(string, colorUIResource);
        }

        public void add(@NotNull String string, int n, int n2, int n3) {
            ColorUIResource colorUIResource = new ColorUIResource(n, n2, n3);
            this.internalAdd(string, colorUIResource);
        }

        public void add(@NotNull String string, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = new ColorUIResource(new Color(n, n2, n3, n4));
            this.internalAdd(string, colorUIResource);
        }

        public void add(@NotNull String string, int n, int n2) {
            ColorUIResource colorUIResource = new ColorUIResource(new Color(n, n, n, n2));
            this.internalAdd(string, colorUIResource);
        }

        public void addColorGradient(@NotNull String string, int n, int n2, int n3) {
            Color color = new Color(n, n, n, n3);
            Color color2 = new Color(n2, n2, n2, n3);
            AquaColors.GradientColor gradientColor = new AquaColors.GradientColor(color, color2);
            this.internalAdd(string, gradientColor);
        }

        public void addMagicColorGradient(@NotNull String string, int n, int n2, int n3) {
            Color color = new Color(n, n, n, n3);
            Color color2 = new Color(n2, n2, n2, n3);
            AquaColors.GradientColor gradientColor = new AquaColors.GradientColor(color, color2, true);
            this.internalAdd(string, gradientColor);
        }

        public void addAlphaGradient(@NotNull String string, int n, int n2, int n3) {
            Color color = new Color(n, n, n, n2);
            Color color2 = new Color(n, n, n, n3);
            AquaColors.GradientColor gradientColor = new AquaColors.GradientColor(color, color2);
            this.internalAdd(string, gradientColor);
        }

        public void addMagicAlphaGradient(@NotNull String string, int n, int n2, int n3) {
            Color color = new Color(n, n, n, n2);
            Color color2 = new Color(n, n, n, n3);
            AquaColors.GradientColor gradientColor = new AquaColors.GradientColor(color, color2, true);
            this.internalAdd(string, gradientColor);
        }

        public void add(@NotNull String string, @NotNull Color color) {
            this.internalAdd(string, color);
        }

        public void addAll(@NotNull Map<String, Color> map) {
            for (String string : map.keySet()) {
                Color color = map.get(string);
                this.internalAdd(string, color);
            }
        }

        private void internalAdd(@NotNull String string, @NotNull String string2) {
            this.colors.remove(string);
            this.synonyms.put(string, string2);
        }

        public void add(@NotNull String string, @NotNull String string2) {
            this.internalAdd(string, string2);
        }

        public void addAll(@NotNull String string, @NotNull String string2) {
            String string32;
            this.add(string, string2);
            for (String string32 : AquaColors.getAllColorSuffixes()) {
                this.addDerived(string, string2, string32);
            }
            String string4 = AquaColors.createSelectedColorName(string);
            string32 = AquaColors.createSelectedColorName(string2);
            this.add(string4, string32);
            for (String string5 : AquaColors.getAllColorSuffixes()) {
                this.addDerived(string4, string32, string5);
            }
        }

        private void addDerived(@NotNull String string, @NotNull String string2, @NotNull String string3) {
            this.add(string + string3, string2 + string3);
        }

        public void addAll(@NotNull String string, @NotNull String string2, int n) {
            String string32;
            this.add(string, string2);
            for (String string32 : AquaColors.getAllColorSuffixes()) {
                this.addDerived(string, string2, string32, n);
            }
            String string4 = AquaColors.createSelectedColorName(string);
            string32 = AquaColors.createSelectedColorName(string2);
            this.add(string4, string32);
            for (String string5 : AquaColors.getAllColorSuffixes()) {
                this.addDerived(string4, string32, string5, n);
            }
        }

        private void addDerived(@NotNull String string, @NotNull String string2, @NotNull String string3, int n) {
            String string4;
            if ((n & 1) != 0 && (string4 = AquaColors.withoutInactive(string3)) != null) {
                this.add(string + string3, string + string4);
                return;
            }
            this.add(string + string3, string2 + string3);
        }

        public void defineNoInactive(@NotNull String string) {
            for (String object : AquaColors.getAllColorSuffixes()) {
                String string2 = AquaColors.withoutInactive(object);
                if (string2 == null) continue;
                this.add(string + object, string + string2);
            }
            String string3 = AquaColors.createSelectedColorName(string);
            for (String string2 : AquaColors.getAllColorSuffixes()) {
                String string4 = AquaColors.withoutInactive(string2);
                if (string4 == null) continue;
                this.add((String)string3 + string2, (String)string3 + string4);
            }
        }

        public void remove(@NotNull String string) {
            this.colors.remove(string);
        }

        public void add(@NotNull Colors colors) {
            Map<String, Color> map = colors.colors;
            for (String object : map.keySet()) {
                Object object2 = map.get(object);
                this.internalAdd(object, (Color)object2);
            }
            Map<String, String> map2 = colors.synonyms;
            for (Object object2 : map2.keySet()) {
                String string = (String)map2.get(object2);
                this.internalAdd((String)object2, string);
            }
        }
    }
}

