/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.ImageUtils;

public abstract class PostProcessedRenderer
implements BasicRenderer {
    @NotNull
    private final BasicRenderer r;
    private static int[] temp;

    public PostProcessedRenderer(@NotNull BasicRenderer r) {
        this.r = r;
    }

    @Override
    public void render(@NotNull int[] data, int rw, int rh, float w, float h) {
        int requiredSize = rw * rh;
        if (requiredSize > 0) {
            if (temp == null || temp.length < requiredSize) {
                temp = new int[requiredSize];
            } else {
                Arrays.fill(temp, 0);
            }
            this.r.render(temp, rw, rh, w, h);
            this.process(temp, rw, rh);
            this.install(temp, data, rw, rh);
        }
    }

    protected void process(@NotNull int[] buffer, int rw, int rh) {
        this.processPixels(buffer, rw, rh);
    }

    protected void processPixels(@NotNull int[] buffer, int rw, int rh) {
        for (int row = 0; row < rh; ++row) {
            for (int col = 0; col < rw; ++col) {
                int index = row * rw + col;
                int originalPixel = buffer[index];
                int pixel = this.processRawPixel(row, col, originalPixel);
                if (pixel == originalPixel) continue;
                buffer[index] = pixel;
            }
        }
    }

    protected int processRawPixel(int row, int col, int pixel) {
        int alpha = ImageUtils.alpha(pixel);
        if (alpha == 0) {
            return pixel;
        }
        int red = ImageUtils.red(pixel);
        int green = ImageUtils.green(pixel);
        int blue = ImageUtils.blue(pixel);
        if (alpha > 0) {
            if (red > 0) {
                red = red * 255 / alpha;
            }
            if (green > 0) {
                green = green * 255 / alpha;
            }
            if (blue > 0) {
                blue = blue * 255 / alpha;
            }
        }
        return this.processPixel(row, col, red, green, blue, alpha);
    }

    protected abstract int processPixel(int var1, int var2, int var3, int var4, int var5, int var6);

    protected int createPixel(int red, int green, int blue, int alpha) {
        red = this.fix(red);
        green = this.fix(green);
        blue = this.fix(blue);
        if ((alpha = this.fix(alpha)) > 0) {
            if (red > 0) {
                red = red * alpha / 255;
            }
            if (green > 0) {
                green = green * alpha / 255;
            }
            if (blue > 0) {
                blue = blue * alpha / 255;
            }
        }
        int result = (alpha << 24) + (red << 16) + (green << 8) + blue;
        return result;
    }

    protected int createPixel(int color, int alpha) {
        return this.createPixel(color, color, color, alpha);
    }

    protected void install(@NotNull int[] buffer, @NotNull int[] output, int rw, int rh) {
        int count = rw * rh;
        System.arraycopy(buffer, 0, output, 0, count);
    }

    protected int fix(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }
}

