/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.ImageUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class JNRUtils {
    @NotNull
    static final DecimalFormat df2 = new DecimalFormat("0.00");
    public static final float NO_CHANGE = -123456.0f;

    public static int size(@NotNull AquaUIPainter.Size sz, int regular, int small, int mini) {
        switch (sz) {
            case SMALL: {
                return small;
            }
            case MINI: {
                return mini;
            }
        }
        return regular;
    }

    public static int size(@NotNull AquaUIPainter.Size sz, int large, int regular, int small, int mini) {
        switch (sz) {
            case SMALL: {
                return small;
            }
            case MINI: {
                return mini;
            }
            case LARGE: {
                return large;
            }
        }
        return regular;
    }

    public static float size2D(@NotNull AquaUIPainter.Size sz, float regular, float small, float mini) {
        switch (sz) {
            case SMALL: {
                return small;
            }
            case MINI: {
                return mini;
            }
        }
        return regular;
    }

    public static float size2D(@NotNull AquaUIPainter.Size sz, double regular, double small, double mini) {
        switch (sz) {
            case SMALL: {
                return (float)small;
            }
            case MINI: {
                return (float)mini;
            }
        }
        return (float)regular;
    }

    public static float size2D(@NotNull AquaUIPainter.Size sz, double large, double regular, double small, double mini) {
        switch (sz) {
            case SMALL: {
                return (float)small;
            }
            case MINI: {
                return (float)mini;
            }
            case LARGE: {
                return (float)large;
            }
        }
        return (float)regular;
    }

    @NotNull
    public static String format2(double v) {
        return df2.format(v);
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rd) {
        if (rd instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rd;
        }
        return null;
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rd, int scaleFactor) {
        if (rd instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rd;
        }
        if (rd instanceof MultiResolutionRendererDescription) {
            RendererDescription ard;
            MultiResolutionRendererDescription mrd = (MultiResolutionRendererDescription)rd;
            RendererDescription rendererDescription = ard = scaleFactor == 1 ? mrd.getDescription1() : mrd.getDescription2();
            if (ard instanceof BasicRendererDescription) {
                return (BasicRendererDescription)ard;
            }
        }
        return null;
    }

    @NotNull
    public static RendererDescription adjustRendererDescription(@NotNull RendererDescription rd, float deltaX, float deltaY, float deltaWA, float deltaHA) throws UnsupportedOperationException {
        if (deltaX == 0.0f && deltaY == 0.0f && deltaWA == 0.0f && deltaHA == 0.0f) {
            return rd;
        }
        BasicRendererDescription brd = JNRUtils.toBasicRendererDescription(rd);
        if (brd != null) {
            return brd.withAdjustments(deltaX, deltaY, deltaWA, deltaHA);
        }
        if (rd instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription mrd = (MultiResolutionRendererDescription)rd;
            BasicRendererDescription rd1 = JNRUtils.toBasicRendererDescription(mrd.getDescription1());
            BasicRendererDescription rd2 = JNRUtils.toBasicRendererDescription(mrd.getDescription2());
            if (rd1 != null && rd2 != null) {
                rd1 = rd1.withAdjustments(deltaX, deltaY, deltaWA, deltaHA);
                rd2 = rd2.withAdjustments(deltaX, deltaY, deltaWA, deltaHA);
                return new MultiResolutionRendererDescription(rd1, rd2);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be adjusted");
    }

    @NotNull
    public static RendererDescription changeRendererDescription(@NotNull RendererDescription rd, float x, float y, float wa, float ha) throws UnsupportedOperationException {
        if (x == -123456.0f && y == -123456.0f && wa == -123456.0f && ha == -123456.0f) {
            return rd;
        }
        BasicRendererDescription brd = JNRUtils.toBasicRendererDescription(rd);
        if (brd != null) {
            return JNRUtils.change(brd, x, y, wa, ha);
        }
        if (rd instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription mrd = (MultiResolutionRendererDescription)rd;
            BasicRendererDescription rd1 = JNRUtils.toBasicRendererDescription(mrd.getDescription1());
            BasicRendererDescription rd2 = JNRUtils.toBasicRendererDescription(mrd.getDescription2());
            if (rd1 != null && rd2 != null) {
                rd1 = JNRUtils.change(rd1, x, y, wa, ha);
                rd2 = JNRUtils.change(rd2, x, y, wa, ha);
                return new MultiResolutionRendererDescription(rd1, rd2);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be changed");
    }

    @NotNull
    private static BasicRendererDescription change(@NotNull BasicRendererDescription brd, float x, float y, float wa, float ha) {
        float nx = x == -123456.0f ? brd.getXOffset() : x;
        float ny = y == -123456.0f ? brd.getYOffset() : y;
        float nwa = wa == -123456.0f ? brd.getWidthAdjustment() : wa;
        float nha = ha == -123456.0f ? brd.getHeightAdjustment() : ha;
        return new BasicRendererDescription(nx, ny, nwa, nha);
    }

    public static int combine(int oldPixel, int newPixel) {
        int newAlpha = ImageUtils.alpha(newPixel);
        if (newAlpha == 255) {
            return newPixel;
        }
        if (newAlpha == 0) {
            return oldPixel;
        }
        int oldAlpha = ImageUtils.alpha(oldPixel);
        int oldRed = ImageUtils.red(oldPixel);
        int oldGreen = ImageUtils.green(oldPixel);
        int oldBlue = ImageUtils.blue(oldPixel);
        int newRed = ImageUtils.red(newPixel);
        int newGreen = ImageUtils.green(newPixel);
        int newBlue = ImageUtils.blue(newPixel);
        int f = 255 - newAlpha;
        int red = newRed + (oldRed * f >> 8);
        int green = newGreen + (oldGreen * f >> 8);
        int blue = newBlue + (oldBlue * f >> 8);
        int alpha = (255 * newAlpha + oldAlpha * f) / 255;
        return ImageUtils.createPixel(alpha, red, green, blue);
    }

    public static boolean describeRenderer(@NotNull BasicRenderer r, int w, int h, int scaleFactor) {
        int rw = (int)Math.ceil(scaleFactor * w);
        int rh = (int)Math.ceil(scaleFactor * h);
        int[] buffer = new int[rw * rh];
        r.render(buffer, rw, rh, w, h);
        return JNRUtils.describeRaster(buffer, rw, rh);
    }

    public static void showRenderer(@NotNull BasicRenderer r, int w, int h, int scaleFactor) {
        int rw = (int)Math.ceil(scaleFactor * w);
        int rh = (int)Math.ceil(scaleFactor * h);
        int[] buffer = new int[rw * rh];
        r.render(buffer, rw, rh, w, h);
        JNRUtils.showRaster(buffer, rw, rh);
    }

    public static boolean describeRaster(@NotNull int[] buffer, int rw, int rh) {
        int percent;
        int transparentPixelCount = 0;
        int opaquePixelCount = 0;
        int maximumAlpha = 0;
        int maximumAlphaRow = 0;
        int maximumAlphaCol = 0;
        int minimumAlpha = 1000;
        int minimumAlphaRow = 0;
        int minimumAlphaCol = 0;
        boolean hasGrayPixels = false;
        boolean hasColoredPixels = false;
        for (int row = 0; row < rh; ++row) {
            for (int col = 0; col < rw; ++col) {
                int index = row * rw + col;
                int pixel = buffer[index];
                int alpha = ImageUtils.alpha(pixel);
                if (alpha == 0) continue;
                if (alpha > maximumAlpha) {
                    maximumAlpha = alpha;
                    maximumAlphaRow = row;
                    maximumAlphaCol = col;
                }
                if (alpha < minimumAlpha) {
                    minimumAlpha = alpha;
                    minimumAlphaRow = row;
                    minimumAlphaCol = col;
                }
                if (alpha == 255) {
                    ++opaquePixelCount;
                } else {
                    ++transparentPixelCount;
                }
                if (hasGrayPixels && hasColoredPixels) continue;
                int red = ImageUtils.red(pixel);
                int green = ImageUtils.green(pixel);
                int blue = ImageUtils.blue(pixel);
                if (red <= 0 && green <= 0 && blue <= 0) continue;
                if (red == green && green == blue) {
                    hasGrayPixels = true;
                    continue;
                }
                hasColoredPixels = true;
            }
        }
        int pixelCount = rw * rh;
        String s = "";
        if (transparentPixelCount > 0) {
            percent = Math.round((float)transparentPixelCount * 100.0f / (float)pixelCount);
            s = s + " " + transparentPixelCount + " transparent pixels (" + percent + "%)";
        }
        if (opaquePixelCount > 0) {
            percent = Math.round((float)opaquePixelCount * 100.0f / (float)pixelCount);
            s = s + " " + transparentPixelCount + " opaque pixels (" + percent + "%)";
        }
        if (maximumAlpha > 0) {
            s = s + " maximum alpha: " + maximumAlpha + " at " + maximumAlphaCol + ", " + maximumAlphaRow;
        }
        if (minimumAlpha < 256) {
            s = s + " minimum alpha: " + minimumAlpha + " at " + minimumAlphaCol + ", " + minimumAlphaRow;
        }
        if (s.isEmpty()) {
            System.out.println("Empty raster");
            return false;
        }
        System.out.println(s);
        return true;
    }

    public static void showRaster(@NotNull int[] buffer, int rw, int rh) {
        for (int row = 0; row < rh; ++row) {
            for (int col = 0; col < rw; ++col) {
                int index = row * rw + col;
                int pixel = buffer[index];
                int alpha = ImageUtils.alpha(pixel);
                if (alpha == 0) {
                    System.out.print("                 ");
                } else {
                    int red = ImageUtils.red(pixel);
                    int green = ImageUtils.green(pixel);
                    int blue = ImageUtils.blue(pixel);
                    if (alpha > 0) {
                        if (red > 0) {
                            red = red * 255 / alpha;
                        }
                        if (green > 0) {
                            green = green * 255 / alpha;
                        }
                        if (blue > 0) {
                            blue = blue * 255 / alpha;
                        }
                    }
                    System.out.print(String.format("%3d %3d %3d %3d", red, green, blue, alpha));
                }
                System.out.print("  ");
            }
            System.out.println();
        }
    }

    static {
        df2.setDecimalSeparatorAlwaysShown(true);
    }
}

