/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JNRPlatformUtils {
    @Nullable
    private static String platformVersionString;
    private static int platformVersion;

    public static synchronized int getPlatformVersion() {
        if (platformVersionString == null) {
            boolean isOSX;
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            boolean bl = isOSX = osName.equals("Mac OS X") || osName.equals("macOS");
            if (isOSX) {
                platformVersionString = osVersion;
                platformVersion = JNRPlatformUtils.obtainSystemVersion(osVersion);
                return platformVersion;
            }
        }
        return platformVersion;
    }

    private static int obtainSystemVersion(@NotNull String s) {
        int v;
        int version = JNRPlatformUtils.parseSystemVersion(s);
        if (version / 100 == 1016 && (v = JNRPlatformUtils.readSystemVersion()) > 0) {
            return v;
        }
        return version;
    }

    private static int readSystemVersion() {
        String[] cmd = new String[]{"/usr/bin/sw_vers", "-productVersion"};
        String[] env = new String[]{"SYSTEM_VERSION_COMPAT=0"};
        String s = JNRPlatformUtils.command("sw_vers", cmd, env);
        if (s != null) {
            return JNRPlatformUtils.parseSystemVersion(s);
        }
        return 0;
    }

    @Nullable
    private static String command(@NotNull String name, String @NotNull [] command, String @Nullable [] env) {
        try {
            int n;
            Process p = Runtime.getRuntime().exec(command, env);
            InputStreamReader stdout = new InputStreamReader(p.getInputStream());
            StringBuffer sb = new StringBuffer();
            while ((n = stdout.read()) != -1 && n != 10) {
                sb.append((char)n);
            }
            return sb.toString();
        }
        catch (Throwable th) {
            System.err.println("Unable to run " + name + ": " + th);
            return null;
        }
    }

    private static int parseSystemVersion(@NotNull String s) {
        int version = 0;
        int count = 0;
        StringTokenizer st = new StringTokenizer(s, ".");
        while (st.hasMoreTokens() && ++count <= 3) {
            String t = st.nextToken();
            try {
                int n = Integer.parseInt(t);
                if (n >= 0 && n < 100) {
                    version = version * 100 + n;
                    continue;
                }
                return 0;
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return count == 2 ? version * 100 : version;
    }

    @Nullable
    public static Graphics2D toGraphics2D(@NotNull Graphics g) {
        try {
            return (Graphics2D)g;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    static {
        platformVersion = 0;
    }
}

