/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.RendererDescription;

public final class BasicRendererDescription
implements RendererDescription {
    private final float xOffset;
    private final float yOffset;
    private final float widthAdjustment;
    private final float heightAdjustment;

    public BasicRendererDescription(float xOffset, float yOffset, float widthAdjustment, float heightAdjustment) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.widthAdjustment = widthAdjustment;
        this.heightAdjustment = heightAdjustment;
    }

    @Override
    public boolean isTrivial() {
        return this.xOffset == 0.0f && this.yOffset == 0.0f && this.widthAdjustment == 0.0f && this.heightAdjustment == 0.0f;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getWidthAdjustment() {
        return this.widthAdjustment;
    }

    public float getHeightAdjustment() {
        return this.heightAdjustment;
    }

    @Override
    @NotNull
    public RasterDescription getRasterBounds(@NotNull Rectangle2D target, int scaleFactor) {
        float x = this.round(target.getX() + (double)this.xOffset, scaleFactor);
        float y = this.round(target.getY() + (double)this.yOffset, scaleFactor);
        float rasterWidth = this.round(target.getWidth() + (double)this.widthAdjustment, scaleFactor);
        float rasterHeight = this.round(target.getHeight() + (double)this.heightAdjustment, scaleFactor);
        return new RasterDescription(x, y, rasterWidth, rasterHeight);
    }

    private float round(double v, int scaleFactor) {
        double scaledValue = v * (double)scaleFactor;
        long scaledRounded = Math.round(scaledValue);
        return (float)scaledRounded / (float)scaleFactor;
    }

    @NotNull
    public BasicRendererDescription withAdjustments(float x, float y, float w, float h) {
        return new BasicRendererDescription(this.xOffset + x, this.yOffset + y, this.widthAdjustment + w, this.heightAdjustment + h);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicRendererDescription that = (BasicRendererDescription)o;
        return Objects.equals(Float.valueOf(this.xOffset), Float.valueOf(that.xOffset)) && Objects.equals(Float.valueOf(this.yOffset), Float.valueOf(that.yOffset)) && Objects.equals(Float.valueOf(this.widthAdjustment), Float.valueOf(that.widthAdjustment)) && Objects.equals(Float.valueOf(this.heightAdjustment), Float.valueOf(that.heightAdjustment));
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.xOffset), Float.valueOf(this.yOffset), Float.valueOf(this.widthAdjustment), Float.valueOf(this.heightAdjustment));
    }
}

