/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.coreui.CoreUIRendererDescriptions;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.RendererDescription;

public class JRSRendererDescriptions
extends CoreUIRendererDescriptions {
    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration g) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        boolean v2 = platformVersion >= 101100;
        AquaUIPainter.SegmentedButtonWidget w = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.Position position = g.getPosition();
        if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS) {
            g = g.withWidget(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED);
        } else if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
            g = g.withWidget(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED);
        }
        RendererDescription rd = super.getSegmentedButtonRendererDescription(g);
        try {
            switch (w) {
                case BUTTON_SEGMENTED_SEPARATED: {
                    float x;
                    float width;
                    if (sz == AquaUIPainter.Size.REGULAR || sz == AquaUIPainter.Size.SMALL) {
                        switch (position) {
                            case FIRST: {
                                width = 5.0f;
                                x = -2.0f;
                                break;
                            }
                            case MIDDLE: {
                                width = 5.49f;
                                x = -2.49f;
                                break;
                            }
                            case LAST: {
                                width = 4.49f;
                                x = -2.49f;
                                break;
                            }
                            default: {
                                width = 4.0f;
                                x = -2.0f;
                                break;
                            }
                        }
                    } else {
                        switch (position) {
                            case FIRST: {
                                width = 3.0f;
                                x = -1.0f;
                                break;
                            }
                            case MIDDLE: {
                                width = 3.49f;
                                x = -1.49f;
                                break;
                            }
                            case LAST: {
                                width = 2.49f;
                                x = -1.49f;
                                break;
                            }
                            default: {
                                width = 2.0f;
                                x = -1.0f;
                            }
                        }
                    }
                    return JNRUtils.changeRendererDescription(rd, x, -123456.0f, width, -123456.0f);
                }
                case BUTTON_SEGMENTED_INSET: {
                    float y = JNRUtils.size2D(sz, -2.0f, -2.51f, -3.0f);
                    return JNRUtils.changeRendererDescription(rd, -123456.0f, y, -123456.0f, -123456.0f);
                }
                case BUTTON_SEGMENTED_SCURVE: 
                case BUTTON_SEGMENTED_TEXTURED: {
                    float y = v2 ? JNRUtils.size2D(sz, -1.49f, -2.0f, -2.0f) : JNRUtils.size2D(sz, -1.0f, -2.0f, -2.0f);
                    return this.fix(rd, g, y);
                }
                case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
                case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                    float y = v2 ? JNRUtils.size2D(sz, -2.49f, -3.0f, -3.0f) : JNRUtils.size2D(sz, -1.0f, -2.0f, -2.0f);
                    return this.fix(rd, g, y);
                }
                case BUTTON_SEGMENTED_TOOLBAR: {
                    float y = v2 ? JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f) : JNRUtils.size2D(sz, -1.0f, -2.0f, -2.0f);
                    return this.fix(rd, g, y);
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + g);
        }
        return rd;
    }

    @NotNull
    private RendererDescription fix(@NotNull RendererDescription rd, @NotNull SegmentedButtonConfiguration g, float y) {
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.Position position = g.getPosition();
        if (sz == AquaUIPainter.Size.MINI) {
            rd = new BasicRendererDescription(0.0f, 0.0f, position == AquaUIPainter.Position.MIDDLE ? 1.0f : 0.0f, 4.0f);
        }
        return JNRUtils.changeRendererDescription(rd, -123456.0f, y, -123456.0f, -123456.0f);
    }
}

