/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

public abstract class TitleBarRendererBase
extends Renderer {
    @NotNull
    protected final TitleBarConfiguration g;
    @NotNull
    protected final RendererDescription rd;
    @Nullable
    protected final Insetter closeButtonInsets;
    @Nullable
    protected final Insetter minimizeButtonInsets;
    @Nullable
    protected final Insetter resizeButtonInsets;

    protected TitleBarRendererBase(@NotNull TitleBarConfiguration g, @NotNull RendererDescription rd, @Nullable Insetter closeButtonInsets, @Nullable Insetter minimizeButtonInsets, @Nullable Insetter resizeButtonInsets) {
        this.g = g;
        this.rd = rd;
        this.closeButtonInsets = closeButtonInsets;
        this.minimizeButtonInsets = minimizeButtonInsets;
        this.resizeButtonInsets = resizeButtonInsets;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        Renderer r;
        Renderer br;
        Rectangle2D bounds;
        float w = compositor.getWidth();
        float h = compositor.getHeight();
        BasicRenderer br2 = this.getBasicTitleBarRenderer(w, h);
        Renderer r2 = Renderer.create(br2, this.rd);
        r2.composeTo(compositor);
        if (this.closeButtonInsets != null) {
            bounds = this.closeButtonInsets.apply2D(w, h);
            br = this.getButtonRenderer(AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
            r = Renderer.createOffsetRenderer(br, bounds);
            r.composeTo(compositor);
        }
        if (this.minimizeButtonInsets != null) {
            bounds = this.minimizeButtonInsets.apply2D(w, h);
            br = this.getButtonRenderer(AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
            r = Renderer.createOffsetRenderer(br, bounds);
            r.composeTo(compositor);
        }
        if (this.resizeButtonInsets != null) {
            bounds = this.resizeButtonInsets.apply2D(w, h);
            br = this.getButtonRenderer(AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
            r = Renderer.createOffsetRenderer(br, bounds);
            r.composeTo(compositor);
        }
    }

    @NotNull
    protected abstract BasicRenderer getBasicTitleBarRenderer(float var1, float var2);

    @NotNull
    protected abstract Renderer getButtonRenderer(@NotNull AquaUIPainter.TitleBarButtonWidget var1);
}

