/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SliderCircularTickPainter {
    @NotNull
    protected final Color color;
    protected final double w;
    protected final double h;
    protected final double x;
    protected final double y;
    protected final double radius;
    protected final double zeroAngle;
    protected final int tickCount;
    protected final double p0;
    protected final double p1;

    public SliderCircularTickPainter(@NotNull Color color, double w, double h, double x, double y, double radius, double zeroAngle, int tickCount, double p0, double p1) {
        this.color = color;
        this.w = w;
        this.h = h;
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.zeroAngle = zeroAngle;
        this.tickCount = tickCount;
        this.p0 = p0;
        this.p1 = p1;
    }

    public void paint(@NotNull Graphics2D g) {
        g.setColor(this.color);
        if (this.tickCount == 1) {
            this.drawTick(g, this.p0);
        } else {
            double spacing = (this.p1 - this.p0) / (double)this.tickCount;
            double p = this.p0;
            for (int i = 0; i < this.tickCount; ++i) {
                this.drawTick(g, p);
                p += spacing;
            }
        }
    }

    protected void drawTick(@NotNull Graphics2D g, double thumbPosition) {
        double angle = this.zeroAngle - thumbPosition * 2.0 * Math.PI;
        double x0 = this.x + Math.cos(angle) * this.radius - this.w / 2.0;
        double y0 = this.y - Math.sin(angle) * this.radius - this.h / 2.0;
        g.setColor(this.color);
        Rectangle2D.Double s = new Rectangle2D.Double(x0, y0, this.w, this.h);
        g.fill(s);
    }
}

