/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class PopupRenderer
extends Renderer {
    @NotNull
    protected final PopupButtonConfiguration g;
    @Nullable
    protected final Renderer buttonRenderer;
    @NotNull
    protected final Renderer arrowsRenderer;
    @NotNull
    protected final Insetter arrowsInsets;

    public PopupRenderer(@NotNull PopupButtonConfiguration g, @Nullable Renderer buttonRenderer, @NotNull Renderer arrowsRenderer, @NotNull Insetter arrowsInsets) {
        this.g = g;
        this.buttonRenderer = buttonRenderer;
        this.arrowsRenderer = arrowsRenderer;
        this.arrowsInsets = arrowsInsets;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        float w = compositor.getWidth();
        float h = compositor.getHeight();
        if (this.buttonRenderer != null) {
            this.buttonRenderer.composeTo(compositor);
        }
        Rectangle2D bounds = this.arrowsInsets.apply2D(w, h);
        Renderer r = Renderer.createOffsetRenderer(this.arrowsRenderer, bounds);
        r.composeTo(compositor);
    }
}

