/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.ImageUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class LinearSliderRenderer
extends Renderer {
    @NotNull
    private static final ReusableCompositor.PixelOperator blender = new Blender();
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer trackRenderer;
    @NotNull
    protected final Insetter trackInsets;
    @Nullable
    protected final Renderer tickMarkRenderer;
    @Nullable
    protected final Insetter tickMarkInsets;
    @NotNull
    protected final Renderer thumbRenderer;
    @NotNull
    protected final Insetter thumbInsets;
    protected final boolean isThumbTranslucent;
    @Nullable
    protected final ReusableCompositor.PixelOperator tickOperator;

    public LinearSliderRenderer(@NotNull SliderConfiguration g, @NotNull Renderer trackRenderer, @NotNull Insetter trackInsets, @Nullable Renderer tickMarkRenderer, @Nullable Insetter tickMarkInsets, @NotNull Renderer thumbRenderer, @NotNull Insetter thumbInsets, boolean isThumbTranslucent, @Nullable ReusableCompositor.PixelOperator tickOperator) {
        this.g = g;
        this.trackRenderer = trackRenderer;
        this.trackInsets = trackInsets;
        this.tickMarkRenderer = tickMarkRenderer;
        this.tickMarkInsets = tickMarkInsets;
        this.thumbRenderer = thumbRenderer;
        this.thumbInsets = thumbInsets;
        this.isThumbTranslucent = isThumbTranslucent;
        this.tickOperator = tickOperator;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        float w = compositor.getWidth();
        float h = compositor.getHeight();
        Rectangle2D trackBounds = this.trackInsets.apply2D(w, h);
        Renderer r = Renderer.createOffsetRenderer(this.trackRenderer, trackBounds);
        r.composeTo(compositor);
        if (this.tickMarkRenderer != null && this.tickMarkInsets != null) {
            Rectangle2D tickMarkBounds = this.tickMarkInsets.apply2D(w, h);
            Renderer tr = Renderer.createOffsetRenderer(this.tickMarkRenderer, tickMarkBounds);
            if (this.tickOperator != null) {
                ReusableCompositor mask = compositor.createSimilar();
                tr.composeTo(mask);
                compositor.blendFrom(mask, this.tickOperator);
            } else {
                tr.composeTo(compositor);
            }
        }
        Rectangle2D thumbBounds = this.thumbInsets.apply2D(w, h);
        Renderer r2 = Renderer.createOffsetRenderer(this.thumbRenderer, thumbBounds);
        if (this.isThumbTranslucent) {
            ReusableCompositor mask = compositor.createSimilar();
            r2.composeTo(mask);
            compositor.blendFrom(mask, blender);
        } else {
            r2.composeTo(compositor);
        }
    }

    private static class Blender
    implements ReusableCompositor.PixelOperator {
        private Blender() {
        }

        @Override
        public int combine(int destinationPixel, int sourcePixel) {
            int alpha = ImageUtils.alpha(sourcePixel);
            if (alpha == 0) {
                return destinationPixel;
            }
            if (alpha > 20) {
                return sourcePixel;
            }
            return JNRUtils.combine(destinationPixel, sourcePixel);
        }
    }
}

