/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class ComboBoxButtonCellPainterExtension
implements PainterExtension {
    @NotNull
    protected final ComboBoxConfiguration gg;
    @NotNull
    protected final Colors colors;

    public ComboBoxButtonCellPainterExtension(@NotNull ComboBoxConfiguration g, @Nullable VAppearance appearance) {
        this.gg = g;
        this.colors = Colors.getColors(appearance);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        AquaUIPainter.Size sz = this.gg.getSize();
        double h = sz == AquaUIPainter.Size.REGULAR ? 4.0 : 4.0;
        double w = sz == AquaUIPainter.Size.REGULAR ? 6.0 : 5.0;
        double right = 7.0;
        double sep = sz == AquaUIPainter.Size.REGULAR ? 4.0 : 3.0;
        double hh = 2.0 * h + sep;
        double x1 = (double)width - w - right;
        double y1 = ((double)height - hh) / 2.0;
        double x2 = x1 + w / 2.0;
        double y2 = y1 + h;
        double x3 = x1 + w;
        double y4 = y2 + h + sep;
        double y5 = y4 - h;
        Path2D.Double p1 = new Path2D.Double();
        ((Path2D)p1).moveTo(x1, y2);
        ((Path2D)p1).lineTo(x2, y1);
        ((Path2D)p1).lineTo(x3, y2);
        Path2D.Double p2 = new Path2D.Double();
        ((Path2D)p2).moveTo(x1, y5);
        ((Path2D)p2).lineTo(x2, y4);
        ((Path2D)p2).lineTo(x3, y5);
        g.setColor(this.colors.get("comboBoxArrow"));
        g.setStroke(new BasicStroke(1.5f));
        g.fill(p1);
        g.fill(p2);
    }
}

