/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.AquaNativePainter;
import org.violetlib.jnr.aqua.impl.RenderInsets;
import org.violetlib.jnr.aqua.impl.SegmentButtonRenderingConfiguration1;
import org.violetlib.jnr.aqua.impl.SegmentButtonRenderingConfiguration4;
import org.violetlib.jnr.aqua.impl.SegmentedControl1LayoutInfo;
import org.violetlib.jnr.aqua.impl.SegmentedControl4LayoutInfo;
import org.violetlib.jnr.aqua.impl.SegmentedControlConfiguration;
import org.violetlib.jnr.aqua.impl.SegmentedControlConfiguration1;
import org.violetlib.jnr.aqua.impl.SegmentedControlConfiguration4;
import org.violetlib.jnr.aqua.impl.SegmentedControlDescriptions;
import org.violetlib.jnr.aqua.impl.SegmentedControlLayoutInfo;
import org.violetlib.jnr.impl.AnnotatedSegmentedControlImage;
import org.violetlib.jnr.impl.BasicImageSupport;
import org.violetlib.jnr.impl.PixelRasterImpl;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDebugInfo;
import org.violetlib.jnr.impl.ReusableCompositor;

public class AquaNativeSegmentedControlPainter {
    protected final SegmentedControlDescriptions scds = new SegmentedControlDescriptions();
    private static final int SELECT_SEGMENT_1 = 8;
    private static final int SELECT_SEGMENT_2 = 4;
    private static final int SELECT_SEGMENT_3 = 2;
    private static final int SELECT_SEGMENT_4 = 1;
    private static final int CONTEXT_WINDOW = 1;
    private static final int CONTEXT_TOOLBAR = 2;

    @NotNull
    public Renderer createSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g) {
        return new SegmentedButtonRenderer(g);
    }

    @NotNull
    private static Rectangle2D extractBounds(@NotNull float[] fs, int start) {
        return new Rectangle2D.Float(fs[start], fs[start + 1], fs[start + 2], fs[start + 3]);
    }

    @Nullable
    public RendererDebugInfo getSegmentedButtonRendererDebugInfo(@NotNull SegmentedButtonConfiguration g, int scale, int buttonWidth, int buttonHeight) {
        RenderInsets s = this.scds.getInsets(g, scale);
        if (g.getPosition() == AquaUIPainter.Position.ONLY) {
            SegmentedControl1LayoutInfo layout = this.scds.getSegment1LayoutInfo(g, scale);
            SegmentButtonRenderingConfiguration1 bc = this.getRenderConfiguration(g.isSelected(), s, layout, scale, buttonWidth, buttonHeight);
            SegmentedControlConfiguration1 cc = this.createControlConfiguration(g, bc);
            int rasterWidth = Math.round(scale * bc.rasterWidth);
            int rasterHeight = Math.round(scale * bc.rasterHeight);
            int[] raster = new int[rasterWidth * rasterHeight];
            return this.paintSegmentedControl1(raster, rasterWidth, rasterHeight, scale, cc, true);
        }
        SegmentedControl4LayoutInfo layout = this.scds.getSegment4LayoutInfo(g, scale);
        SegmentButtonRenderingConfiguration4 bc = this.getRenderConfiguration(g, s, layout, scale, buttonWidth, buttonHeight);
        SegmentedControlConfiguration4 cc = this.createControlConfiguration(g, bc);
        int rasterWidth = Math.round(scale * bc.rasterWidth);
        int rasterHeight = Math.round(scale * bc.rasterHeight);
        int[] raster = new int[rasterWidth * rasterHeight];
        return this.paintSegmentedControl4(raster, rasterWidth, rasterHeight, scale, cc, true);
    }

    @Nullable
    public float[] getSegmentedButtonLayoutParameters(@NotNull SegmentedButtonLayoutConfiguration g) {
        float[] debugOutput;
        int size = AquaNativePainter.toSize(g.getSize());
        int segmentStyle = AquaNativePainter.toSegmentedStyle(g.getWidget());
        int result = AquaNativeSegmentedControlPainter.nativeDetermineSegmentedButtonLayoutParameters(segmentStyle, size, debugOutput = new float[8]);
        return (float[])(result == 0 ? debugOutput : null);
    }

    @NotNull
    public SegmentedControlLayoutInfo getSegmentLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        return this.scds.getSegmentLayoutInfo(g, scale);
    }

    @NotNull
    public RenderInsets getSegmentedControlInsets(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        return this.scds.getInsets(g, scale);
    }

    @NotNull
    public SegmentButtonRenderingConfiguration1 getRenderConfiguration(boolean isSelected, @NotNull RenderInsets s, @NotNull SegmentedControl1LayoutInfo layout, int scale, int buttonWidth, int buttonHeight) {
        float segmentWidth = (float)buttonWidth - layout.widthAdjustment;
        int rasterWidth = (int)Math.ceil((float)buttonWidth + s.widthAdjust);
        int rasterHeight = (int)Math.ceil((float)buttonHeight + s.heightAdjust);
        return new SegmentButtonRenderingConfiguration1(scale, isSelected, segmentWidth, rasterWidth, rasterHeight);
    }

    @NotNull
    public SegmentButtonRenderingConfiguration4 getRenderConfiguration(@NotNull SegmentedButtonConfiguration g, @NotNull RenderInsets s, @NotNull SegmentedControl4LayoutInfo layout, int scale, int segmentWidth, int controlHeight) {
        boolean isSeparated = g.getWidget().isSeparated();
        boolean isSelected = g.isSelected();
        AquaUIPainter.Position pos = g.getPosition();
        SegmentedButtonConfiguration.DividerState leftDivider = g.getLeftDividerState();
        SegmentedButtonConfiguration.DividerState rightDivider = g.getRightDividerState();
        return this.getRenderConfiguration(isSeparated, isSelected, pos, leftDivider, rightDivider, s, layout, scale, segmentWidth, controlHeight);
    }

    @NotNull
    public SegmentButtonRenderingConfiguration4 getRenderConfiguration(boolean isSeparated, boolean isSelected, @NotNull AquaUIPainter.Position pos, @NotNull SegmentedButtonConfiguration.DividerState leftDivider, @NotNull SegmentedButtonConfiguration.DividerState rightDivider, @NotNull RenderInsets s, @NotNull SegmentedControl4LayoutInfo layout, int scale, int segmentWidth, int controlHeight) {
        boolean isSeparatedCentered2X;
        float renderedSegmentNominalWidth;
        int segmentIndex;
        SegmentedControl4LayoutInfo.DividerPosition dividerPosition = layout.dividerPosition;
        float dividerVisualWidth = layout.dividerVisualWidth;
        float firstExtra = layout.firstSegmentWidthAdjustment;
        float middleExtra = layout.middleSegmentWidthAdjustment;
        float lastExtra = layout.lastSegmentWidthAdjustment;
        float otherSegmentNominalWidth = 20.0f;
        int selectedSegmentIndex = -1;
        float xOffset = 0.0f;
        float widthAdjustment = 0.0f;
        if (pos == AquaUIPainter.Position.FIRST) {
            segmentIndex = 0;
            renderedSegmentNominalWidth = (float)segmentWidth - firstExtra;
        } else if (pos == AquaUIPainter.Position.MIDDLE) {
            segmentIndex = 1;
            renderedSegmentNominalWidth = (float)segmentWidth - middleExtra;
        } else if (pos == AquaUIPainter.Position.LAST) {
            segmentIndex = 3;
            renderedSegmentNominalWidth = (float)segmentWidth - lastExtra;
        } else {
            throw new AssertionError((Object)"Unexpected segment position");
        }
        if (isSelected) {
            selectedSegmentIndex = segmentIndex;
        } else if (leftDivider == SegmentedButtonConfiguration.DividerState.SELECTED) {
            if (segmentIndex > 0) {
                selectedSegmentIndex = segmentIndex - 1;
            }
        } else if (rightDivider == SegmentedButtonConfiguration.DividerState.SELECTED) {
            if (segmentIndex == 1) {
                segmentIndex = 2;
                selectedSegmentIndex = 3;
            } else if (segmentIndex == 0) {
                selectedSegmentIndex = 1;
            }
        }
        if (segmentIndex > 0) {
            xOffset = (float)segmentIndex * (otherSegmentNominalWidth + middleExtra) + (firstExtra - middleExtra);
            widthAdjustment += firstExtra;
        }
        if (segmentIndex < 3) {
            widthAdjustment += lastExtra;
        }
        widthAdjustment = segmentIndex == 0 || segmentIndex == 3 ? (widthAdjustment += 2.0f * middleExtra) : (widthAdjustment += middleExtra);
        boolean bl = isSeparatedCentered2X = isSeparated && scale != 1 && dividerPosition == SegmentedControl4LayoutInfo.DividerPosition.CENTER;
        if (!isSeparatedCentered2X && dividerVisualWidth > 0.0f) {
            boolean drawTrailingDivider;
            if (segmentIndex > 0 && dividerPosition != SegmentedControl4LayoutInfo.DividerPosition.LEFT) {
                xOffset += dividerVisualWidth;
                renderedSegmentNominalWidth += dividerVisualWidth;
                widthAdjustment += dividerVisualWidth;
            }
            if (segmentIndex < 3 && dividerPosition != SegmentedControl4LayoutInfo.DividerPosition.RIGHT) {
                renderedSegmentNominalWidth += dividerVisualWidth;
                widthAdjustment += dividerVisualWidth;
            }
            boolean drawLeadingDivider = segmentIndex > 0 && leftDivider != SegmentedButtonConfiguration.DividerState.NONE;
            boolean bl2 = drawTrailingDivider = segmentIndex < 3 && rightDivider != SegmentedButtonConfiguration.DividerState.NONE;
            if (drawLeadingDivider) {
                xOffset -= dividerVisualWidth;
                int adjustment = (int)Math.ceil(dividerVisualWidth);
                if (dividerPosition == SegmentedControl4LayoutInfo.DividerPosition.CENTER) {
                    xOffset -= dividerVisualWidth;
                    adjustment = (int)((float)adjustment + dividerVisualWidth);
                }
                renderedSegmentNominalWidth -= (float)adjustment;
                widthAdjustment -= (float)adjustment;
            }
            if (drawTrailingDivider) {
                renderedSegmentNominalWidth -= dividerVisualWidth;
                widthAdjustment -= dividerVisualWidth;
                if (dividerPosition == SegmentedControl4LayoutInfo.DividerPosition.CENTER) {
                    renderedSegmentNominalWidth -= dividerVisualWidth;
                    widthAdjustment -= dividerVisualWidth;
                }
            }
        }
        float controlWidth = 3.0f * otherSegmentNominalWidth + (float)segmentWidth + widthAdjustment;
        int rasterWidth = (int)Math.ceil(controlWidth + s.widthAdjust);
        int rasterHeight = (int)Math.ceil((float)controlHeight + s.heightAdjust);
        Rectangle2D segmentBounds = AquaNativeSegmentedControlPainter.createPixelBounds(scale, s.left + xOffset, s.top, segmentWidth, controlHeight);
        return new SegmentButtonRenderingConfiguration4(scale, segmentIndex + 1, selectedSegmentIndex + 1, renderedSegmentNominalWidth, otherSegmentNominalWidth, rasterWidth, rasterHeight, segmentBounds);
    }

    @NotNull
    private static Rectangle2D createPixelBounds(int scale, double x, double y, double w, double h) {
        double x2 = AquaNativeSegmentedControlPainter.round(x + w, scale);
        double y2 = AquaNativeSegmentedControlPainter.round(y + h, scale);
        x = AquaNativeSegmentedControlPainter.round(x, scale);
        y = AquaNativeSegmentedControlPainter.round(y, scale);
        w = x2 - x;
        h = y2 - y;
        return new Rectangle2D.Double(x, y, w, h);
    }

    private static double round(double d, int scale) {
        if (scale == 1) {
            return Math.round(d);
        }
        return (double)Math.round(d * (double)scale) / (double)scale;
    }

    @NotNull
    public SegmentedControlConfiguration1 createControlConfiguration(@NotNull SegmentedButtonConfiguration g, @Nullable SegmentButtonRenderingConfiguration1 b) {
        AquaUIPainter.SegmentedButtonWidget widget = g.getWidget();
        boolean isToolbar = widget.isToolbar();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.SwitchTracking tracking = g.getTracking();
        AquaUIPainter.SegmentedButtonWidget basicWidget = widget.toBasicWidget();
        float w = b != null ? b.segmentWidth : 20.0f;
        boolean isSelected = b != null && b.isSelected;
        return new SegmentedControlConfiguration1(basicWidget, isToolbar, sz, st, w, isSelected);
    }

    @NotNull
    public SegmentedControlConfiguration4 createControlConfiguration(@NotNull SegmentedButtonConfiguration g, @Nullable SegmentButtonRenderingConfiguration4 b) {
        AquaUIPainter.SegmentedButtonWidget widget = g.getWidget();
        boolean isToolbar = widget.isToolbar();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.SwitchTracking tracking = g.getTracking();
        AquaUIPainter.SegmentedButtonWidget basicWidget = widget.toBasicWidget();
        float sw1 = b != null ? b.otherSegmentWidth : 20.0f;
        float sw2 = b != null ? b.otherSegmentWidth : 20.0f;
        float sw3 = b != null ? b.otherSegmentWidth : 20.0f;
        float sw4 = b != null ? b.otherSegmentWidth : 20.0f;
        boolean sel1 = false;
        boolean sel2 = false;
        boolean sel3 = false;
        boolean sel4 = false;
        if (b != null) {
            int i = b.designatedSegment;
            if (i == 1) {
                sw1 = b.segmentWidth;
            } else if (i == 2) {
                sw2 = b.segmentWidth;
            } else if (i == 3) {
                sw3 = b.segmentWidth;
            } else if (i == 4) {
                sw4 = b.segmentWidth;
            }
            int leftSelectedIndex = g.getLeftDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED && b.selectedSegment > 0 ? b.selectedSegment - 1 : 0;
            int rightSelectedIndex = g.getRightDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED && b.selectedSegment > 0 ? b.selectedSegment + 1 : 0;
            i = b.selectedSegment;
            if (i == 1 || leftSelectedIndex == 1) {
                sel1 = true;
            }
            if (i == 2 || leftSelectedIndex == 2 || rightSelectedIndex == 2) {
                sel2 = true;
            }
            if (i == 3 || leftSelectedIndex == 3 || rightSelectedIndex == 3) {
                sel3 = true;
            }
            if (i == 4 || rightSelectedIndex == 4) {
                sel4 = true;
            }
        }
        return new SegmentedControlConfiguration4(basicWidget, isToolbar, sz, st, tracking, sw1, sw2, sw3, sw4, sel1, sel2, sel3, sel4);
    }

    @Nullable
    public AnnotatedSegmentedControlImage paintSegmentedControl(@NotNull int[] data, int rw, int rh, float scale, SegmentedControlConfiguration g, boolean requestDebugOutput) {
        if (g instanceof SegmentedControlConfiguration1) {
            return this.paintSegmentedControl1(data, rw, rh, scale, (SegmentedControlConfiguration1)g, requestDebugOutput);
        }
        return this.paintSegmentedControl4(data, rw, rh, scale, (SegmentedControlConfiguration4)g, requestDebugOutput);
    }

    @Nullable
    private AnnotatedSegmentedControlImage paintSegmentedControl1(@NotNull int[] data, int rw, int rh, float scale, SegmentedControlConfiguration1 g, boolean requestDebugOutput) {
        if (rw < 1 || rh < 1 || data.length < rw * rh) {
            throw new IllegalArgumentException("Invalid raster size or length");
        }
        if ((double)scale < 0.01 || scale > 100.0f) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        int size = AquaNativePainter.toSize(g.size);
        int state = AquaNativePainter.toState(g.state);
        int style = AquaNativePainter.toSegmentedStyle(g.widget);
        boolean isSelected = g.isSelected;
        int context = g.isToolbar ? 2 : 1;
        float[] debugData = requestDebugOutput ? new float[4] : null;
        AquaNativeSegmentedControlPainter.nativePaintSegmentedControl1(data, rw, rh, scale, g.w, style, isSelected, context, size, state, debugData);
        if (debugData != null) {
            int count = debugData.length / 4;
            Rectangle2D[] segmentBounds = new Rectangle2D[count];
            int offset = 0;
            for (int i = 0; i < count; ++i) {
                segmentBounds[i] = AquaNativeSegmentedControlPainter.extractBounds(debugData, offset);
                offset += 4;
            }
            BufferedImage im = BasicImageSupport.createImage(data, rw, rh);
            return new AnnotatedSegmentedControlImage(im, segmentBounds);
        }
        return null;
    }

    @Nullable
    private AnnotatedSegmentedControlImage paintSegmentedControl4(@NotNull int[] data, int rw, int rh, float scale, SegmentedControlConfiguration4 g, boolean requestDebugOutput) {
        if (rw < 1 || rh < 1 || data.length < rw * rh) {
            throw new IllegalArgumentException("Invalid raster size or length");
        }
        if ((double)scale < 0.01 || scale > 100.0f) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        int size = AquaNativePainter.toSize(g.size);
        int state = AquaNativePainter.toState(g.state);
        int style = AquaNativePainter.toSegmentedStyle(g.widget);
        int tracking = AquaNativePainter.toTracking(g.tracking);
        int selectionFlags = AquaNativeSegmentedControlPainter.toSelectionFlags(g.s1, g.s2, g.s3, g.s4);
        int context = g.isToolbar ? 2 : 1;
        float[] debugData = requestDebugOutput ? new float[16] : null;
        AquaNativeSegmentedControlPainter.nativePaintSegmentedControl4(data, rw, rh, scale, g.w1, g.w2, g.w3, g.w4, style, tracking, selectionFlags, context, size, state, debugData);
        if (debugData != null) {
            int count = debugData.length / 4;
            Rectangle2D[] segmentBounds = new Rectangle2D[count];
            int offset = 0;
            for (int i = 0; i < count; ++i) {
                segmentBounds[i] = AquaNativeSegmentedControlPainter.extractBounds(debugData, offset);
                offset += 4;
            }
            BufferedImage im = BasicImageSupport.createImage(data, rw, rh);
            return new AnnotatedSegmentedControlImage(im, segmentBounds);
        }
        return null;
    }

    private static int toSelectionFlags(boolean s1, boolean s2, boolean s3, boolean s4) {
        return (s1 ? 8 : 0) | (s2 ? 4 : 0) | (s3 ? 2 : 0) | (s4 ? 1 : 0);
    }

    private static native int nativePaintSegmentedControl4(int[] var0, int var1, int var2, float var3, float var4, float var5, float var6, float var7, int var8, int var9, int var10, int var11, int var12, int var13, @Nullable float[] var14);

    private static native int nativePaintSegmentedControl1(int[] var0, int var1, int var2, float var3, float var4, int var5, boolean var6, int var7, int var8, int var9, @Nullable float[] var10);

    private static native int nativeDetermineSegmentedButtonLayoutParameters(int var0, int var1, float[] var2);

    public static native int nativeDetermineSegmentedButtonRenderingVersion();

    private static native int nativeDetermineSegmentedButtonFixedHeight(int var0, int var1);

    private class SegmentedButtonRenderer
    extends Renderer {
        @NotNull
        private final SegmentedButtonConfiguration g;

        public SegmentedButtonRenderer(SegmentedButtonConfiguration g) {
            this.g = g;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor compositor) {
            int h;
            int w;
            int y;
            int x;
            int[] raster;
            int rasterHeight;
            int rasterWidth;
            SegmentedControlLayoutInfo layout;
            int scale = compositor.getScaleFactor();
            int buttonWidth = Math.round(compositor.getWidth());
            int buttonHeight = Math.round(compositor.getHeight());
            RenderInsets s = AquaNativeSegmentedControlPainter.this.scds.getInsets(this.g, scale);
            if (this.g.getPosition() == AquaUIPainter.Position.ONLY) {
                layout = AquaNativeSegmentedControlPainter.this.scds.getSegment1LayoutInfo(this.g, scale);
                SegmentButtonRenderingConfiguration1 bc = AquaNativeSegmentedControlPainter.this.getRenderConfiguration(this.g.isSelected(), s, (SegmentedControl1LayoutInfo)layout, scale, buttonWidth, buttonHeight);
                SegmentedControlConfiguration1 cc = AquaNativeSegmentedControlPainter.this.createControlConfiguration(this.g, bc);
                rasterWidth = Math.round(scale * bc.rasterWidth);
                rasterHeight = Math.round(scale * bc.rasterHeight);
                raster = new int[rasterWidth * rasterHeight];
                AquaNativeSegmentedControlPainter.this.paintSegmentedControl1(raster, rasterWidth, rasterHeight, scale, cc, false);
                x = Math.round((float)scale * s.left);
                y = Math.round((float)scale * s.top);
                w = Math.round(scale * buttonWidth);
                h = Math.round(scale * buttonHeight);
            } else {
                layout = AquaNativeSegmentedControlPainter.this.scds.getSegment4LayoutInfo(this.g, scale);
                SegmentButtonRenderingConfiguration4 bc = AquaNativeSegmentedControlPainter.this.getRenderConfiguration(this.g, s, (SegmentedControl4LayoutInfo)layout, scale, buttonWidth, buttonHeight);
                SegmentedControlConfiguration4 cc = AquaNativeSegmentedControlPainter.this.createControlConfiguration(this.g, bc);
                rasterWidth = Math.round(scale * bc.rasterWidth);
                rasterHeight = Math.round(scale * bc.rasterHeight);
                raster = new int[rasterWidth * rasterHeight];
                AquaNativeSegmentedControlPainter.this.paintSegmentedControl4(raster, rasterWidth, rasterHeight, scale, cc, false);
                Rectangle2D bounds = bc.bounds;
                x = Math.round((float)scale * (float)bounds.getX());
                y = Math.round((float)scale * (float)bounds.getY());
                w = Math.round((float)scale * (float)bounds.getWidth());
                h = Math.round((float)scale * (float)bounds.getHeight());
            }
            PixelRasterImpl px = new PixelRasterImpl(raster, rasterWidth, rasterHeight);
            compositor.composeFrom(px, x, y, 0, 0, w, h);
        }
    }
}

