/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class LinearSliderTickMark10Renderer
extends Renderer {
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer tickRenderer;

    public LinearSliderTickMark10Renderer(@NotNull SliderConfiguration g, @NotNull Renderer tickRenderer) {
        this.g = g;
        this.tickRenderer = tickRenderer;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        int tickCount = this.g.getNumberOfTickMarks();
        if (tickCount < 2) {
            return;
        }
        float width = compositor.getWidth();
        float height = compositor.getHeight();
        AquaUIPainter.SliderWidget sw = this.g.getWidget();
        AquaUIPainter.Size sz = this.g.getSize();
        boolean isHorizontal = this.g.isHorizontal();
        double w = JNRUtils.size(sz, 2, 2, 1);
        double h = JNRUtils.size(sz, 4, 3, 3);
        if (isHorizontal) {
            width = (float)((double)width - w);
            double y = ((double)height - h) / 2.0;
            double x = 0.0;
            double spacing = width / (float)(tickCount - 1);
            for (int i = 0; i < tickCount; ++i) {
                this.drawTick(compositor, x, y, w, h);
                x += spacing;
            }
        } else {
            double temp = h;
            h = w;
            w = temp;
            height = (float)((double)height - h);
            double x = (width - 2.0f) / 2.0f;
            double y = 0.0;
            double spacing = height / (float)(tickCount - 1);
            for (int i = 0; i < tickCount; ++i) {
                this.drawTick(compositor, x, y, w, h);
                y += spacing;
            }
        }
    }

    private void drawTick(@NotNull ReusableCompositor compositor, double x, double y, double w, double h) {
        Rectangle2D.Double tickBounds = new Rectangle2D.Double(x, y, w, h);
        Renderer r = Renderer.createOffsetRenderer(this.tickRenderer, tickBounds);
        r.composeTo(compositor);
    }
}

