/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AbstractComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class PopupButtonLayoutConfiguration
extends AbstractComboBoxLayoutConfiguration {
    @NotNull
    private final AquaUIPainter.PopupButtonWidget bw;
    @NotNull
    private final AquaUIPainter.Size size;
    @NotNull
    private final AquaUIPainter.UILayoutDirection ld;

    public PopupButtonLayoutConfiguration(@NotNull AquaUIPainter.PopupButtonWidget bw, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.UILayoutDirection ld) {
        int platformVersion;
        if (size == AquaUIPainter.Size.MINI) {
            if (!PopupButtonLayoutConfiguration.supportsMini(bw)) {
                size = PopupButtonLayoutConfiguration.supportsSmall(bw) ? AquaUIPainter.Size.SMALL : AquaUIPainter.Size.REGULAR;
            }
        } else if (size == AquaUIPainter.Size.SMALL) {
            if (!PopupButtonLayoutConfiguration.supportsSmall(bw)) {
                size = AquaUIPainter.Size.REGULAR;
            }
        } else if (!(size != AquaUIPainter.Size.LARGE || (platformVersion = JNRPlatformUtils.getPlatformVersion()) >= 101600 && PopupButtonLayoutConfiguration.supportsLarge(bw))) {
            size = AquaUIPainter.Size.REGULAR;
        }
        this.bw = bw;
        this.size = size;
        this.ld = ld;
    }

    @Override
    @NotNull
    public Object getWidget() {
        return this.bw;
    }

    @NotNull
    public AquaUIPainter.PopupButtonWidget getPopupButtonWidget() {
        return this.bw;
    }

    @Override
    @NotNull
    public AquaUIPainter.Size getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public AquaUIPainter.UILayoutDirection getLayoutDirection() {
        return this.ld;
    }

    @Override
    public boolean isCell() {
        return this.bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || this.bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
    }

    public boolean isPopUp() {
        switch (this.bw) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_UP_CELL: 
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_UP_ROUND_RECT: 
            case BUTTON_POP_UP_RECESSED: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_UP_SQUARE: {
                return true;
            }
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_DOWN_CELL: 
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_DOWN_SQUARE: {
                return false;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLeftToRight() {
        return this.ld == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PopupButtonLayoutConfiguration that = (PopupButtonLayoutConfiguration)o;
        return this.bw == that.bw && this.size == that.size && this.ld == that.ld;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bw, this.size, this.ld});
    }

    @NotNull
    public String toString() {
        String lds = this.ld == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT ? " RTL" : "";
        return this.bw + " " + (Object)((Object)this.size) + lds;
    }

    public static boolean supportsMini(@NotNull AquaUIPainter.PopupButtonWidget w) {
        switch (w) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_UP_CELL: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: 
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_DOWN_CELL: 
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean supportsSmall(@NotNull AquaUIPainter.PopupButtonWidget w) {
        switch (w) {
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_DOWN_BEVEL: {
                return false;
            }
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_DOWN_GRADIENT: {
                int platformVersion = JNRPlatformUtils.getPlatformVersion();
                return platformVersion >= 101600;
            }
        }
        return true;
    }

    public static boolean supportsLarge(@NotNull AquaUIPainter.PopupButtonWidget w) {
        switch (w) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN: {
                return true;
            }
        }
        return false;
    }
}

