/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.geom.ExpandableEllipseOutline;
import org.violetlib.geom.ExpandableRectangleOutline;
import org.violetlib.geom.ExpandableRoundRectOutline;

public abstract class ExpandableOutline {
    @NotNull
    public abstract Shape getShape(float var1);

    @NotNull
    public static ExpandableOutline fromShape(@NotNull Shape s) {
        if (s instanceof RoundRectangle2D) {
            return new ExpandableRoundRectOutline((RoundRectangle2D)s);
        }
        if (s instanceof Rectangle2D) {
            return new ExpandableRectangleOutline((Rectangle2D)s);
        }
        if (s instanceof Ellipse2D) {
            return new ExpandableEllipseOutline((Ellipse2D)s);
        }
        if (s instanceof ExpandableShape) {
            ExpandableShape es = (ExpandableShape)((Object)s);
            return new ExpandableShapeOutline(es);
        }
        return new GenericOutline(s);
    }

    @NotNull
    public static Shape createTranslatedShape(@NotNull Shape s, double x, double y) {
        if (s instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)s;
            return new RoundRectangle2D.Double(rr.getX() + x, rr.getY() + y, rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D rr = (Rectangle2D)s;
            return new Rectangle2D.Double(rr.getX() + x, rr.getY() + y, rr.getWidth(), rr.getHeight());
        }
        if (s instanceof Ellipse2D) {
            Ellipse2D rr = (Ellipse2D)s;
            return new Ellipse2D.Double(rr.getX() + x, rr.getY() + y, rr.getWidth(), rr.getHeight());
        }
        if (s instanceof ExpandableShape) {
            ExpandableShape es = (ExpandableShape)((Object)s);
            return es.createTranslatedShape(x, y);
        }
        AffineTransform tr = AffineTransform.getTranslateInstance(x, y);
        return tr.createTransformedShape(s);
    }

    public static interface ExpandableShape {
        @NotNull
        public Shape createExpandedShape(float var1);

        @NotNull
        public Shape createTranslatedShape(double var1, double var3);
    }

    private static class ExpandableShapeOutline
    extends ExpandableOutline {
        @NotNull
        private final ExpandableShape s;

        public ExpandableShapeOutline(@NotNull ExpandableShape s) {
            this.s = s;
        }

        @Override
        @NotNull
        public Shape getShape(float offset) {
            return this.s.createExpandedShape(offset);
        }
    }

    private static class GenericOutline
    extends ExpandableOutline {
        @NotNull
        private final Shape s;

        public GenericOutline(@NotNull Shape s) {
            this.s = s;
        }

        @Override
        @NotNull
        public Shape getShape(float offset) {
            Rectangle2D bounds = this.s.getBounds2D();
            double cx = bounds.getCenterX();
            double cy = bounds.getCenterY();
            AffineTransform tr = AffineTransform.getTranslateInstance(cx, cy);
            double xfactor = (bounds.getWidth() + (double)(2.0f * offset)) / bounds.getWidth();
            double yfactor = (bounds.getHeight() + (double)(2.0f * offset)) / bounds.getHeight();
            tr.scale(xfactor, yfactor);
            tr.translate(-cx, -cy);
            return tr.createTransformedShape(this.s);
        }
    }
}

