/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Component;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.NativeOverlayView;

public class FilePreviewView {
    private long vptr = FilePreviewView.nativeCreatePreviewView();
    @Nullable
    private NativeOverlayView overlayView;

    public FilePreviewView() throws UnsupportedOperationException {
        if (this.vptr == 0L) {
            throw new UnsupportedOperationException("Unable to create file preview view");
        }
    }

    public void track(@NotNull Component component) {
        if (this.vptr != 0L) {
            if (this.overlayView != null) {
                this.overlayView.dispose();
                this.overlayView = null;
            }
            this.overlayView = new NativeOverlayView(component, this.vptr);
        }
    }

    public void clear() {
        if (this.vptr != 0L) {
            FilePreviewView.nativeConfigurePreview(this.vptr, null);
        }
    }

    public void configure(@NotNull File file) {
        if (this.vptr != 0L) {
            FilePreviewView.nativeConfigurePreview(this.vptr, file.getAbsolutePath());
        }
    }

    public void dispose() {
        if (this.vptr != 0L) {
            if (this.overlayView != null) {
                this.overlayView.dispose();
                this.overlayView = null;
            }
            FilePreviewView.nativeDisposePreviewView(this.vptr);
            this.vptr = 0L;
        }
    }

    private static native long nativeCreatePreviewView();

    private static native void nativeConfigurePreview(long var0, @Nullable String var2);

    private static native void nativeDisposePreviewView(long var0);
}

