/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ComponentTracker;
import org.violetlib.aqua.VisibleBounds;

public class NativeOverlayView {
    @Nullable
    private Component trackingComponent;
    private long vptr;
    @Nullable
    private Window window;
    @Nullable
    private VisibleBounds bounds;
    @Nullable
    private ComponentTracker tracker;

    public NativeOverlayView(@NotNull Component component, long l) throws IllegalArgumentException {
        if (l == 0L) {
            throw new IllegalArgumentException("Native view pointer must not be zero");
        }
        this.trackingComponent = component;
        this.vptr = l;
        this.tracker = new MyComponentTracker();
        this.tracker.attach(component);
        this.update();
    }

    public void dispose() {
        if (this.vptr != 0L) {
            if (this.window != null) {
                NativeOverlayView.hideNativeView(this.vptr);
            }
            this.vptr = 0L;
            assert (this.tracker != null);
            this.tracker.attach(null);
            this.tracker = null;
            this.window = null;
            this.bounds = null;
            this.trackingComponent = null;
        }
    }

    private void update() {
        if (this.vptr == 0L) {
            return;
        }
        assert (this.trackingComponent != null);
        Window window = SwingUtilities.getWindowAncestor(this.trackingComponent);
        VisibleBounds visibleBounds = null;
        if (window != null && this.trackingComponent.isShowing()) {
            visibleBounds = AquaUtils.getVisibleBoundsInContentView(this.trackingComponent);
        }
        if (!Objects.equals(this.window, window) || !Objects.equals(this.bounds, visibleBounds)) {
            this.window = window;
            this.bounds = visibleBounds;
            if (this.window != null && this.bounds != null) {
                AquaUtils.execute(this.window, l -> NativeOverlayView.showNativeView(this.vptr, l, this.bounds));
            } else {
                NativeOverlayView.hideNativeView(this.vptr);
            }
        }
    }

    private static long showNativeView(long l, long l2, @NotNull VisibleBounds visibleBounds) {
        Rectangle rectangle = visibleBounds.frame;
        if (visibleBounds.isClipped()) {
            Rectangle rectangle2 = visibleBounds.visibleBounds;
            int n = rectangle.x - rectangle2.x;
            int n2 = rectangle.y - rectangle2.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            NativeOverlayView.showNativeViewClipped(l, l2, n, n2, n3, n4, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } else {
            NativeOverlayView.showNativeViewClipped(l, l2, 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return 0L;
    }

    private static native void hideNativeView(long var0);

    private static native void showNativeView(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native void showNativeViewClipped(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private class MyComponentTracker
    extends ComponentTracker {
        private MyComponentTracker() {
        }

        @Override
        protected void attached(@Nullable Window window) {
            NativeOverlayView.this.update();
        }

        @Override
        protected void detached(@Nullable Window window) {
            NativeOverlayView.this.update();
        }

        @Override
        protected void windowChanged(@Nullable Window window, @Nullable Window window2) {
            NativeOverlayView.this.update();
        }

        @Override
        protected void visibleBoundsChanged(@Nullable Window window) {
            NativeOverlayView.this.update();
        }
    }
}

