/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.InternationalFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsLayoutConfiguration;

public class AquaSpinnerUI
extends SpinnerUI
implements AquaComponentUI {
    private static final AquaUtils.RecyclableSingleton<? extends PropertyChangeListener> propertyChangeListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<PropertyChangeHandler>(PropertyChangeHandler.class);
    private static final AquaUtils.RecyclableSingleton<ArrowButtonHandler> nextButtonHandler = new AquaUtils.RecyclableSingleton<ArrowButtonHandler>(){

        @Override
        protected ArrowButtonHandler getInstance() {
            return new ArrowButtonHandler("increment", true);
        }
    };
    private static final AquaUtils.RecyclableSingleton<ArrowButtonHandler> previousButtonHandler = new AquaUtils.RecyclableSingleton<ArrowButtonHandler>(){

        @Override
        protected ArrowButtonHandler getInstance() {
            return new ArrowButtonHandler("decrement", false);
        }
    };
    protected JSpinner spinner;
    protected SpinPainter spinPainter;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected static final int SEPARATION = 3;

    static PropertyChangeListener getPropertyChangeListener() {
        return propertyChangeListener.get();
    }

    static ArrowButtonHandler getNextButtonHandler() {
        return nextButtonHandler.get();
    }

    static ArrowButtonHandler getPreviousButtonHandler() {
        return previousButtonHandler.get();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSpinnerUI();
    }

    private void maybeAdd(Component component, String string) {
        if (component != null) {
            this.spinner.add(component, string);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        TransparentButton transparentButton = this.createNextButton();
        TransparentButton transparentButton2 = this.createPreviousButton();
        this.spinPainter = new SpinPainter(transparentButton, transparentButton2);
        this.maybeAdd(transparentButton, "Next");
        this.maybeAdd(transparentButton2, "Previous");
        this.maybeAdd(this.createEditor(), "Editor");
        this.maybeAdd(this.spinPainter, "Painter");
        this.updateEnabledState();
        this.installKeyboardActions();
        LookAndFeel.installProperty(this.spinner, "opaque", false);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner = null;
        jComponent.removeAll();
    }

    protected void installDefaults() {
        this.spinner.setLayout(this.createLayout());
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        AquaUtils.installFont(this.spinner, "Spinner.font");
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(AquaSpinnerUI.getPropertyChangeListener());
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(AquaSpinnerUI.getPropertyChangeListener());
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    protected TransparentButton createPreviousButton() {
        TransparentButton transparentButton = new TransparentButton();
        transparentButton.addActionListener(AquaSpinnerUI.getPreviousButtonHandler());
        transparentButton.addMouseListener(AquaSpinnerUI.getPreviousButtonHandler());
        transparentButton.setInheritsPopupMenu(true);
        return transparentButton;
    }

    protected TransparentButton createNextButton() {
        TransparentButton transparentButton = new TransparentButton();
        transparentButton.addActionListener(AquaSpinnerUI.getNextButtonHandler());
        transparentButton.addMouseListener(AquaSpinnerUI.getNextButtonHandler());
        transparentButton.setInheritsPopupMenu(true);
        return transparentButton;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        int n3;
        super.getBaseline(jComponent, n, n2);
        JComponent jComponent2 = this.spinner.getEditor();
        Insets insets = this.spinner.getInsets();
        n = n - insets.left - insets.right;
        n2 = n2 - insets.top - insets.bottom;
        if (n >= 0 && n2 >= 0 && (n3 = jComponent2.getBaseline(n, n2)) >= 0) {
            return insets.top + n3;
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return this.spinner.getEditor().getBaselineResizeBehavior();
    }

    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.fixupEditor(jComponent);
        return jComponent;
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.fixupEditor(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    protected void fixupEditor(JComponent jComponent) {
        KeyStroke[] keyStrokeArray;
        JFormattedTextField jFormattedTextField;
        if (!(jComponent instanceof JSpinner.DefaultEditor)) {
            return;
        }
        jComponent.setOpaque(false);
        jComponent.setInheritsPopupMenu(true);
        if (jComponent.getFont() instanceof UIResource) {
            jComponent.setFont(this.spinner.getFont());
        }
        if ((jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()).getFont() instanceof UIResource) {
            jFormattedTextField.setFont(this.spinner.getFont());
        }
        InputMap inputMap = this.getInputMap(1);
        InputMap inputMap2 = jFormattedTextField.getInputMap();
        for (KeyStroke keyStroke : keyStrokeArray = inputMap.keys()) {
            inputMap2.put(keyStroke, inputMap.get(keyStroke));
        }
    }

    void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container container, boolean bl) {
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            Component component = container.getComponent(i);
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            this.updateEnabledState((Container)component, bl);
        }
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, inputMap);
        SwingUtilities.replaceUIActionMap(this.spinner, this.getActionMap());
    }

    private InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("Spinner.ancestorInputMap");
        }
        return null;
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Spinner.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Spinner.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("increment", AquaSpinnerUI.getNextButtonHandler());
        actionMapUIResource.put("decrement", AquaSpinnerUI.getPreviousButtonHandler());
        return actionMapUIResource;
    }

    void updateToolTipTextForChildren(JComponent jComponent) {
        Component[] componentArray;
        String string = jComponent.getToolTipText();
        for (Component component : componentArray = jComponent.getComponents()) {
            if (component instanceof JSpinner.DefaultEditor) {
                JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)component).getTextField();
                if (jFormattedTextField == null) continue;
                jFormattedTextField.setToolTipText(string);
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setToolTipText(string);
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener {
        private final Timer autoRepeatTimer;
        private final boolean isNext;
        private JSpinner activeSpinner = null;

        ArrowButtonHandler(String string, boolean bl) {
            super(string);
            this.isNext = bl;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof Timer)) {
                this.activeSpinner = this.eventToSpinner(actionEvent);
            }
            if (this.activeSpinner != null) {
                try {
                    Object object;
                    int n = this.getCalendarField(this.activeSpinner);
                    this.activeSpinner.commitEdit();
                    if (n != -1) {
                        ((SpinnerDateModel)this.activeSpinner.getModel()).setCalendarField(n);
                    }
                    Object object2 = object = this.isNext ? this.activeSpinner.getNextValue() : this.activeSpinner.getPreviousValue();
                    if (object != null) {
                        this.activeSpinner.setValue(object);
                        this.select(this.activeSpinner);
                    }
                }
                catch (IllegalArgumentException | ParseException exception) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.activeSpinner);
                }
            }
        }

        private void select(JSpinner jSpinner) {
            Object object;
            JComponent jComponent = jSpinner.getEditor();
            if (!(jComponent instanceof JSpinner.DateEditor)) {
                return;
            }
            JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
            JFormattedTextField jFormattedTextField = dateEditor.getTextField();
            SimpleDateFormat simpleDateFormat = dateEditor.getFormat();
            if (simpleDateFormat == null || (object = jSpinner.getValue()) == null) {
                return;
            }
            SpinnerDateModel spinnerDateModel = dateEditor.getModel();
            DateFormat.Field field = DateFormat.Field.ofCalendarField(spinnerDateModel.getCalendarField());
            if (field == null) {
                return;
            }
            try {
                AttributedCharacterIterator attributedCharacterIterator = ((Format)simpleDateFormat).formatToCharacterIterator(object);
                if (!this.select(jFormattedTextField, attributedCharacterIterator, field) && field == DateFormat.Field.HOUR0) {
                    this.select(jFormattedTextField, attributedCharacterIterator, DateFormat.Field.HOUR1);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private boolean select(JFormattedTextField jFormattedTextField, AttributedCharacterIterator attributedCharacterIterator, DateFormat.Field field) {
            int n = jFormattedTextField.getDocument().getLength();
            attributedCharacterIterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> map;
                if ((map = attributedCharacterIterator.getAttributes()) == null || !map.containsKey(field)) continue;
                int n2 = attributedCharacterIterator.getRunStart(field);
                int n3 = attributedCharacterIterator.getRunLimit(field);
                if (n2 != -1 && n3 != -1 && n2 <= n && n3 <= n) {
                    jFormattedTextField.select(n2, n3);
                }
                return true;
            } while (attributedCharacterIterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner jSpinner) {
            Format.Field[] fieldArray;
            JComponent jComponent = jSpinner.getEditor();
            if (!(jComponent instanceof JSpinner.DateEditor)) {
                return -1;
            }
            JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
            JFormattedTextField jFormattedTextField = dateEditor.getTextField();
            int n = jFormattedTextField.getSelectionStart();
            JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
            if (!(abstractFormatter instanceof InternationalFormatter)) {
                return -1;
            }
            for (Format.Field field : fieldArray = ((InternationalFormatter)abstractFormatter).getFields(n)) {
                int n2;
                if (!(field instanceof DateFormat.Field) || (n2 = field == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)field).getCalendarField()) == -1) continue;
                return n2;
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !mouseEvent.getComponent().isEnabled()) {
                return;
            }
            this.activeSpinner = this.eventToSpinner(mouseEvent);
            if (this.activeSpinner != null) {
                this.activeSpinner.repaint();
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            if (this.activeSpinner != null) {
                this.activeSpinner.repaint();
                this.activeSpinner = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void focusSpinnerIfNecessary() {
            assert (this.activeSpinner != null);
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (!this.activeSpinner.isRequestFocusEnabled() || component != null && SwingUtilities.isDescendingFrom(component, this.activeSpinner)) {
                return;
            }
            Container container = this.activeSpinner;
            if (!container.isFocusCycleRoot()) {
                container = container.getFocusCycleRootAncestor();
            }
            if (container == null) {
                return;
            }
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component2 = focusTraversalPolicy.getComponentAfter(container, this.activeSpinner);
            if (component2 != null && SwingUtilities.isDescendingFrom(component2, this.activeSpinner)) {
                component2.requestFocus();
            }
        }
    }

    class TransparentButton
    extends JButton
    implements SwingConstants {
        boolean interceptRepaints = false;

        public TransparentButton() {
            this.setUI(new BasicButtonUI());
            this.setFocusable(false);
            this.interceptRepaints = true;
        }

        @Override
        public void paint(Graphics graphics) {
        }

        @Override
        public void repaint() {
            if (this.interceptRepaints) {
                if (AquaSpinnerUI.this.spinPainter == null) {
                    return;
                }
                AquaSpinnerUI.this.spinPainter.repaint();
            }
            super.repaint();
        }
    }

    class SpinPainter
    extends JComponent {
        ButtonModel fTopModel;
        ButtonModel fBottomModel;

        public SpinPainter(AbstractButton abstractButton, AbstractButton abstractButton2) {
            if (abstractButton != null) {
                this.fTopModel = abstractButton.getModel();
            }
            if (abstractButton2 != null) {
                this.fBottomModel = abstractButton2.getModel();
            }
            this.setUI(new SpinnerPainterUI());
        }

        @Override
        public ComponentUI getUI() {
            return this.ui;
        }

        @Override
        public void paint(Graphics graphics) {
            if (AquaSpinnerUI.this.spinner.isOpaque()) {
                graphics.setColor(AquaSpinnerUI.this.spinner.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Rectangle rectangle = this.getBounds();
            AppearanceManager.ensureAppearance(AquaSpinnerUI.this.spinner);
            AquaUtils.configure(AquaSpinnerUI.this.painter, AquaSpinnerUI.this.spinner, rectangle.width, rectangle.height);
            Configuration configuration = this.getConfiguration();
            AquaSpinnerUI.this.painter.getPainter(configuration).paint(graphics, 0.0f, 0.0f);
        }

        protected Configuration getConfiguration() {
            AquaUIPainter.State state;
            AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(AquaSpinnerUI.this.spinner);
            boolean bl = false;
            if (this.isEnabled()) {
                if (this.fTopModel != null && this.fTopModel.isPressed()) {
                    state = AquaUIPainter.State.PRESSED;
                    bl = true;
                } else {
                    state = this.fBottomModel != null && this.fBottomModel.isPressed() ? AquaUIPainter.State.PRESSED : AquaUIPainter.State.ACTIVE;
                }
            } else {
                state = AquaUIPainter.State.DISABLED;
            }
            boolean bl2 = false;
            return new SpinnerArrowsConfiguration(size, state, bl2, bl);
        }

        @Override
        public Dimension getPreferredSize() {
            AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(AquaSpinnerUI.this.spinner);
            SpinnerArrowsLayoutConfiguration spinnerArrowsLayoutConfiguration = new SpinnerArrowsLayoutConfiguration(size);
            LayoutInfo layoutInfo = AquaSpinnerUI.this.painter.getLayoutInfo().getLayoutInfo(spinnerArrowsLayoutConfiguration);
            int n = (int)layoutInfo.getFixedVisualWidth();
            int n2 = (int)layoutInfo.getFixedVisualHeight();
            if (n == 0) {
                n = 14;
            }
            if (n2 == 0) {
                n2 = 23;
            }
            return new Dimension(n, n2);
        }
    }

    static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;
        private Component painter = null;

        SpinnerLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            } else if ("Painter".equals(string)) {
                this.painter = component;
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            } else if (component == this.painter) {
                this.painter = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? new Dimension(0, 0) : component.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.editor);
            Dimension dimension2 = this.preferredSize(this.painter);
            dimension.height = (dimension.height + 1) / 2 * 2;
            Dimension dimension3 = new Dimension(dimension.width, Math.max(dimension2.height, dimension.height));
            dimension3.width += dimension2.width;
            Insets insets = container.getInsets();
            dimension3.width += insets.left + insets.right + 3;
            dimension3.height += insets.top + insets.bottom;
            return dimension3;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            Insets insets = container.getInsets();
            int n3 = container.getWidth() - (insets.left + insets.right);
            int n4 = container.getHeight() - (insets.top + insets.bottom);
            Dimension dimension = this.preferredSize(this.painter);
            int n5 = n4 / 2;
            int n6 = n4 - n5;
            int n7 = dimension.width;
            int n8 = n3 - n7 - 3;
            if (container.getComponentOrientation().isLeftToRight()) {
                n2 = insets.left;
                n = n2 + n8 + 3;
            } else {
                n = insets.left;
                n2 = n + n7 + 3;
            }
            int n9 = insets.top + n5;
            int n10 = n9 - dimension.height / 2;
            this.setBounds(this.editor, n2, insets.top, n8, n4);
            this.setBounds(this.nextButton, n, insets.top, n7, n5);
            this.setBounds(this.previousButton, n, n9, n7, n6);
            this.setBounds(this.painter, n, n10, n7, dimension.height);
        }
    }

    static class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JSpinner jSpinner = (JSpinner)propertyChangeEvent.getSource();
            SpinnerUI spinnerUI = jSpinner.getUI();
            if (spinnerUI instanceof AquaSpinnerUI) {
                JFormattedTextField jFormattedTextField;
                JComponent jComponent;
                AquaSpinnerUI aquaSpinnerUI = (AquaSpinnerUI)spinnerUI;
                if ("editor".equals(string)) {
                    JComponent jComponent2 = (JComponent)propertyChangeEvent.getOldValue();
                    JComponent jComponent3 = (JComponent)propertyChangeEvent.getNewValue();
                    aquaSpinnerUI.replaceEditor(jComponent2, jComponent3);
                    aquaSpinnerUI.updateEnabledState();
                } else if ("enabled".equals(string)) {
                    aquaSpinnerUI.updateEnabledState();
                } else if ("ToolTipText".equals(string)) {
                    aquaSpinnerUI.updateToolTipTextForChildren(jSpinner);
                } else if ("font".equals(string)) {
                    JFormattedTextField jFormattedTextField2;
                    JComponent jComponent4 = jSpinner.getEditor();
                    if (jComponent4 != null && jComponent4 instanceof JSpinner.DefaultEditor && (jFormattedTextField2 = ((JSpinner.DefaultEditor)jComponent4).getTextField()) != null && jFormattedTextField2.getFont() instanceof UIResource) {
                        jFormattedTextField2.setFont(jSpinner.getFont());
                    }
                } else if ("JComponent.sizeVariant".equals(string) && (jComponent = jSpinner.getEditor()) != null && jComponent instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()) != null) {
                    jFormattedTextField.putClientProperty(string, propertyChangeEvent.getNewValue());
                }
            }
        }
    }

    class SpinnerPainterUI
    extends ComponentUI
    implements FocusRingOutlineProvider {
        SpinnerPainterUI() {
        }

        @Override
        @Nullable
        public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
            AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(AquaSpinnerUI.this.spinner);
            SpinnerArrowsLayoutConfiguration spinnerArrowsLayoutConfiguration = new SpinnerArrowsLayoutConfiguration(size);
            Rectangle rectangle = jComponent.getBounds();
            AppearanceManager.ensureAppearance(jComponent);
            AquaUtils.configure(AquaSpinnerUI.this.painter, jComponent, rectangle.width, rectangle.height);
            return AquaSpinnerUI.this.painter.getOutline(spinnerArrowsLayoutConfiguration);
        }

        @Override
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            AquaFullKeyboardFocusableHandler.addListener(jComponent);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            AquaFullKeyboardFocusableHandler.removeListener(jComponent);
            super.uninstallUI(jComponent);
        }
    }
}

