/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaMenuSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.MenuSelectionBoundsTracker;
import org.violetlib.aqua.OSXSystemProperties;

public class AquaMenuUI
extends BasicMenuUI
implements AquaComponentUI {
    @NotNull
    protected BasicContextualColors colors = AquaColors.getMenuColors();
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(133);
        this.configureAppearanceContext(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListeners(this.menuItem);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListeners(this.menuItem);
        super.uninstallListeners();
    }

    @Override
    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new BasicMenuUI.ChangeHandler(this, (JMenu)jComponent, this);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.menuItem);
        }
        this.appearanceContext = AquaMenuSupport.instance().getAppearanceContext(this.menuItem, aquaAppearance);
        AquaColors.installColors(this.menuItem, this.appearanceContext, this.colors);
        this.menuItem.repaint();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.appearanceContext = AquaMenuSupport.instance().getAppearanceContext(this.menuItem, null);
        if (AquaLookAndFeel.USE_VIBRANT_MENU) {
            JPopupMenu jPopupMenu;
            Object object;
            Container container = jComponent.getParent();
            if (container instanceof JPopupMenu && (object = (jPopupMenu = (JPopupMenu)container).getClientProperty("Aqua.PopupMenu.Tracker")) instanceof MenuSelectionBoundsTracker) {
                MenuSelectionBoundsTracker menuSelectionBoundsTracker = (MenuSelectionBoundsTracker)object;
                menuSelectionBoundsTracker.paintingItem((JMenuItem)jComponent, this.appearanceContext);
            }
        } else {
            Color color = this.colors.getBackground(this.appearanceContext);
            graphics.setColor(color);
            if (OSXSystemProperties.useInsetViewStyle()) {
                AquaUtils.paintInsetMenuItemSelection((Graphics2D)graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
            } else {
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
        AquaMenuSupport.instance().paintMenuItem((Graphics2D)graphics, this.menuItem, this.checkIcon, this.arrowIcon, this.appearanceContext, this.colors, this.defaultTextIconGap, this.acceleratorFont);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Dimension dimension = AquaMenuSupport.instance().getPreferredMenuItemSize(jComponent, icon, icon2, n, this.acceleratorFont);
        if (jComponent.getParent() instanceof JMenuBar) {
            dimension.height = Math.max(dimension.height, 21);
        }
        return dimension;
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new AquaMouseInputHandler();
    }

    @Override
    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    private static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    protected class AquaMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected AquaMouseInputHandler() {
            super(AquaMenuUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)AquaMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!(menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == jMenu.getPopupMenu() || jMenu.isTopLevelMenu() && (menuElementArray.length <= 0 || menuElementArray[0] != jMenu.getParent()))) {
                if (jMenu.getDelay() == 0) {
                    AquaMenuUI.appendPath(AquaMenuUI.this.getPath(), jMenu.getPopupMenu());
                } else {
                    menuSelectionManager.setSelectedPath(AquaMenuUI.this.getPath());
                    AquaMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }
    }

    class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!AquaMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < AquaMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < AquaMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)AquaMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        AquaMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        AquaMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }
}

