/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaMenuSupport {
    static final char kUBlackDiamond = '\u25c6';
    static final char kUCheckMark = '\u2713';
    static final char kUControlGlyph = '\u2303';
    static final char kUOptionGlyph = '\u2325';
    static final char kUEnterGlyph = '\u2324';
    static final char kUCommandGlyph = '\u2318';
    static final char kULeftDeleteGlyph = '\u232b';
    static final char kURightDeleteGlyph = '\u2326';
    static final char kUShiftGlyph = '\u21e7';
    static final char kUCapsLockGlyph = '\u21ea';
    static final int ALT_GRAPH_MASK = 32;
    static final AquaUtils.RecyclableSingleton<AquaMenuSupport> sPainter = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaMenuSupport>(AquaMenuSupport.class);

    static String getKeyModifiersText(int n, boolean bl) {
        return AquaMenuSupport.getKeyModifiersUnicode(n, bl);
    }

    private static String getKeyModifiersUnicode(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(2);
        if (bl) {
            if ((n & 2) != 0) {
                stringBuilder.append('\u2303');
            }
            if ((n & 0x28) != 0) {
                stringBuilder.append('\u2325');
            }
            if ((n & 1) != 0) {
                stringBuilder.append('\u21e7');
            }
            if ((n & 4) != 0) {
                stringBuilder.append('\u2318');
            }
        } else {
            if ((n & 4) != 0) {
                stringBuilder.append('\u2318');
            }
            if ((n & 1) != 0) {
                stringBuilder.append('\u21e7');
            }
            if ((n & 0x28) != 0) {
                stringBuilder.append('\u2325');
            }
            if ((n & 2) != 0) {
                stringBuilder.append('\u2303');
            }
        }
        return stringBuilder.toString();
    }

    static AquaMenuSupport instance() {
        return sPainter.get();
    }

    @NotNull
    public AppearanceContext getAppearanceContext(@NotNull JMenuItem jMenuItem, @Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(jMenuItem);
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Container container = this.getAncestor(jMenuItem);
        boolean bl = buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected();
        boolean bl2 = buttonModel.isEnabled() && (container == null || container.isVisible());
        AquaUIPainter.State state = bl2 ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.DISABLED;
        return new AppearanceContext(aquaAppearance, state, bl, false);
    }

    @NotNull
    protected AquaUIPainter.State getState(@NotNull JMenuItem jMenuItem) {
        boolean bl;
        Container container = this.getAncestor(jMenuItem);
        ButtonModel buttonModel = jMenuItem.getModel();
        boolean bl2 = bl = buttonModel.isEnabled() && (container == null || container.isVisible());
        if (!bl) {
            return AquaUIPainter.State.DISABLED;
        }
        if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            return AquaUIPainter.State.ACTIVE_DEFAULT;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Nullable
    protected Container getAncestor(@NotNull JMenuItem jMenuItem) {
        Container container;
        for (container = jMenuItem.getParent(); container != null && !(container instanceof JPopupMenu); container = container.getParent()) {
        }
        return container;
    }

    public void paintMenuItem(Graphics2D graphics2D, JMenuItem jMenuItem, Icon icon, Icon icon2, AppearanceContext appearanceContext, BasicContextualColors basicContextualColors, int n, Font font) {
        int n2;
        boolean bl;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n3 = jMenuItem.getWidth();
        int n4 = jMenuItem.getHeight();
        Insets insets = jMenuItem.getInsets();
        Rectangle rectangle = new Rectangle(0, 0, n3, n4);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Font font2 = jMenuItem.getFont();
        graphics2D.setFont(font2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics2D.getFontMetrics(font);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        String string2 = "";
        boolean bl2 = AquaUtils.isLeftToRight(jMenuItem);
        if (keyStroke != null) {
            int n5;
            int n6 = keyStroke.getModifiers();
            if (n6 > 0) {
                string = AquaMenuSupport.getKeyModifiersText(n6, bl2);
            }
            string2 = (n5 = keyStroke.getKeyCode()) != 0 ? KeyEvent.getKeyText(n5) : string2 + keyStroke.getKeyChar();
        }
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle();
        String string3 = this.layoutMenuItem(jMenuItem, fontMetrics, jMenuItem.getText(), fontMetrics2, string2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, rectangle4, rectangle5, rectangle6, jMenuItem.getText() == null ? 0 : n, n);
        Color color = basicContextualColors.getForeground(appearanceContext);
        graphics2D.setColor(color);
        boolean bl3 = appearanceContext.isSelected();
        boolean bl4 = bl = appearanceContext.getState() != AquaUIPainter.State.DISABLED;
        if (jMenuItem.getIcon() != null) {
            this.paintIcon(graphics2D, jMenuItem, rectangle2, bl);
        }
        if (icon != null) {
            this.paintCheck(graphics2D, jMenuItem, color, icon, rectangle5);
        }
        if (!string2.equals("")) {
            int n7 = rectangle4.y + fontMetrics.getAscent();
            if (string.equals("")) {
                JavaSupport.drawString(jMenuItem, graphics2D, string2, rectangle4.x, n7);
            } else {
                n2 = keyStroke.getModifiers();
                int n8 = 0;
                if ((n2 & 0x20) > 0) {
                    n8 = 8997;
                }
                int n9 = Math.max(fontMetrics.charWidth('M'), SwingUtilities.computeStringWidth(fontMetrics, string2));
                if (bl2) {
                    graphics2D.setFont(font);
                    this.drawString(graphics2D, jMenuItem, string, n8, rectangle4.x, n7, bl, bl3);
                    graphics2D.setFont(font2);
                    JavaSupport.drawString(jMenuItem, graphics2D, string2, rectangle4.x + rectangle4.width - n9, n7);
                } else {
                    int n10 = rectangle4.x + n9;
                    graphics2D.setFont(font);
                    this.drawString(graphics2D, jMenuItem, string, n8, n10, n7, bl, bl3);
                    graphics2D.setFont(font2);
                    JavaSupport.drawString(jMenuItem, graphics2D, string2, n10 - fontMetrics.stringWidth(string2), n7);
                }
            }
        }
        if (string3 != null && !string3.equals("")) {
            View view = (View)jMenuItem.getClientProperty("html");
            if (view != null) {
                view.paint(graphics2D, rectangle3);
            } else {
                n2 = AquaMnemonicHandler.isMnemonicHidden() ? -1 : buttonModel.getMnemonic();
                this.drawString(graphics2D, jMenuItem, string3, n2, rectangle3.x, rectangle3.y + fontMetrics.getAscent(), bl, bl3);
            }
        }
        if (icon2 != null) {
            this.paintArrow(graphics2D, jMenuItem, buttonModel, color, icon2, rectangle6);
        }
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n, Font font) {
        Insets insets;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        String string3 = "";
        if (keyStroke != null) {
            int n2;
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string3 = AquaMenuSupport.getKeyModifiersText(n3, true);
            }
            string2 = (n2 = keyStroke.getKeyCode()) != 0 ? KeyEvent.getKeyText(n2) : string2 + keyStroke.getKeyChar();
        }
        Font font2 = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font2);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        this.layoutMenuItem(jMenuItem, fontMetrics, string, fontMetrics2, string2, string3, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle6, rectangle, rectangle2, rectangle3, rectangle4, rectangle5, string == null ? 0 : n, n);
        Rectangle rectangle7 = new Rectangle();
        rectangle7.setBounds(rectangle2);
        rectangle7 = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle7);
        boolean bl = string2.equals("");
        if (!bl) {
            rectangle7.width += rectangle3.width;
        }
        if (!AquaMenuSupport.isTopLevelMenu(jMenuItem)) {
            rectangle7.width += rectangle4.width;
            rectangle7.width += n;
            rectangle7.width += n;
            rectangle7.width += rectangle5.width;
        }
        if ((insets = jMenuItem.getInsets()) != null) {
            rectangle7.width += insets.left + insets.right;
            rectangle7.height += insets.top + insets.bottom;
        }
        rectangle7.width += 4 + n;
        rectangle7.height = Math.max(rectangle7.height, 18);
        return rectangle7.getSize();
    }

    protected void paintCheck(Graphics graphics, JMenuItem jMenuItem, Color color, Icon icon, Rectangle rectangle) {
        if (AquaMenuSupport.isTopLevelMenu(jMenuItem) || !jMenuItem.isSelected()) {
            return;
        }
        Image image = AquaImageFactory.getProcessedImage(icon, (Object)color);
        graphics.drawImage(image, rectangle.x, rectangle.y, null);
    }

    protected void paintArrow(Graphics graphics, JMenuItem jMenuItem, ButtonModel buttonModel, Color color, Icon icon, Rectangle rectangle) {
        if (AquaMenuSupport.isTopLevelMenu(jMenuItem)) {
            return;
        }
        Image image = AquaImageFactory.getProcessedImage(icon, (Object)color);
        graphics.drawImage(image, rectangle.x, rectangle.y, null);
    }

    protected void paintIcon(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, boolean bl) {
        Icon icon;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!bl) {
            icon = jMenuItem.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon = jMenuItem.getPressedIcon();
            if (icon == null) {
                icon = jMenuItem.getIcon();
            }
        } else {
            icon = jMenuItem.getIcon();
        }
        if (icon != null) {
            icon.paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
        }
    }

    public void drawString(Graphics graphics, JComponent jComponent, String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = -1;
        if (n != 0) {
            char c = Character.toUpperCase((char)n);
            char c2 = Character.toLowerCase((char)n);
            int n5 = string.indexOf(c);
            int n6 = string.indexOf(c2);
            n4 = n5 == -1 ? n6 : (n6 == -1 ? n5 : (n6 < n5 ? n6 : n5));
        }
        JavaSupport.drawStringUnderlineCharAt(jComponent, (Graphics2D)graphics, string, n4, n2, n3);
    }

    private static boolean isTopLevelMenu(JMenuItem jMenuItem) {
        return jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu();
    }

    private String layoutMenuItem(JMenuItem jMenuItem, FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, String string3, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        boolean bl;
        Dimension dimension = icon != null ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : null;
        AquaUtils.layoutCompoundLabel(jMenuItem, fontMetrics, string, dimension, n, 2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        boolean bl2 = bl = string2 == null || string2.equals("");
        if (bl) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string3);
            rectangle4.width += Math.max(fontMetrics.charWidth('M'), SwingUtilities.computeStringWidth(fontMetrics, string2));
            rectangle4.height = fontMetrics2.getHeight();
        }
        boolean bl3 = AquaMenuSupport.isTopLevelMenu(jMenuItem);
        if (!bl3) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 16;
                rectangle5.width = 16;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 16;
                rectangle6.width = 16;
            }
            rectangle3.x += 12;
            rectangle2.x += 12;
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        rectangle4.x += rectangle.width - rectangle6.width - rectangle4.width;
        rectangle4.y = rectangle.y + rectangle.height / 2 - rectangle4.height / 2;
        if (!bl3) {
            rectangle6.x = rectangle.width - rectangle6.width + 1;
            rectangle6.y = rectangle.y + rectangle7.height / 2 - rectangle6.height / 2 + 1;
            rectangle5.y = rectangle.y + rectangle7.height / 2 - rectangle5.height / 2;
            rectangle5.x = 5;
            rectangle3.width += 8;
        }
        if (!AquaUtils.isLeftToRight(jMenuItem)) {
            int n7 = rectangle.width;
            rectangle5.x = n7 - (rectangle5.x + rectangle5.width);
            rectangle2.x = n7 - (rectangle2.x + rectangle2.width);
            rectangle3.x = n7 - (rectangle3.x + rectangle3.width);
            rectangle4.x = n7 - (rectangle4.x + rectangle4.width);
            rectangle6.x = n7 - (rectangle6.x + rectangle6.width);
        }
        rectangle3.x += n6;
        rectangle2.x += n6;
        return string;
    }
}

