/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaButtonIcon;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaPushButtonBorder;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaSharedColorChooser;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.ImageIconUIResource;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.SegmentedControlModel;
import org.violetlib.aqua.SharedColorChooserOwner;
import org.violetlib.aqua.ToolbarSensitiveUI;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaButtonUI
extends BasicButtonUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider,
ToolbarSensitiveUI,
AquaComponentUI {
    public static final String BUTTON_TYPE = "JButton.buttonType";
    public static final String SEGMENTED_BUTTON_POSITION = "JButton.segmentPosition";
    public static final String SELECTED_STATE_KEY = "JButton.selectedState";
    public static final String ENABLE_TRANSLUCENT_COLORS_KEY = "JButton.enableTranslucentColors";
    public static final float OUTLINE_OFFSET = 0.0f;
    public static final float OUTLINE_CORNER = 9.0f;
    public static final String LAYOUT_CONFIGURATION_PROPERTY = "Aqua.Button.LayoutConfiguration";
    public static final String DEFAULT_FONT_PROPERTY = "Aqua.Button.DefaultFont";
    protected static final String COLOR_CHOOSER_OWNER_PROPERTY = "Aqua.Button.ColorChooserOwner";
    protected static final String SPECIAL_ICON_PROPERTY = "Aqua.Button.SpecialIcon";
    protected static final String CACHED_TOOLBAR_STATUS_PROPERTY = "Aqua.Button.IsToolbarButton";
    protected static final AquaUtils.RecyclableSingleton<AquaButtonUI> buttonUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaButtonUI>(AquaButtonUI.class);
    private static boolean isConfiguring;

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI.get();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.removeCachedIcons((AbstractButton)jComponent);
    }

    @Override
    protected void installDefaults(@NotNull AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        this.setButtonMarginIfNeeded(abstractButton, UIManager.getInsets(string + "margin"));
        AquaUtils.installFont(abstractButton, string + "font");
        LookAndFeel.installProperty(abstractButton, "opaque", false);
        abstractButton.putClientProperty(DEFAULT_FONT_PROPERTY, abstractButton.getFont());
        this.initializeToolbarStatus(abstractButton);
        this.configure(abstractButton);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        jComponent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(@NotNull AbstractButton abstractButton) {
        if (isConfiguring) {
            return;
        }
        isConfiguring = true;
        try {
            Object object;
            boolean bl = this.isToolbar(abstractButton);
            AquaButtonExtendedTypes.TypeSpecifier typeSpecifier = AquaButtonExtendedTypes.getTypeSpecifier(abstractButton, bl);
            this.installBorder(abstractButton, typeSpecifier, bl);
            LayoutConfiguration layoutConfiguration = null;
            Border border = abstractButton.getBorder();
            if (border instanceof AquaButtonBorder) {
                object = (AquaButtonBorder)border;
                layoutConfiguration = ((AquaButtonBorder)object).determineLayoutConfiguration(abstractButton);
                if (((AquaButtonBorder)object).isRolloverEnabled(abstractButton)) {
                    LookAndFeel.installProperty(abstractButton, "rolloverEnabled", true);
                }
                int n = ((AquaButtonBorder)object).getIconTextGap(abstractButton);
                LookAndFeel.installProperty(abstractButton, "iconTextGap", n);
            }
            abstractButton.putClientProperty(LAYOUT_CONFIGURATION_PROPERTY, layoutConfiguration);
            object = AquaUtilControlSize.getUserSizeFrom(abstractButton);
            if (AquaUtilControlSize.isOKToInstallDefaultFont(abstractButton)) {
                Font font = this.getFontForButton(abstractButton, (AquaUIPainter.Size)((Object)object));
                abstractButton.setFont(font);
            }
            this.updateTemplateIconStatus(abstractButton);
            if (!AquaButtonUI.isColorWell(abstractButton)) {
                this.disconnectColorChooser(abstractButton);
            }
            abstractButton.setRequestFocusEnabled(false);
            abstractButton.revalidate();
            abstractButton.repaint();
        }
        finally {
            isConfiguring = false;
        }
    }

    protected void updateTemplateIconStatus(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(SPECIAL_ICON_PROPERTY);
        if (object instanceof AquaButtonIcon) {
            AquaButtonIcon aquaButtonIcon = (AquaButtonIcon)object;
            boolean bl = this.determineTemplateIconStatus(abstractButton);
            if (aquaButtonIcon.isTemplate != bl) {
                this.removeCachedIcons(abstractButton);
            }
        }
    }

    protected boolean determineTemplateIconStatus(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            Image image = imageIcon.getImage();
            return !this.isApplicationDefined(abstractButton.getPressedIcon()) && !this.isApplicationDefined(AquaButtonUI.getDisabledIcon(abstractButton)) && !this.isApplicationDefined(abstractButton.getSelectedIcon()) && !this.isApplicationDefined(AquaButtonUI.getDisabledSelectedIcon(abstractButton)) && !this.isApplicationDefined(abstractButton.getRolloverIcon()) && !this.isApplicationDefined(abstractButton.getRolloverSelectedIcon()) && AquaImageFactory.isTemplateImage(image);
        }
        return false;
    }

    protected boolean isApplicationDefined(Icon icon) {
        return icon != null && !(icon instanceof UIResource);
    }

    protected void installBorder(AbstractButton abstractButton, AquaButtonExtendedTypes.TypeSpecifier typeSpecifier, boolean bl) {
        Border border;
        Border border2 = border = typeSpecifier != null ? typeSpecifier.getBorder() : null;
        if (border != null) {
            abstractButton.setBorder(border);
        } else {
            Border border3 = abstractButton.getBorder();
            if (border3 == null || border3 instanceof UIResource) {
                Border border4 = this.getDefaultBorder(abstractButton, bl);
                if (border4 == null) {
                    border4 = new AquaPushButtonBorder();
                }
                abstractButton.setBorder(border4);
            }
        }
    }

    protected Border getDefaultBorder(@NotNull AbstractButton abstractButton, boolean bl) {
        if (bl) {
            if (abstractButton instanceof JToggleButton) {
                return AquaButtonBorder.getToolBarToggleButtonBorder();
            }
            return AquaButtonBorder.getToolBarPushButtonBorder();
        }
        if (abstractButton instanceof JToggleButton) {
            return AquaButtonBorder.getToggleButtonBorder();
        }
        return AquaButtonBorder.getPushButtonBorder();
    }

    @Override
    @Nullable
    public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border instanceof FocusRingOutlineProvider) {
            FocusRingOutlineProvider focusRingOutlineProvider = (FocusRingOutlineProvider)((Object)border);
            return focusRingOutlineProvider.getFocusRingOutline(jComponent);
        }
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        return new RoundRectangle2D.Double(0.0, 0.0, (float)n - 0.0f, (float)n2 - 0.0f, 9.0, 9.0);
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        this.configure((AbstractButton)jComponent);
    }

    @NotNull
    protected Font getFontForButton(@NotNull AbstractButton abstractButton, @NotNull AquaUIPainter.Size size) {
        Border border;
        Font font = AquaButtonUI.getDefaultFontPropertyValue(abstractButton);
        if (font == null) {
            font = new Font("Default", 0, 12);
        }
        if ((border = abstractButton.getBorder()) instanceof AquaButtonBorder) {
            AquaButtonBorder aquaButtonBorder = (AquaButtonBorder)border;
            return aquaButtonBorder.getCustomDefaultFont(abstractButton, size, font);
        }
        return AquaUtilControlSize.getFontForSize(font, size);
    }

    @Nullable
    public static Font getDefaultFontPropertyValue(@NotNull AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(DEFAULT_FONT_PROPERTY);
        if (object instanceof Font) {
            return (Font)object;
        }
        return null;
    }

    protected Color getDefaultForegroundColor(AbstractButton abstractButton) {
        boolean bl = abstractButton.getModel().isEnabled();
        Color color = abstractButton.getForeground();
        if (color == null || color instanceof UIResource || !bl) {
            AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(abstractButton);
            if (this.useSelectedForeground(abstractButton)) {
                return aquaAppearance.getColor("alternateSelectedControlText");
            }
            return aquaAppearance.getColor("controlText");
        }
        return color;
    }

    private boolean useSelectedForeground(AbstractButton abstractButton) {
        if (abstractButton instanceof JToggleButton && !(abstractButton instanceof JCheckBox) && !(abstractButton instanceof JRadioButton)) {
            return abstractButton.getModel().isSelected();
        }
        return false;
    }

    private void initializeToolbarStatus(@NotNull AbstractButton abstractButton) {
        Boolean bl = AquaUtils.isOnToolbar(abstractButton);
        abstractButton.putClientProperty(CACHED_TOOLBAR_STATUS_PROPERTY, bl);
    }

    @Override
    public void toolbarStatusChanged(@NotNull JComponent jComponent) {
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Boolean bl = AquaUtils.isOnToolbar(abstractButton);
        if (!bl.equals(object = abstractButton.getClientProperty(CACHED_TOOLBAR_STATUS_PROPERTY))) {
            abstractButton.putClientProperty(CACHED_TOOLBAR_STATUS_PROPERTY, bl);
            this.configure(abstractButton);
        }
    }

    protected void setButtonMarginIfNeeded(AbstractButton abstractButton, Insets insets) {
        Insets insets2 = abstractButton.getMargin();
        if (insets2 == null || insets2 instanceof UIResource) {
            abstractButton.setMargin(insets);
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        AquaButtonListener aquaButtonListener = this.createButtonListener(abstractButton);
        if (aquaButtonListener != null) {
            abstractButton.putClientProperty(this, aquaButtonListener);
            abstractButton.addMouseListener(aquaButtonListener);
            abstractButton.addMouseMotionListener(aquaButtonListener);
            abstractButton.addFocusListener(aquaButtonListener);
            abstractButton.addPropertyChangeListener(aquaButtonListener);
            abstractButton.addChangeListener(aquaButtonListener);
            abstractButton.addActionListener(aquaButtonListener);
            abstractButton.addItemListener(aquaButtonListener);
        }
        if (this.isToolbarSensitive(abstractButton)) {
            AquaUtils.installToolbarSensitivity(abstractButton);
        }
        AquaUtilControlSize.addSizePropertyListener(abstractButton);
        AquaFullKeyboardFocusableHandler.addListener(abstractButton);
        AppearanceManager.installListeners(abstractButton);
    }

    @Override
    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.disconnectColorChooser((AbstractButton)jComponent);
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
        this.removeCachedIcons((AbstractButton)jComponent);
    }

    @Override
    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        AppearanceManager.uninstallListeners(abstractButton);
        AquaButtonListener aquaButtonListener = (AquaButtonListener)abstractButton.getClientProperty(this);
        abstractButton.putClientProperty(this, null);
        if (aquaButtonListener != null) {
            abstractButton.removeItemListener(aquaButtonListener);
            abstractButton.removeMouseListener(aquaButtonListener);
            abstractButton.removeMouseMotionListener(aquaButtonListener);
            abstractButton.removeFocusListener(aquaButtonListener);
            abstractButton.removeChangeListener(aquaButtonListener);
            abstractButton.removePropertyChangeListener(aquaButtonListener);
            abstractButton.removeActionListener(aquaButtonListener);
        }
        AquaUtilControlSize.removeSizePropertyListener(abstractButton);
        AquaFullKeyboardFocusableHandler.removeListener(abstractButton);
        AquaUtils.uninstallToolbarSensitivity(abstractButton);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
        AquaUtilControlSize.uninstallDefaultFont(abstractButton);
    }

    protected void removeCachedIcons(AbstractButton abstractButton) {
        if (abstractButton.getSelectedIcon() instanceof UIResource) {
            abstractButton.setSelectedIcon(null);
        }
        if (AquaButtonUI.getDisabledIcon(abstractButton) instanceof UIResource) {
            abstractButton.setDisabledIcon(null);
        }
        if (AquaButtonUI.getDisabledSelectedIcon(abstractButton) instanceof UIResource) {
            abstractButton.setDisabledSelectedIcon(null);
        }
        if (abstractButton.getPressedIcon() instanceof UIResource) {
            abstractButton.setPressedIcon(null);
        }
        if (abstractButton.getRolloverIcon() instanceof UIResource) {
            abstractButton.setRolloverIcon(null);
        }
        if (abstractButton.getRolloverSelectedIcon() instanceof UIResource) {
            abstractButton.setRolloverSelectedIcon(null);
        }
        abstractButton.putClientProperty(SPECIAL_ICON_PROPERTY, null);
    }

    @Override
    protected AquaButtonListener createButtonListener(AbstractButton abstractButton) {
        return new AquaButtonListener(abstractButton);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    @Override
    public final void paint(Graphics graphics, JComponent jComponent) {
        this.paint((Graphics2D)graphics, (AbstractButton)jComponent);
    }

    protected void paint(@NotNull Graphics2D graphics2D, @NotNull AbstractButton abstractButton) {
        Object object;
        Rectangle rectangle = new Rectangle(abstractButton.getWidth(), abstractButton.getHeight());
        AquaButtonBorder aquaButtonBorder = null;
        if (abstractButton.isBorderPainted() && (object = abstractButton.getBorder()) instanceof AquaButtonBorder) {
            aquaButtonBorder = (AquaButtonBorder)object;
        }
        object = this.getIcon(abstractButton);
        if (aquaButtonBorder != null) {
            aquaButtonBorder.paintButton(graphics2D, abstractButton, (Icon)object, rectangle);
        } else {
            this.paintButtonDefault(graphics2D, abstractButton, (Icon)object, rectangle);
        }
    }

    protected void paintButtonDefault(@NotNull Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @Nullable Icon icon, @NotNull Rectangle rectangle) {
        Serializable serializable;
        ButtonModel buttonModel = abstractButton.getModel();
        boolean bl = AquaButtonUI.isColorWell(abstractButton);
        if (bl && abstractButton.isOpaque()) {
            graphics2D.setColor(abstractButton.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        if (abstractButton.isOpaque()) {
            serializable = abstractButton.getInsets();
            rectangle.x = serializable.left - 2;
            rectangle.y = serializable.top - 2;
            rectangle.width = n - (serializable.right + rectangle.x) + 4;
            rectangle.height = n2 - (serializable.bottom + rectangle.y) + 4;
            if (abstractButton.isContentAreaFilled() || buttonModel.isSelected()) {
                if (buttonModel.isSelected()) {
                    graphics2D.setColor(abstractButton.getBackground().darker());
                } else {
                    graphics2D.setColor(abstractButton.getBackground());
                }
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        serializable = this.getDefaultForegroundColor(abstractButton);
        AquaButtonUI.paintIconAndText(graphics2D, abstractButton, abstractButton.getInsets(), icon, (Color)serializable, rectangle, null);
    }

    public static void paintIconAndText(@NotNull Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @NotNull Insets insets, @Nullable Icon icon, @NotNull Color color, @NotNull Rectangle rectangle, @Nullable Dimension dimension) {
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        String string = AquaButtonUI.layoutAndGetText(graphics2D, abstractButton, insets, rectangle, rectangle2, rectangle3, dimension);
        if (icon != null) {
            AquaButtonUI.paintIcon(graphics2D, abstractButton, icon, rectangle2);
        }
        AquaButtonUI.paintText(graphics2D, abstractButton, rectangle3, color, string);
    }

    @NotNull
    public static String layoutAndGetText(@Nullable Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @NotNull Insets insets, @NotNull Rectangle rectangle, @NotNull Rectangle rectangle2, @NotNull Rectangle rectangle3, @Nullable Dimension dimension) {
        Object object;
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        rectangle3.height = 0;
        rectangle3.width = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        rectangle2.height = 0;
        rectangle2.width = 0;
        rectangle2.y = 0;
        rectangle2.x = 0;
        FontMetrics fontMetrics = null;
        if (graphics2D != null) {
            graphics2D.setFont(abstractButton.getFont());
            fontMetrics = graphics2D.getFontMetrics();
        }
        String string = abstractButton.getText();
        if (dimension == null && (object = abstractButton.getIcon()) != null) {
            dimension = new Dimension(object.getIconWidth(), object.getIconHeight());
        }
        object = AquaUtils.layoutCompoundLabel(abstractButton, fontMetrics, string, dimension, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, string == null ? 0 : abstractButton.getIconTextGap());
        return object;
    }

    public static void paintIcon(Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @NotNull Icon icon, Rectangle rectangle) {
        Graphics2D graphics2D2 = null;
        if (icon.getIconWidth() != rectangle.width || icon.getIconHeight() != rectangle.height) {
            graphics2D = graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.translate(rectangle.x, rectangle.y);
            graphics2D2.scale(rectangle.getWidth() / (double)icon.getIconWidth(), rectangle.getHeight() / (double)icon.getIconHeight());
            graphics2D2.translate(-rectangle.x, -rectangle.y);
        }
        icon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
        if (graphics2D2 != null) {
            graphics2D2.dispose();
        }
    }

    public static void paintText(@NotNull Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @NotNull Rectangle rectangle, @NotNull Color color, @NotNull String string) {
        if (!string.isEmpty()) {
            Object object;
            if (rectangle.width == 0) {
                rectangle.width = 50;
            }
            if ((object = abstractButton.getClientProperty("html")) instanceof View) {
                View view = (View)object;
                view.paint(graphics2D, rectangle);
            } else {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n = AquaMnemonicHandler.isMnemonicHidden() ? -1 : abstractButton.getDisplayedMnemonicIndex();
                graphics2D.setColor(color);
                int n2 = rectangle.x;
                int n3 = rectangle.y + fontMetrics.getAscent();
                JavaSupport.drawStringUnderlineCharAt(abstractButton, graphics2D, string, n, n2, n3);
            }
        }
    }

    @Override
    protected final void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        throw new UnsupportedOperationException("This method should not be used");
    }

    @Override
    protected final void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        throw new UnsupportedOperationException("This method should not be used");
    }

    @Nullable
    protected Icon getIcon(AbstractButton abstractButton) {
        ButtonIconState buttonIconState = AquaButtonUI.getIconState(abstractButton);
        Icon icon = AquaButtonUI.getDefinedIcon(abstractButton, buttonIconState);
        if (icon != null && buttonIconState != ButtonIconState.DEFAULT) {
            return icon;
        }
        AquaButtonIcon aquaButtonIcon = this.getSpecialIcon(abstractButton);
        if (aquaButtonIcon != null) {
            return aquaButtonIcon;
        }
        return icon;
    }

    public static boolean isColorWell(@NotNull AbstractButton abstractButton) {
        AquaUIPainter.ButtonWidget buttonWidget = AquaButtonUI.getButtonWidget(abstractButton);
        return buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL;
    }

    @Nullable
    private static AquaUIPainter.ButtonWidget getButtonWidget(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(LAYOUT_CONFIGURATION_PROPERTY);
        if (object instanceof ButtonLayoutConfiguration) {
            ButtonLayoutConfiguration buttonLayoutConfiguration = (ButtonLayoutConfiguration)object;
            return buttonLayoutConfiguration.getButtonWidget();
        }
        return null;
    }

    @NotNull
    public static ButtonIconState getIconState(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            if (buttonModel.isSelected()) {
                return ButtonIconState.DISABLED_SELECTED;
            }
            return ButtonIconState.DISABLED;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            return ButtonIconState.PRESSED;
        }
        if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            if (buttonModel.isSelected()) {
                return ButtonIconState.ROLLOVER_SELECTED;
            }
            return ButtonIconState.ROLLOVER;
        }
        if (buttonModel.isSelected()) {
            return ButtonIconState.SELECTED;
        }
        return ButtonIconState.DEFAULT;
    }

    @Nullable
    public static Icon getDefinedIcon(AbstractButton abstractButton, ButtonIconState buttonIconState) {
        switch (buttonIconState) {
            case DISABLED: {
                return AquaButtonUI.getDisabledIcon(abstractButton);
            }
            case DISABLED_SELECTED: {
                return AquaButtonUI.getDisabledSelectedIcon(abstractButton);
            }
            case PRESSED: {
                return AquaButtonUI.getIconForPressedState(abstractButton);
            }
            case ROLLOVER_SELECTED: {
                return AquaButtonUI.getIconForRolloverSelectedState(abstractButton);
            }
            case ROLLOVER: {
                return abstractButton.getRolloverIcon();
            }
            case SELECTED: {
                return abstractButton.getSelectedIcon();
            }
        }
        return abstractButton.getIcon();
    }

    @Nullable
    private static Icon getIconForPressedState(@NotNull AbstractButton abstractButton) {
        Icon icon = abstractButton.getPressedIcon();
        return icon != null ? icon : abstractButton.getSelectedIcon();
    }

    @Nullable
    private static Icon getIconForRolloverSelectedState(@NotNull AbstractButton abstractButton) {
        Icon icon = abstractButton.getRolloverSelectedIcon();
        return icon != null ? icon : abstractButton.getSelectedIcon();
    }

    @Nullable
    protected AquaButtonIcon getSpecialIcon(@NotNull AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(SPECIAL_ICON_PROPERTY);
        if (object instanceof AquaButtonIcon) {
            return (AquaButtonIcon)object;
        }
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder aquaButtonBorder = (AquaButtonBorder)border;
            boolean bl = this.determineTemplateIconStatus(abstractButton);
            AquaButtonIcon aquaButtonIcon = aquaButtonBorder.createIcon(abstractButton, bl);
            abstractButton.putClientProperty(SPECIAL_ICON_PROPERTY, aquaButtonIcon);
            return aquaButtonIcon;
        }
        return null;
    }

    @NotNull
    public Icon createDisabledIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        AquaButtonIcon aquaButtonIcon = this.getSpecialIcon(abstractButton);
        if (aquaButtonIcon != null) {
            return aquaButtonIcon;
        }
        return this.createDefaultDisabledIcon(imageIcon);
    }

    @NotNull
    public Icon createDisabledSelectedIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        AquaButtonIcon aquaButtonIcon = this.getSpecialIcon(abstractButton);
        if (aquaButtonIcon != null) {
            return aquaButtonIcon;
        }
        return this.createDefaultDisabledIcon(imageIcon);
    }

    @NotNull
    protected ImageIcon createDefaultDisabledIcon(ImageIcon imageIcon) {
        return new ImageIconUIResource(AquaImageFactory.getProcessedImage(imageIcon.getImage(), AquaImageFactory.LIGHTEN_FOR_DISABLED));
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.paint(graphics, (JComponent)abstractButton);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            object = (AquaButtonBorder)border;
            dimension = ((AquaButtonBorder)object).getPreferredButtonSize(abstractButton);
        } else {
            dimension = this.getPreferredSize(abstractButton);
        }
        object = (View)jComponent.getClientProperty("html");
        if (object != null) {
            dimension.width = (int)((float)dimension.width - (((View)object).getPreferredSpan(0) - ((View)object).getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder aquaButtonBorder = (AquaButtonBorder)border;
            return aquaButtonBorder.getPreferredButtonSize(abstractButton);
        }
        return AquaButtonUI.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap(), null);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void toggleButtonStateChanged(@NotNull AbstractButton abstractButton) {
        JToggleButton jToggleButton = SegmentedControlModel.getLeftAdjacentButton(abstractButton);
        if (jToggleButton != null) {
            jToggleButton.repaint();
        }
    }

    public boolean isToolbar(@NotNull AbstractButton abstractButton) {
        return Boolean.TRUE.equals(abstractButton.getClientProperty(CACHED_TOOLBAR_STATUS_PROPERTY));
    }

    private boolean isToolbarSensitive(@NotNull AbstractButton abstractButton) {
        return abstractButton instanceof JButton || abstractButton instanceof JToggleButton && !(abstractButton instanceof JCheckBox) && !(abstractButton instanceof JRadioButton);
    }

    protected Object willHandleButtonPress(AbstractButton abstractButton) {
        return null;
    }

    protected void didHandleButtonPress(AbstractButton abstractButton, Object object) {
    }

    protected void disconnectColorChooser(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(COLOR_CHOOSER_OWNER_PROPERTY);
        if (object instanceof SharedColorChooserOwner) {
            SharedColorChooserOwner sharedColorChooserOwner = (SharedColorChooserOwner)object;
            AquaSharedColorChooser.disconnect(sharedColorChooserOwner);
            abstractButton.putClientProperty(COLOR_CHOOSER_OWNER_PROPERTY, null);
        }
    }

    protected void toggleColorChooser(final AbstractButton abstractButton) {
        boolean bl;
        Object object = abstractButton.getClientProperty(COLOR_CHOOSER_OWNER_PROPERTY);
        if (object instanceof SharedColorChooserOwner) {
            SharedColorChooserOwner sharedColorChooserOwner = (SharedColorChooserOwner)object;
            AquaSharedColorChooser.disconnect(sharedColorChooserOwner);
            abstractButton.setSelected(false);
            abstractButton.putClientProperty(COLOR_CHOOSER_OWNER_PROPERTY, null);
            return;
        }
        SharedColorChooserOwner sharedColorChooserOwner = new SharedColorChooserOwner(){

            @Override
            public void applyColor(Color color) {
                abstractButton.setBackground(color);
            }

            @Override
            public void disconnected() {
                abstractButton.setSelected(false);
                abstractButton.putClientProperty(AquaButtonUI.COLOR_CHOOSER_OWNER_PROPERTY, null);
            }
        };
        Color color = abstractButton.getBackground();
        if (AquaSharedColorChooser.connect(sharedColorChooserOwner, color, bl = Boolean.TRUE.equals(abstractButton.getClientProperty(ENABLE_TRANSLUCENT_COLORS_KEY)))) {
            abstractButton.putClientProperty(COLOR_CHOOSER_OWNER_PROPERTY, sharedColorChooserOwner);
            abstractButton.setSelected(true);
        }
    }

    public static Icon getDisabledIcon(AbstractButton abstractButton) {
        boolean bl = AquaLookAndFeel.suppressCreationOfDisabledButtonIcons;
        AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = true;
        try {
            Icon icon = abstractButton.getDisabledIcon();
            return icon;
        }
        finally {
            AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = bl;
        }
    }

    public static Icon getDisabledSelectedIcon(AbstractButton abstractButton) {
        boolean bl = AquaLookAndFeel.suppressCreationOfDisabledButtonIcons;
        AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = true;
        try {
            Icon icon = abstractButton.getDisabledSelectedIcon();
            return icon;
        }
        finally {
            AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = bl;
        }
    }

    @Nullable
    public static Dimension getPreferredButtonSize(@NotNull AbstractButton abstractButton, int n, @Nullable Dimension dimension) {
        Object object;
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        if (dimension == null && (object = abstractButton.getIcon()) != null) {
            dimension = new Dimension(object.getIconWidth(), object.getIconHeight());
        }
        object = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        AquaUtils.layoutCompoundLabel(abstractButton, fontMetrics, (String)object, dimension, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, object == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        return rectangle4.getSize();
    }

    public static Dimension getPreferredContentSize(AbstractButton abstractButton, Font font, int n) {
        Icon icon = abstractButton.getIcon();
        Dimension dimension = icon != null ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : null;
        String string = abstractButton.getText();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        AquaUtils.layoutCompoundLabel(abstractButton, fontMetrics, string, dimension, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        return rectangle4.getSize();
    }

    class AquaButtonListener
    extends BasicButtonListener
    implements ActionListener,
    ItemListener {
        protected AbstractButton b;

        public AquaButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            this.b = abstractButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionListener[] actionListenerArray;
            if (AquaButtonUI.isColorWell(this.b) && (actionListenerArray = this.b.getActionListeners()).length == 1) {
                AquaButtonUI.this.toggleColorChooser(this.b);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            AquaButtonUI.this.toggleButtonStateChanged(this.b);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ((Component)focusEvent.getSource()).repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ((Component)focusEvent.getSource()).repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Border border;
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if ("icon".equals(string) || "text".equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if (string != null && !string.contains(".") && string.endsWith("Icon")) {
                AquaButtonUI.this.updateTemplateIconStatus(this.b);
                return;
            }
            if (AquaButtonUI.BUTTON_TYPE.equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if (AquaButtonUI.SEGMENTED_BUTTON_POSITION.equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if ("verticalAlignment".equals(string) || "verticalTextPosition".equals(string) || "font".equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if ("componentOrientation".equals(string) && (border = this.b.getBorder()) instanceof AquaSegmentedButtonBorder) {
                AquaButtonUI.this.configure(this.b);
            }
            if ("ancestor".equals(string) && !this.b.isDisplayable()) {
                AquaButtonUI.this.disconnectColorChooser(this.b);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (abstractButton = (AbstractButton)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
                Object object = AquaButtonUI.this.willHandleButtonPress(abstractButton);
                super.mousePressed(mouseEvent);
                AquaButtonUI.this.didHandleButtonPress(abstractButton, object);
            }
        }
    }

    static enum ButtonIconState {
        DISABLED,
        DISABLED_SELECTED,
        PRESSED,
        ROLLOVER,
        ROLLOVER_SELECTED,
        SELECTED,
        DEFAULT;

    }
}

