/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.videolan.libvlc.LibVLCFactory;
import org.videolan.libvlc.MediaFactory;
import org.videolan.libvlc.interfaces.IComponentFactory;
import org.videolan.libvlc.interfaces.ILibVLCFactory;
import org.videolan.libvlc.interfaces.IMediaFactory;

public class FactoryManager {
    private static Map<String, IComponentFactory> factories = new HashMap<String, IComponentFactory>();

    public static void registerFactory(String factoryId, IComponentFactory factory) {
        factories.put(factoryId, factory);
    }

    public static IComponentFactory getFactory(String factoryId) {
        IComponentFactory factory = factories.get(factoryId);
        if (factory == null) {
            Log.e((String)"FactoryManager", (String)"Factory doesn't exist. Falling back to hard coded one");
            if (factoryId.equals(IMediaFactory.factoryId)) {
                FactoryManager.registerFactory(IMediaFactory.factoryId, new MediaFactory());
            }
            if (factoryId.equals(ILibVLCFactory.factoryId)) {
                FactoryManager.registerFactory(ILibVLCFactory.factoryId, new LibVLCFactory());
            }
            factory = factories.get(factoryId);
        }
        return factory;
    }
}

