/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc.util;

import android.app.Activity;
import android.app.Presentation;
import android.content.Context;
import android.content.DialogInterface;
import android.media.MediaRouter;
import android.os.Bundle;
import android.os.Handler;
import android.view.Display;
import android.view.SurfaceView;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import org.videolan.R;
import org.videolan.libvlc.RendererItem;

public class DisplayManager {
    private static final String TAG = "VLC/DisplayManager";
    private Activity mActivity;
    private LiveData<RendererItem> mSelectedRenderer;
    private RendererItem mRendererItem;
    private boolean mTextureView;
    private MediaRouter mMediaRouter;
    private MediaRouter.SimpleCallback mMediaRouterCallback;
    private SecondaryDisplay mPresentation;
    private DisplayType mDisplayType;
    private int mPresentationId = -1;
    private Observer<RendererItem> mRendererObs = new Observer<RendererItem>(){

        public void onChanged(RendererItem rendererItem) {
            if (DisplayManager.this.mRendererItem != rendererItem) {
                DisplayManager.this.mRendererItem = rendererItem;
                DisplayManager.this.updateDisplayType();
            }
        }
    };
    private DialogInterface.OnDismissListener mOnDismissListener = new DialogInterface.OnDismissListener(){

        public void onDismiss(DialogInterface dialog) {
            if (dialog == DisplayManager.this.mPresentation) {
                DisplayManager.this.mPresentation = null;
                DisplayManager.this.mPresentationId = -1;
            }
        }
    };

    public DisplayManager(@NonNull Activity activity, @Nullable LiveData<RendererItem> selectedRender, boolean textureView, boolean cloneMode, boolean benchmark) {
        this.mActivity = activity;
        this.mSelectedRenderer = selectedRender;
        this.mMediaRouter = (MediaRouter)ContextCompat.getSystemService((Context)activity.getApplicationContext(), MediaRouter.class);
        this.mTextureView = textureView;
        SecondaryDisplay secondaryDisplay = this.mPresentation = !cloneMode && !benchmark && selectedRender != null && selectedRender.getValue() == null ? this.createPresentation() : null;
        if (this.mSelectedRenderer != null) {
            this.mRendererItem = (RendererItem)this.mSelectedRenderer.getValue();
            this.mSelectedRenderer.observeForever(this.mRendererObs);
        }
        this.mDisplayType = benchmark ? DisplayType.PRIMARY : this.getCurrentType();
    }

    public boolean isPrimary() {
        return this.mDisplayType == DisplayType.PRIMARY;
    }

    public boolean isSecondary() {
        return this.mDisplayType == DisplayType.PRESENTATION;
    }

    public boolean isOnRenderer() {
        return this.mDisplayType == DisplayType.RENDERER;
    }

    public void release() {
        if (this.mPresentation != null) {
            this.mPresentation.dismiss();
            this.mPresentation = null;
        }
        if (this.mSelectedRenderer != null) {
            this.mSelectedRenderer.removeObserver(this.mRendererObs);
        }
    }

    private void updateDisplayType() {
        if (this.mDisplayType != this.getCurrentType()) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    DisplayManager.this.mActivity.recreate();
                }
            }, 100L);
        }
    }

    private DisplayType getCurrentType() {
        if (this.mPresentationId != -1) {
            return DisplayType.PRESENTATION;
        }
        if (this.mRendererItem != null) {
            return DisplayType.RENDERER;
        }
        return DisplayType.PRIMARY;
    }

    @Nullable
    public SecondaryDisplay getPresentation() {
        return this.mPresentation;
    }

    @Nullable
    public DisplayType getDisplayType() {
        return this.mDisplayType;
    }

    private SecondaryDisplay createPresentation() {
        Display presentationDisplay;
        if (this.mMediaRouter == null) {
            return null;
        }
        MediaRouter.RouteInfo route = this.mMediaRouter.getSelectedRoute(2);
        Display display = presentationDisplay = route != null ? route.getPresentationDisplay() : null;
        if (presentationDisplay != null) {
            SecondaryDisplay presentation = new SecondaryDisplay((Context)this.mActivity, presentationDisplay);
            presentation.setOnDismissListener(this.mOnDismissListener);
            try {
                presentation.show();
                this.mPresentationId = presentationDisplay.getDisplayId();
                return presentation;
            }
            catch (WindowManager.InvalidDisplayException ex) {
                this.mPresentationId = -1;
            }
        }
        return null;
    }

    public boolean setMediaRouterCallback() {
        if (this.mMediaRouter == null || this.mMediaRouterCallback != null) {
            return false;
        }
        this.mMediaRouterCallback = new MediaRouter.SimpleCallback(){

            public void onRoutePresentationDisplayChanged(MediaRouter router, MediaRouter.RouteInfo info) {
                int newDisplayId;
                int n = newDisplayId = info.getPresentationDisplay() != null ? info.getPresentationDisplay().getDisplayId() : -1;
                if (newDisplayId == DisplayManager.this.mPresentationId) {
                    return;
                }
                DisplayManager.this.mPresentationId = newDisplayId;
                if (newDisplayId == -1) {
                    DisplayManager.this.removePresentation();
                } else {
                    DisplayManager.this.updateDisplayType();
                }
            }
        };
        this.mMediaRouter.addCallback(2, (MediaRouter.Callback)this.mMediaRouterCallback);
        return true;
    }

    public void removeMediaRouterCallback() {
        if (this.mMediaRouter != null) {
            this.mMediaRouter.removeCallback((MediaRouter.Callback)this.mMediaRouterCallback);
        }
        this.mMediaRouterCallback = null;
    }

    private void removePresentation() {
        if (this.mMediaRouter == null) {
            return;
        }
        if (this.mPresentation != null) {
            this.mPresentation.dismiss();
            this.mPresentation = null;
        }
        this.updateDisplayType();
    }

    public class SecondaryDisplay
    extends Presentation {
        public static final String TAG = "VLC/SecondaryDisplay";
        private FrameLayout mSurfaceFrame;
        private SurfaceView mSurfaceView;
        private SurfaceView mSubtitlesSurfaceView;

        public SecondaryDisplay(Context outerContext, Display display) {
            super(outerContext, display);
        }

        public SecondaryDisplay(Context outerContext, Display display, int theme) {
            super(outerContext, display, theme);
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setContentView(R.layout.player_remote);
            this.mSurfaceFrame = (FrameLayout)this.findViewById(R.id.remote_player_surface_frame);
            this.mSurfaceView = (SurfaceView)this.mSurfaceFrame.findViewById(R.id.remote_player_surface);
            this.mSubtitlesSurfaceView = (SurfaceView)this.mSurfaceFrame.findViewById(R.id.remote_subtitles_surface);
            this.mSubtitlesSurfaceView.setZOrderMediaOverlay(true);
            this.mSubtitlesSurfaceView.getHolder().setFormat(-3);
        }

        public FrameLayout getSurfaceFrame() {
            return this.mSurfaceFrame;
        }

        public SurfaceView getSurfaceView() {
            return this.mSurfaceView;
        }

        public SurfaceView getSubtitlesSurfaceView() {
            return this.mSubtitlesSurfaceView;
        }
    }

    public static enum DisplayType {
        PRIMARY,
        PRESENTATION,
        RENDERER;

    }
}

