/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import androidx.collection.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.RendererItem;
import org.videolan.libvlc.VLCEvent;
import org.videolan.libvlc.VLCObject;

public class RendererDiscoverer
extends VLCObject<Event> {
    private static final String TAG = "LibVLC/RendererDiscoverer";
    final List<RendererItem> mRenderers = new ArrayList<RendererItem>();
    private final LongSparseArray<RendererItem> index = new LongSparseArray();

    private static RendererItem createItemFromNative(String name, String type, String iconUrl, int flags, long ref) {
        return new RendererItem(name, type, iconUrl, flags, ref);
    }

    public RendererDiscoverer(LibVLC libVLC, String name) {
        super(libVLC);
        this.nativeNew(libVLC, name);
    }

    public boolean start() {
        if (this.isReleased()) {
            throw new IllegalStateException("MediaDiscoverer is released");
        }
        return this.nativeStart();
    }

    public void stop() {
        if (this.isReleased()) {
            throw new IllegalStateException("MediaDiscoverer is released");
        }
        this.setEventListener((EventListener)null);
        this.nativeStop();
        this.release();
    }

    public void setEventListener(EventListener listener) {
        super.setEventListener(listener);
    }

    public static Description[] list(LibVLC libVlc) {
        return RendererDiscoverer.nativeList(libVlc);
    }

    @Override
    protected Event onEventNative(int eventType, long arg1, long arg2, float argf1) {
        switch (eventType) {
            case 1282: {
                return new Event(eventType, arg1, this.insertItemFromEvent(arg1));
            }
            case 1283: {
                return new Event(eventType, arg1, this.removeItemFromEvent(arg1));
            }
        }
        return null;
    }

    private synchronized RendererItem insertItemFromEvent(long arg1) {
        RendererItem item = this.nativeNewItem(arg1);
        this.index.put(arg1, (Object)item);
        this.mRenderers.add(item);
        return item;
    }

    private synchronized RendererItem removeItemFromEvent(long arg1) {
        RendererItem item = (RendererItem)this.index.get(arg1);
        if (item != null) {
            this.index.remove(arg1);
            this.mRenderers.remove(item);
            item.release();
        }
        return item;
    }

    @Override
    protected void onReleaseNative() {
        for (RendererItem item : this.mRenderers) {
            item.release();
        }
        this.mRenderers.clear();
        this.nativeRelease();
    }

    private static Description createDescriptionFromNative(String name, String longName) {
        return new Description(name, longName);
    }

    private native void nativeNew(LibVLC var1, String var2);

    private native void nativeRelease();

    private native boolean nativeStart();

    private native void nativeStop();

    private static native Description[] nativeList(LibVLC var0);

    private native RendererItem nativeNewItem(long var1);

    public static class Description {
        public final String name;
        final String longName;

        private Description(String name, String longName) {
            this.name = name;
            this.longName = longName;
        }
    }

    public static interface EventListener
    extends VLCEvent.Listener<Event> {
    }

    public static class Event
    extends VLCEvent {
        public static final int ItemAdded = 1282;
        public static final int ItemDeleted = 1283;
        private final RendererItem item;

        protected Event(int type, long nativeHolder, RendererItem item) {
            super(type, nativeHolder);
            this.item = item;
            item.retain();
        }

        public RendererItem getItem() {
            return this.item;
        }

        @Override
        void release() {
            this.item.release();
            super.release();
        }
    }
}

