/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool;

import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ArgumentValidation;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.Listener;

public class ConcurrentPool<T>
implements PoolService<T> {
    private final ConcurrentCollection<T> available;
    private final Semaphore takeSemaphore;
    private final PoolObjectFactory<T> poolObjectFactory;
    private final Listener<T> listener;
    private final int initialSize;
    private final int maxSize;
    private final AtomicInteger createdTotal;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public ConcurrentPool(ConcurrentCollection<T> available, PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair) {
        this(available, poolObjectFactory, initialSize, maxSize, fair, null);
    }

    public ConcurrentPool(ConcurrentCollection<T> available, PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair, Listener<T> listener) {
        ArgumentValidation.forbidIllegalArgument(initialSize < 0);
        ArgumentValidation.forbidIllegalArgument(maxSize < 1);
        ArgumentValidation.forbidIllegalArgument(maxSize < initialSize);
        this.available = Objects.requireNonNull(available);
        this.poolObjectFactory = Objects.requireNonNull(poolObjectFactory);
        this.listener = listener;
        this.initialSize = initialSize;
        this.maxSize = maxSize;
        this.takeSemaphore = new Semaphore(maxSize, fair);
        this.createdTotal = new AtomicInteger(0);
        this.addInitialObjects();
    }

    private void addInitialObjects() {
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.available.offerLast(this.create());
                this.createdTotal.incrementAndGet();
            }
        }
        catch (Error | RuntimeException e) {
            this.drainCreated();
            throw e;
        }
    }

    private T create() {
        T object = this.poolObjectFactory.create();
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    @Override
    public T take() {
        try {
            this.takeSemaphore.acquire();
            return this.newObject();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T takeUninterruptibly() {
        this.takeSemaphore.acquireUninterruptibly();
        return this.newObject();
    }

    @Override
    public T tryTake(long timeout, TimeUnit unit) {
        try {
            if (!this.takeSemaphore.tryAcquire(timeout, unit)) {
                return null;
            }
            return this.newObject();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T tryTake() {
        if (!this.takeSemaphore.tryAcquire()) {
            return null;
        }
        return this.newObject();
    }

    private T newObject() {
        if (this.isTerminated()) {
            this.takeSemaphore.release();
            return null;
        }
        T object = this.available.pollFirst();
        object = this.prepareToTake(object);
        if (this.listener != null) {
            this.listener.onTake(object);
        }
        return object;
    }

    @Override
    public void restore(T object) {
        this.restore(object, true);
    }

    @Override
    public void restore(T object, boolean valid) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.isTerminated()) {
            this.createdTotal.decrementAndGet();
            this.poolObjectFactory.destroy(object);
            return;
        }
        if (this.listener != null) {
            this.listener.onRestore(object);
        }
        if ((object = this.prepareToRestore(object, valid)) != null) {
            this.available.offerFirst(object);
        }
        this.takeSemaphore.release();
    }

    private T prepareToTake(T object) {
        try {
            if (object == null) {
                this.createdTotal.incrementAndGet();
                object = this.create();
            } else {
                boolean ready = false;
                try {
                    ready = this.poolObjectFactory.readyToTake(object);
                }
                finally {
                    if (!ready) {
                        this.poolObjectFactory.destroy(object);
                    }
                }
                if (!ready) {
                    object = this.create();
                }
            }
            return object;
        }
        catch (Error | RuntimeException e) {
            this.recoverInnerState(1);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T prepareToRestore(T object, boolean valid) {
        try {
            boolean ready = false;
            try {
                ready = valid && this.poolObjectFactory.readyToRestore(object);
            }
            finally {
                if (!ready) {
                    this.poolObjectFactory.destroy(object);
                }
            }
            if (!ready) {
                this.createdTotal.decrementAndGet();
                object = null;
            }
            return object;
        }
        catch (Error | RuntimeException e) {
            this.recoverInnerState(1);
            throw e;
        }
    }

    private void recoverInnerState(int permits) {
        this.createdTotal.addAndGet(-permits);
        this.takeSemaphore.release(permits);
    }

    @Override
    public Listener<T> listener() {
        return this.listener;
    }

    @Override
    public int taken() {
        return this.isTerminated() ? this.createdTotal() : this.calculateTaken();
    }

    private int calculateTaken() {
        return this.maxSize() - this.remainingCapacity();
    }

    @Override
    public int remainingCreated() {
        return this.isTerminated() ? 0 : this.createdTotal() - this.calculateTaken();
    }

    @Override
    public int drainCreated() {
        return this.reduceCreatedTo(0, true);
    }

    public String toString() {
        return super.toString() + (this.isTerminated() ? "[terminated]" : "[remainingCreated = " + this.remainingCreated() + "]");
    }

    @Override
    public int createdTotal() {
        return this.createdTotal.get();
    }

    @Override
    public int remainingCapacity() {
        return this.isTerminated() ? 0 : this.takeSemaphore.availablePermits();
    }

    @Override
    public int initialSize() {
        return this.initialSize;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public int reduceCreatedBy(int reduceBy, boolean ignoreInitialSize) {
        ArgumentValidation.forbidIllegalArgument(reduceBy < 0);
        for (int cnt = 0; cnt < reduceBy; ++cnt) {
            if (this.reduceByOne(ignoreInitialSize)) continue;
            return cnt;
        }
        return reduceBy;
    }

    @Override
    public int reduceCreatedTo(int reduceTo, boolean ignoreInitialSize) {
        ArgumentValidation.forbidIllegalArgument(reduceTo < 0);
        int cnt = 0;
        while (this.createdTotal() > reduceTo) {
            if (!this.reduceByOne(ignoreInitialSize)) {
                return cnt;
            }
            ++cnt;
        }
        return cnt;
    }

    private boolean reduceByOne(boolean ignoreInitialSize) {
        int newTotal = this.createdTotal.decrementAndGet();
        if (!ignoreInitialSize && newTotal < this.initialSize) {
            this.createdTotal.incrementAndGet();
            return false;
        }
        T object = this.available.pollLast();
        if (object == null) {
            this.createdTotal.incrementAndGet();
            return false;
        }
        this.poolObjectFactory.destroy(object);
        return true;
    }

    @Override
    public void terminate() {
        if (this.terminated.getAndSet(true)) {
            return;
        }
        this.takeSemaphore.release(this.takeSemaphore.getQueueLength() + 4096);
        this.drainCreated();
    }

    @Override
    public void close() {
        this.terminate();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    @Override
    public boolean isFair() {
        return this.takeSemaphore.isFair();
    }
}

