/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.gf.model.GFModelParser;
import org.verapdf.metadata.fixer.gf.GFMetadataFixerImpl;
import org.verapdf.pdfa.AbstractFoundry;
import org.verapdf.pdfa.MetadataFixer;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.VeraPDFFoundry;
import org.verapdf.pdfa.flavours.PDFAFlavour;

class VeraFoundry
extends AbstractFoundry {
    private static final ReleaseDetails greenfieldDetails = ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/validation-model.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/foundry#verapdf");
    private static final ComponentDetails details = Components.veraDetails((URI)id, (String)"VeraPDF Foundry", (String)greenfieldDetails.getVersion(), (String)"veraPDF greenfield foundry instance.");
    private static final VeraPDFFoundry instance = new VeraFoundry();

    private VeraFoundry() {
    }

    public ComponentDetails getDetails() {
        return details;
    }

    public PDFAParser createParser(InputStream pdfStream) throws ModelParsingException, EncryptedPdfException {
        return this.createParser(pdfStream, PDFAFlavour.NO_FLAVOUR);
    }

    public PDFAParser createParser(InputStream pdfStream, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfStream, flavour);
    }

    public PDFAParser createParser(File file, PDFAFlavour pdfaFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(file, pdfaFlavour);
    }

    public PDFAParser createParser(File file) throws ModelParsingException, EncryptedPdfException {
        return this.createParser(file, PDFAFlavour.NO_FLAVOUR);
    }

    public MetadataFixer createMetadataFixer() {
        return new GFMetadataFixerImpl();
    }

    public String getParserId() {
        return "GreenField";
    }

    public static ReleaseDetails getReleaseDetails() {
        return greenfieldDetails;
    }

    static VeraPDFFoundry getInstance() {
        return instance;
    }
}

