/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.tools;

import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.operators.TransparencyGraphicsState;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.colors.GFPDColorSpace;
import org.verapdf.gf.model.impl.pd.font.GFPDFont;
import org.verapdf.gf.model.impl.pd.font.GFPDType3Font;
import org.verapdf.gf.model.impl.pd.images.GFPDXForm;
import org.verapdf.gf.model.impl.pd.images.GFPDXImage;
import org.verapdf.gf.model.impl.pd.images.GFPDXObject;
import org.verapdf.gf.model.impl.pd.patterns.GFPDTilingPattern;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.pd.font.Encoding;

public class TransparencyBehaviour {
    private boolean isFillCheck = false;
    private boolean isStrokeCheck = false;
    private boolean isXObjectCheck = false;
    private boolean isColorSpaceCheck = false;
    private boolean isFontCheck = false;

    private TransparencyBehaviour() {
    }

    public static TransparencyBehaviour createFillInstance() {
        TransparencyBehaviour tb = new TransparencyBehaviour();
        tb.isFillCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillXObjectInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillInstance();
        tb.isXObjectCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillColorSpaceInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillInstance();
        tb.isColorSpaceCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillColorSpaceFontInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillColorSpaceInstance();
        tb.isFontCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createStrokeColorSpaceInstance() {
        TransparencyBehaviour tb = new TransparencyBehaviour();
        tb.isStrokeCheck = true;
        tb.isColorSpaceCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createStrokeColorSpaceFontInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createStrokeColorSpaceInstance();
        tb.isFontCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillStrokeColorSpaceInstance() {
        TransparencyBehaviour tb = new TransparencyBehaviour();
        tb.isFillCheck = true;
        tb.isStrokeCheck = true;
        tb.isColorSpaceCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillStrokeColorSpaceFontInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillStrokeColorSpaceInstance();
        tb.isFontCheck = true;
        return tb;
    }

    public boolean containsTransparency(TransparencyGraphicsState transparencyGraphicsState) {
        if (TransparencyBehaviour.baseCheck(transparencyGraphicsState)) {
            return true;
        }
        if (this.isFillCheck && transparencyGraphicsState.getCa_ns() < 1.0f) {
            return true;
        }
        if (this.isStrokeCheck && transparencyGraphicsState.getCa() < 1.0f) {
            return true;
        }
        if (this.isXObjectCheck && TransparencyBehaviour.xObjectContainsTransparency(transparencyGraphicsState.getVeraXObject())) {
            return true;
        }
        if (this.isColorSpaceCheck && this.colorSpaceCheck(transparencyGraphicsState)) {
            return true;
        }
        return this.isFontCheck && TransparencyBehaviour.fontCheck(transparencyGraphicsState);
    }

    private static boolean fontCheck(TransparencyGraphicsState graphicState) {
        GFPDType3Font type3Font;
        Encoding encoding;
        GFPDFont font = graphicState.getVeraFont();
        if (font instanceof GFPDType3Font && (encoding = (type3Font = (GFPDType3Font)font).getEncodingMapping()) != null) {
            boolean result = false;
            Map<String, PDContentStream> charProcStreams = type3Font.getCharProcStreams();
            for (byte glyphCode : graphicState.getCharCodes()) {
                String glyphName = encoding.getName((int)glyphCode);
                GFPDContentStream glyphStream = (GFPDContentStream)charProcStreams.get(glyphName);
                if (glyphStream == null) continue;
                result |= glyphStream.isContainsTransparency();
            }
            return result;
        }
        return false;
    }

    private boolean colorSpaceCheck(TransparencyGraphicsState graphicState) {
        GFPDColorSpace strokeCS;
        GFPDColorSpace fillCS;
        if (this.isFillCheck && (fillCS = graphicState.getVeraFillColorSpace()) instanceof GFPDTilingPattern && ((GFPDTilingPattern)fillCS).isContainsTransparency()) {
            return true;
        }
        return this.isStrokeCheck && (strokeCS = graphicState.getVeraStrokeColorSpace()) instanceof GFPDTilingPattern && ((GFPDTilingPattern)strokeCS).isContainsTransparency();
    }

    private static boolean baseCheck(TransparencyGraphicsState graphicState) {
        COSObject sMask = graphicState.getSMask();
        if (sMask != null && sMask.getType().isDictionaryBased()) {
            return true;
        }
        COSObject bm = graphicState.getBm();
        if (bm != null) {
            if (bm.getType() == COSObjType.COS_NAME) {
                if (!ASAtom.NORMAL.equals((Object)bm.getName())) {
                    return true;
                }
            } else if (bm.getType() == COSObjType.COS_ARRAY) {
                COSArray bmArray = (COSArray)bm.getDirectBase();
                if (bmArray.size() != 1) {
                    return true;
                }
                COSObject bmValue = bmArray.at(0);
                if (bmValue == null || bmValue.getType() != COSObjType.COS_NAME || ASAtom.NORMAL.equals((Object)bmValue.getName())) {
                    return true;
                }
            } else {
                return !bm.empty() && bm.getType() != COSObjType.COS_NULL;
            }
        }
        return false;
    }

    private static boolean xObjectContainsTransparency(GFPDXObject xobj) {
        if (xobj instanceof GFPDXForm) {
            return ((GFPDXForm)xobj).containsTransparency();
        }
        if (xobj instanceof GFPDXImage) {
            return ((GFPDXImage)xobj).containsTransparency();
        }
        return false;
    }
}

