/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.containers.StaticContainers;
import org.verapdf.model.impl.pb.cos.PBCosUnicodeName;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDColorSpace;
import org.verapdf.model.impl.pb.pd.functions.PBoxPDFunction;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDSeparation
extends PBoxPDColorSpace
implements org.verapdf.model.pdlayer.PDSeparation {
    public static final String SEPARATION_TYPE = "PDSeparation";
    public static final String TINT_TRANSFORM = "tintTransform";
    public static final String ALTERNATE = "alternate";
    public static final String COLORANT_NAME = "colorantName";
    public static final int COLORANT_NAME_POSITION = 1;
    private final PDDocument document;
    private final PDFAFlavour flavour;
    private COSArray colorSpace;

    public PBoxPDSeparation(PDSeparation simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super((PDColorSpace)simplePDObject, SEPARATION_TYPE);
        this.document = document;
        this.flavour = flavour;
        this.colorSpace = (COSArray)simplePDObject.getCOSObject();
        if (StaticContainers.getSeparations().containsKey(simplePDObject.getColorantName())) {
            StaticContainers.getSeparations().get(simplePDObject.getColorantName()).add(this);
        } else {
            ArrayList<PBoxPDSeparation> separationList = new ArrayList<PBoxPDSeparation>();
            separationList.add(this);
            StaticContainers.getSeparations().put(simplePDObject.getColorantName(), separationList);
        }
    }

    public String getname() {
        COSBase object;
        COSArray array = (COSArray)this.simplePDObject.getCOSObject();
        if (array.size() > 1 && (object = array.getObject(1)) instanceof COSName) {
            return object.toString();
        }
        return null;
    }

    public Boolean getareTintAndAlternateConsistent() {
        String name = ((PDSeparation)this.simplePDObject).getColorantName();
        if (StaticContainers.getInconsistentSeparations().contains(name)) {
            return Boolean.FALSE;
        }
        if (StaticContainers.getSeparations().get(name).size() > 1) {
            for (PBoxPDSeparation pBoxPDSeparation : StaticContainers.getSeparations().get(name)) {
                if (((java.lang.Object)((java.lang.Object)pBoxPDSeparation)).equals((java.lang.Object)this)) continue;
                COSArray toCompare = pBoxPDSeparation.colorSpace;
                COSBase alternateSpaceToCompare = PBoxPDSeparation.unwrapObject(toCompare.get(2));
                COSBase tintTransformToCompare = PBoxPDSeparation.unwrapObject(toCompare.get(3));
                COSBase alternateSpaceCurrent = PBoxPDSeparation.unwrapObject(this.colorSpace.get(2));
                COSBase tintTransformCurrent = PBoxPDSeparation.unwrapObject(this.colorSpace.get(3));
                if (alternateSpaceToCompare.equals(alternateSpaceCurrent) && tintTransformToCompare.equals(tintTransformCurrent)) continue;
                StaticContainers.getInconsistentSeparations().add(name);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private static COSBase unwrapObject(COSBase object) {
        if (object instanceof COSObject) {
            return ((COSObject)object).getObject();
        }
        return object;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "alternate": {
                return this.getAlternate();
            }
            case "colorantName": {
                return this.getColorantName();
            }
            case "tintTransform": {
                return this.getTintTransform();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<org.verapdf.model.pdlayer.PDColorSpace> getAlternate() {
        PDColorSpace space = ((PDSeparation)this.simplePDObject).getAlternateColorSpace();
        org.verapdf.model.pdlayer.PDColorSpace currentSpace = ColorSpaceFactory.getColorSpace(space, this.document, this.flavour);
        if (currentSpace != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpace = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpace.add(currentSpace);
            return Collections.unmodifiableList(colorSpace);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getColorantName() {
        COSBase object;
        COSArray array = (COSArray)this.simplePDObject.getCOSObject();
        if (array.size() > 1 && (object = array.getObject(1)) instanceof COSName) {
            ArrayList<PBCosUnicodeName> list = new ArrayList<PBCosUnicodeName>(1);
            list.add(new PBCosUnicodeName((COSName)object));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PBoxPDFunction> getTintTransform() {
        return Collections.emptyList();
    }
}

