/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.actions;

import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDMediaClip;

public class PBoxPDMediaClip
extends PBoxPDObject
implements PDMediaClip {
    public static final String MEDIA_CLIP_TYPE = "PDMediaClip";
    public static final String CONTENT_TYPE = "CT";

    public PBoxPDMediaClip(COSDictionary simplePDObject) {
        super((COSObjectable)simplePDObject, MEDIA_CLIP_TYPE);
    }

    public String getCT() {
        return ((COSDictionary)this.simplePDObject).getNameAsString(COSName.getPDFName((String)CONTENT_TYPE));
    }

    public String getAlt() {
        COSBase object = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.ALT);
        LinkedList<String> list = new LinkedList<String>();
        if (object instanceof COSArray) {
            for (COSBase elem : (COSArray)object) {
                if (!(elem instanceof COSString)) continue;
                list.add(((COSString)elem).getString());
            }
        }
        return list.stream().filter(Objects::nonNull).collect(Collectors.joining(""));
    }

    public Boolean gethasCorrectAlt() {
        COSBase object = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.ALT);
        if (!(object instanceof COSArray)) {
            return false;
        }
        COSArray array = (COSArray)object;
        if (array.size() % 2 != 0) {
            return false;
        }
        for (int i = 0; i < array.size(); ++i) {
            COSBase elem = array.get(i);
            if (elem instanceof COSString && (i % 2 != 1 || !((COSString)elem).getString().isEmpty())) continue;
            return false;
        }
        return true;
    }
}

